/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.vectors;

import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.KnnFloatVectorQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.knn.KnnCollectorManager;
import org.apache.lucene.search.knn.KnnSearchStrategy;
import org.elasticsearch.search.profile.query.QueryProfiler;
import org.elasticsearch.search.vectors.PatienceCollectorManager;
import org.elasticsearch.search.vectors.QueryProfilerProvider;

public class ESKnnFloatVectorQuery
extends KnnFloatVectorQuery
implements QueryProfilerProvider {
    private final int kParam;
    private long vectorOpsCount;
    private final boolean earlyTermination;

    public ESKnnFloatVectorQuery(String field, float[] target, int k, int numCands, Query filter, KnnSearchStrategy strategy) {
        this(field, target, k, numCands, filter, strategy, false);
    }

    public ESKnnFloatVectorQuery(String field, float[] target, int k, int numCands, Query filter, KnnSearchStrategy strategy, boolean earlyTermination) {
        super(field, target, numCands, filter, strategy);
        this.kParam = k;
        this.earlyTermination = earlyTermination;
    }

    protected TopDocs mergeLeafResults(TopDocs[] perLeafResults) {
        TopDocs topK = TopDocs.merge((int)this.kParam, (TopDocs[])perLeafResults);
        this.vectorOpsCount = topK.totalHits.value();
        return topK;
    }

    @Override
    public void profile(QueryProfiler queryProfiler) {
        queryProfiler.addVectorOpsCount(this.vectorOpsCount);
    }

    public int kParam() {
        return this.kParam;
    }

    public KnnSearchStrategy getStrategy() {
        return this.searchStrategy;
    }

    protected KnnCollectorManager getKnnCollectorManager(int k, IndexSearcher searcher) {
        KnnCollectorManager knnCollectorManager = super.getKnnCollectorManager(k, searcher);
        return this.earlyTermination ? PatienceCollectorManager.wrap(knnCollectorManager) : knnCollectorManager;
    }
}

