/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.runtime;

import java.net.InetAddress;
import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.script.IpFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.runtime.AbstractIpScriptFieldQuery;

public class IpScriptFieldRangeQuery
extends AbstractIpScriptFieldQuery {
    private final BytesRef lower;
    private final BytesRef upper;

    public IpScriptFieldRangeQuery(Script script, IpFieldScript.LeafFactory leafFactory, String fieldName, BytesRef lower, BytesRef upper) {
        super(script, leafFactory, fieldName);
        this.lower = lower;
        this.upper = upper;
        assert (this.lower.compareTo(this.upper) <= 0);
    }

    @Override
    protected boolean matches(BytesRef[] values, int count) {
        for (int i = 0; i < count; ++i) {
            if (this.lower.compareTo(values[i]) > 0 || this.upper.compareTo(values[i]) < 0) continue;
            return true;
        }
        return false;
    }

    public final String toString(String field) {
        StringBuilder b = new StringBuilder();
        if (!this.fieldName().contentEquals(field)) {
            b.append(this.fieldName()).append(':');
        }
        b.append('[').append(InetAddresses.toAddrString(this.lowerAddress())).append(" TO ").append(InetAddresses.toAddrString(this.upperAddress())).append(']');
        return b.toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.lower, this.upper);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        IpScriptFieldRangeQuery other = (IpScriptFieldRangeQuery)((Object)obj);
        return this.lower.bytesEquals(other.lower) && this.upper.bytesEquals(other.upper);
    }

    InetAddress lowerAddress() {
        return IpScriptFieldRangeQuery.decode(this.lower);
    }

    InetAddress upperAddress() {
        return IpScriptFieldRangeQuery.decode(this.upper);
    }
}

