/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.ConjunctionUtils;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCache;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.lucene.search.BitsIterator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.search.dfs.AggregatedDfs;
import org.elasticsearch.search.internal.CancellableBulkScorer;
import org.elasticsearch.search.internal.ExitableDirectoryReader;
import org.elasticsearch.search.internal.TwoPhaseCollector;
import org.elasticsearch.search.profile.Timer;
import org.elasticsearch.search.profile.query.ProfileWeight;
import org.elasticsearch.search.profile.query.QueryProfileBreakdown;
import org.elasticsearch.search.profile.query.QueryProfiler;
import org.elasticsearch.search.profile.query.QueryTimingType;

public class ContextIndexSearcher
extends IndexSearcher
implements Releasable {
    private static final MatchNoDocsQuery REWRITE_TIMEOUT = new MatchNoDocsQuery("rewrite timed out");
    private static final int CHECK_CANCELLED_SCORER_INTERVAL = 2048;
    static final double MINIMUM_DOCS_PERCENT_PER_SLICE = 0.1;
    private AggregatedDfs aggregatedDfs;
    private QueryProfiler profiler;
    private final MutableQueryTimeout cancellable;
    private final boolean hasExecutor;
    private final int maximumNumberOfSlices;
    private final int minimumDocsPerSlice;
    private volatile boolean timeExceeded = false;
    private static final ThreadLocal<Boolean> timeoutOverwrites = ThreadLocal.withInitial(() -> false);

    public ContextIndexSearcher(IndexReader reader, Similarity similarity, QueryCache queryCache, QueryCachingPolicy queryCachingPolicy, boolean wrapWithExitableDirectoryReader) throws IOException {
        this(reader, similarity, queryCache, queryCachingPolicy, new MutableQueryTimeout(), wrapWithExitableDirectoryReader, null, -1, -1);
    }

    public ContextIndexSearcher(IndexReader reader, Similarity similarity, QueryCache queryCache, QueryCachingPolicy queryCachingPolicy, boolean wrapWithExitableDirectoryReader, Executor executor, int maximumNumberOfSlices, int minimumDocsPerSlice) throws IOException {
        this(reader, similarity, queryCache, queryCachingPolicy, new MutableQueryTimeout(), wrapWithExitableDirectoryReader, executor, maximumNumberOfSlices, minimumDocsPerSlice);
    }

    ContextIndexSearcher(IndexReader reader, Similarity similarity, QueryCache queryCache, QueryCachingPolicy queryCachingPolicy, MutableQueryTimeout cancellable, boolean wrapWithExitableDirectoryReader, Executor executor, int maximumNumberOfSlices, int minimumDocsPerSlice) throws IOException {
        super((IndexReader)(wrapWithExitableDirectoryReader ? new ExitableDirectoryReader((DirectoryReader)reader, cancellable) : reader), executor);
        this.hasExecutor = executor != null;
        this.setSimilarity(similarity);
        this.setQueryCache(queryCache);
        this.setQueryCachingPolicy(queryCachingPolicy);
        this.cancellable = cancellable;
        this.minimumDocsPerSlice = minimumDocsPerSlice;
        this.maximumNumberOfSlices = maximumNumberOfSlices;
    }

    public boolean hasExecutor() {
        return this.hasExecutor;
    }

    protected IndexSearcher.LeafSlice[] slices(List<LeafReaderContext> leaves) {
        IndexSearcher.LeafSlice[] leafSlices = ContextIndexSearcher.computeSlices(this.getLeafContexts(), this.maximumNumberOfSlices, this.minimumDocsPerSlice);
        assert (leafSlices.length <= this.maximumNumberOfSlices) : "more slices created than the maximum allowed";
        return leafSlices;
    }

    public void setProfiler(QueryProfiler profiler) {
        this.profiler = profiler;
    }

    public void addQueryCancellation(Runnable action) {
        this.cancellable.add(action);
    }

    public void removeQueryCancellation(Runnable action) {
        this.cancellable.remove(action);
    }

    public void close() {
        this.cancellable.clear();
    }

    public void clearQueryCancellations() {
        this.cancellable.clear();
    }

    public boolean hasCancellations() {
        return this.cancellable.isEnabled();
    }

    public void setAggregatedDfs(AggregatedDfs aggregatedDfs) {
        this.aggregatedDfs = aggregatedDfs;
    }

    public Query rewrite(Query original) throws IOException {
        Timer rewriteTimer = null;
        if (this.profiler != null) {
            rewriteTimer = this.profiler.startRewriteTime();
        }
        try {
            Query query = super.rewrite(original);
            return query;
        }
        catch (TimeExceededException e) {
            this.timeExceeded = true;
            MatchNoDocsQuery matchNoDocsQuery = REWRITE_TIMEOUT;
            return matchNoDocsQuery;
        }
        catch (IndexSearcher.TooManyClauses e) {
            throw new IllegalArgumentException("Query rewrite failed: too many clauses", e);
        }
        finally {
            if (this.profiler != null) {
                this.profiler.stopAndAddRewriteTime(rewriteTimer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Weight createWeight(Query query, ScoreMode scoreMode, float boost) throws IOException {
        if (this.profiler != null) {
            Weight weight;
            QueryProfileBreakdown profile = (QueryProfileBreakdown)this.profiler.getQueryBreakdown(query);
            Timer timer = profile.getNewTimer(QueryTimingType.CREATE_WEIGHT);
            timer.start();
            try {
                weight = query.createWeight((IndexSearcher)this, scoreMode, boost);
            }
            finally {
                timer.stop();
                this.profiler.pollLastElement();
            }
            return new ProfileWeight(query, weight, profile);
        }
        return super.createWeight(query, scoreMode, boost);
    }

    public static IndexSearcher.LeafSlice[] computeSlices(List<LeafReaderContext> leaves, int maxSliceNum, int minDocsPerSlice) {
        if (maxSliceNum < 1) {
            throw new IllegalArgumentException("maxSliceNum must be >= 1 (got " + maxSliceNum + ")");
        }
        if (maxSliceNum == 1) {
            return new IndexSearcher.LeafSlice[]{new IndexSearcher.LeafSlice(new ArrayList(leaves.stream().map(IndexSearcher.LeafReaderContextPartition::createForEntireSegment).collect(Collectors.toCollection(ArrayList::new))))};
        }
        int numDocs = leaves.stream().mapToInt(l -> l.reader().maxDoc()).sum();
        double percentageDocsPerThread = Math.max(0.1, 1.0 / (double)maxSliceNum);
        return ContextIndexSearcher.computeSlices(leaves, Math.max(minDocsPerSlice, (int)(percentageDocsPerThread * (double)numDocs)));
    }

    private static IndexSearcher.LeafSlice[] computeSlices(List<LeafReaderContext> leaves, int minDocsPerSlice) {
        ArrayList<LeafReaderContext> sortedLeaves = new ArrayList<LeafReaderContext>(leaves);
        sortedLeaves.sort((c1, c2) -> Integer.compare(c2.reader().maxDoc(), c1.reader().maxDoc()));
        PriorityQueue<List> queue = new PriorityQueue<List>((c1, c2) -> Integer.compare(ContextIndexSearcher.sumMaxDocValues(c1), ContextIndexSearcher.sumMaxDocValues(c2)));
        long docSum = 0L;
        ArrayList<LeafReaderContext> group = new ArrayList<LeafReaderContext>();
        for (LeafReaderContext ctx : sortedLeaves) {
            group.add(ctx);
            if ((docSum += (long)ctx.reader().maxDoc()) <= (long)minDocsPerSlice) continue;
            queue.add(group);
            group = new ArrayList();
            docSum = 0L;
        }
        if (group.size() > 0) {
            if (queue.size() == 0) {
                queue.add(group);
            } else {
                for (LeafReaderContext context : group) {
                    List head = (List)queue.poll();
                    head.add(context);
                    queue.add(head);
                }
            }
        }
        IndexSearcher.LeafSlice[] slices = new IndexSearcher.LeafSlice[queue.size()];
        int upto = 0;
        for (List currentLeaf : queue) {
            slices[upto++] = new IndexSearcher.LeafSlice((List)currentLeaf.stream().map(IndexSearcher.LeafReaderContextPartition::createForEntireSegment).collect(Collectors.toCollection(ArrayList::new)));
        }
        return slices;
    }

    private static int sumMaxDocValues(List<LeafReaderContext> l) {
        int sum = 0;
        for (LeafReaderContext lr : l) {
            sum += lr.reader().maxDoc();
        }
        return sum;
    }

    public <C extends Collector, T> T search(Query query, CollectorManager<C, T> collectorManager) throws IOException {
        Weight weight;
        Collector firstCollector = collectorManager.newCollector();
        query = firstCollector.scoreMode().needsScores() ? this.rewrite(query) : this.rewrite((Query)new ConstantScoreQuery(query));
        try {
            weight = this.createWeight(query, firstCollector.scoreMode(), 1.0f);
        }
        catch (TimeExceededException e) {
            this.timeExceeded = true;
            this.doAggregationPostCollection(firstCollector);
            return (T)collectorManager.reduce(Collections.singletonList(firstCollector));
        }
        return this.search(weight, collectorManager, firstCollector);
    }

    private <C extends Collector, T> T search(Weight weight, CollectorManager<C, T> collectorManager, C firstCollector) throws IOException {
        IndexSearcher.LeafSlice[] leafSlices = this.getSlices();
        if (leafSlices.length == 0) {
            assert (this.leafContexts.isEmpty());
            this.doAggregationPostCollection(firstCollector);
            return (T)collectorManager.reduce(Collections.singletonList(firstCollector));
        }
        ArrayList<Collector> collectors = new ArrayList<Collector>(leafSlices.length);
        collectors.add(firstCollector);
        ScoreMode scoreMode = firstCollector.scoreMode();
        for (int i = 1; i < leafSlices.length; ++i) {
            Collector collector = collectorManager.newCollector();
            collectors.add(collector);
            if (scoreMode == collector.scoreMode()) continue;
            throw new IllegalStateException("CollectorManager does not always produce collectors with the same score mode");
        }
        ArrayList<Callable<Collector>> listTasks = new ArrayList<Callable<Collector>>(leafSlices.length);
        for (int i = 0; i < leafSlices.length; ++i) {
            IndexSearcher.LeafReaderContextPartition[] leaves = leafSlices[i].partitions;
            Collector collector = (Collector)collectors.get(i);
            listTasks.add(() -> {
                this.search(leaves, weight, collector);
                return collector;
            });
        }
        List collectedCollectors = this.getTaskExecutor().invokeAll(listTasks);
        return (T)collectorManager.reduce((Collection)collectedCollectors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void search(IndexSearcher.LeafReaderContextPartition[] leaves, Weight weight, Collector collector) throws IOException {
        boolean success = false;
        try {
            super.search(leaves, weight, collector);
            success = true;
        }
        catch (TimeExceededException e) {
            this.timeExceeded = true;
        }
        finally {
            if (success || this.timeExceeded) {
                try {
                    assert (!timeoutOverwrites.get().booleanValue());
                    timeoutOverwrites.set(true);
                    this.doAggregationPostCollection(collector);
                }
                finally {
                    assert (timeoutOverwrites.get().booleanValue());
                    timeoutOverwrites.set(false);
                }
            }
        }
    }

    private void doAggregationPostCollection(Collector collector) throws IOException {
        if (collector instanceof TwoPhaseCollector) {
            TwoPhaseCollector twoPhaseCollector = (TwoPhaseCollector)collector;
            twoPhaseCollector.doPostCollection();
        }
    }

    public boolean timeExceeded() {
        return this.timeExceeded;
    }

    public void throwTimeExceededException() {
        if (!timeoutOverwrites.get().booleanValue()) {
            throw new TimeExceededException();
        }
    }

    protected void searchLeaf(LeafReaderContext ctx, int minDocId, int maxDocId, Weight weight, Collector collector) throws IOException {
        LeafCollector leafCollector;
        this.cancellable.checkCancelled();
        try {
            leafCollector = collector.getLeafCollector(ctx);
        }
        catch (CollectionTerminatedException e) {
            return;
        }
        Bits liveDocs = ctx.reader().getLiveDocs();
        int numDocs = ctx.reader().numDocs();
        int threshold = ctx.reader().maxDoc() >> 7;
        if (numDocs >= threshold) {
            BulkScorer bulkScorer = weight.bulkScorer(ctx);
            if (bulkScorer != null) {
                if (this.cancellable.isEnabled()) {
                    bulkScorer = new CancellableBulkScorer(bulkScorer, this.cancellable::checkCancelled);
                }
                try {
                    bulkScorer.score(leafCollector, liveDocs, minDocId, maxDocId);
                }
                catch (CollectionTerminatedException collectionTerminatedException) {}
            }
        } else {
            Scorer scorer = weight.scorer(ctx);
            if (scorer != null) {
                try {
                    ContextIndexSearcher.intersectScorerAndBitSet(scorer, liveDocs, leafCollector, this.cancellable.isEnabled() ? this.cancellable::checkCancelled : () -> {});
                }
                catch (CollectionTerminatedException collectionTerminatedException) {
                    // empty catch block
                }
            }
        }
        leafCollector.finish();
    }

    static void intersectScorerAndBitSet(Scorer scorer, Bits acceptDocs, LeafCollector collector, Runnable checkCancelled) throws IOException {
        collector.setScorer((Scorable)scorer);
        DocIdSetIterator iterator = ConjunctionUtils.intersectIterators(Arrays.asList(new DocIdSetIterator[]{new BitsIterator(acceptDocs), scorer.iterator()}));
        int seen = 0;
        checkCancelled.run();
        int docId = iterator.nextDoc();
        while (docId < Integer.MAX_VALUE) {
            if (++seen % 2048 == 0) {
                checkCancelled.run();
            }
            collector.collect(docId);
            docId = iterator.nextDoc();
        }
        checkCancelled.run();
    }

    public TermStatistics termStatistics(Term term, int docFreq, long totalTermFreq) throws IOException {
        TermStatistics termStatistics = this.termStatisticsFromDfs(term);
        if (termStatistics == null) {
            return super.termStatistics(term, docFreq, totalTermFreq);
        }
        return termStatistics;
    }

    public CollectionStatistics collectionStatistics(String field) throws IOException {
        if (this.aggregatedDfs == null) {
            return super.collectionStatistics(field);
        }
        CollectionStatistics collectionStatistics = this.aggregatedDfs.fieldStatistics().get(field);
        if (collectionStatistics == null) {
            return super.collectionStatistics(field);
        }
        return collectionStatistics;
    }

    public long docFreq(Term term, long docFreq) throws IOException {
        TermStatistics termStatistics = this.termStatisticsFromDfs(term);
        if (termStatistics == null) {
            return docFreq;
        }
        return termStatistics.docFreq();
    }

    public long totalTermFreq(Term term, long totalTermFreq) throws IOException {
        TermStatistics termStatistics = this.termStatisticsFromDfs(term);
        if (termStatistics == null) {
            return totalTermFreq;
        }
        return termStatistics.docFreq();
    }

    private TermStatistics termStatisticsFromDfs(Term term) {
        if (this.aggregatedDfs == null) {
            return null;
        }
        return this.aggregatedDfs.termStatistics().get(term);
    }

    public DirectoryReader getDirectoryReader() {
        IndexReader reader = this.getIndexReader();
        assert (reader instanceof DirectoryReader) : "expected an instance of DirectoryReader, got " + String.valueOf(reader.getClass());
        return (DirectoryReader)reader;
    }

    private static class MutableQueryTimeout
    implements ExitableDirectoryReader.QueryCancellation {
        private final List<Runnable> runnables = new ArrayList<Runnable>();

        private MutableQueryTimeout() {
        }

        private void add(Runnable action) {
            Objects.requireNonNull(action, "cancellation runnable should not be null");
            assert (!this.runnables.contains(action)) : "Cancellation runnable already added";
            this.runnables.add(action);
        }

        private void remove(Runnable action) {
            this.runnables.remove(action);
        }

        @Override
        public void checkCancelled() {
            for (Runnable timeout : this.runnables) {
                timeout.run();
            }
        }

        @Override
        public boolean isEnabled() {
            return !this.runnables.isEmpty();
        }

        public void clear() {
            this.runnables.clear();
        }
    }

    public static final class TimeExceededException
    extends RuntimeException {
        private TimeExceededException() {
        }
    }
}

