/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ConjunctionUtils;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.lucene.search.TopDocsAndMaxScore;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.SubSearchContext;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.search.profile.Profilers;

public final class InnerHitsContext {
    private final Map<String, InnerHitSubContext> innerHits;

    public InnerHitsContext() {
        this.innerHits = new HashMap<String, InnerHitSubContext>();
    }

    public InnerHitsContext(Map<String, InnerHitSubContext> innerHits) {
        this.innerHits = Objects.requireNonNull(innerHits);
    }

    public Map<String, InnerHitSubContext> getInnerHits() {
        return this.innerHits;
    }

    public void addInnerHitDefinition(InnerHitSubContext innerHit) {
        if (this.innerHits.containsKey(innerHit.getName())) {
            throw new IllegalArgumentException("inner_hit definition with the name [" + innerHit.getName() + "] already exists. Use a different inner_hit name or define one explicitly");
        }
        this.innerHits.put(innerHit.getName(), innerHit);
    }

    public static void intersect(Weight weight, Weight innerHitQueryWeight, Collector collector, LeafReaderContext ctx) throws IOException {
        LeafCollector leafCollector;
        ScorerSupplier scorerSupplier = weight.scorerSupplier(ctx);
        if (scorerSupplier == null) {
            return;
        }
        Scorer scorer = scorerSupplier.get(0L);
        ScorerSupplier innerHitQueryScorerSupplier = innerHitQueryWeight.scorerSupplier(ctx);
        if (innerHitQueryScorerSupplier == null) {
            return;
        }
        Scorer innerHitQueryScorer = innerHitQueryScorerSupplier.get(0L);
        try {
            leafCollector = collector.getLeafCollector(ctx);
            leafCollector.setScorer((Scorable)innerHitQueryScorer);
        }
        catch (CollectionTerminatedException e) {
            return;
        }
        try {
            Bits acceptDocs = ctx.reader().getLiveDocs();
            DocIdSetIterator iterator = ConjunctionUtils.intersectIterators(Arrays.asList(innerHitQueryScorer.iterator(), scorer.iterator()));
            int docId = iterator.nextDoc();
            while (docId < Integer.MAX_VALUE) {
                if (acceptDocs == null || acceptDocs.get(docId)) {
                    leafCollector.collect(docId);
                }
                docId = iterator.nextDoc();
            }
        }
        catch (CollectionTerminatedException collectionTerminatedException) {
            // empty catch block
        }
        leafCollector.finish();
    }

    public static abstract class InnerHitSubContext
    extends SubSearchContext {
        private final String name;
        protected final SearchContext context;
        private InnerHitsContext childInnerHits;
        private Weight innerHitQueryWeight;
        private String rootId;
        private Source rootSource;

        protected InnerHitSubContext(String name, SearchContext context) {
            super(context);
            this.name = name;
            this.context = context;
        }

        public InnerHitSubContext(InnerHitSubContext innerHitSubContext) {
            super(innerHitSubContext);
            this.name = innerHitSubContext.name;
            this.context = innerHitSubContext.context;
        }

        public abstract InnerHitSubContext copyWithSearchExecutionContext(SearchExecutionContext var1);

        public abstract TopDocsAndMaxScore topDocs(SearchHit var1) throws IOException;

        public String getName() {
            return this.name;
        }

        @Override
        public Profilers getProfilers() {
            return null;
        }

        @Override
        public InnerHitsContext innerHits() {
            return this.childInnerHits;
        }

        public void setChildInnerHits(Map<String, InnerHitSubContext> childInnerHits) {
            this.childInnerHits = new InnerHitsContext(childInnerHits);
        }

        protected Weight getInnerHitQueryWeight() throws IOException {
            if (this.innerHitQueryWeight == null) {
                boolean needsScores = this.size() != 0 && (this.sort() == null || this.sort().sort.needsScores());
                this.innerHitQueryWeight = this.context.searcher().createWeight(this.context.searcher().rewrite(this.query()), needsScores ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES, 1.0f);
            }
            return this.innerHitQueryWeight;
        }

        public SearchContext parentSearchContext() {
            return this.context;
        }

        public String getRootId() {
            return this.rootId;
        }

        public void setRootId(String rootId) {
            this.rootId = rootId;
        }

        public Source getRootLookup() {
            return this.rootSource;
        }

        public void setRootLookup(Source rootSource) {
            this.rootSource = rootSource;
        }
    }
}

