/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.zip.DataFormatException;
import org.HdrHistogram.DoubleHistogram;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorReducer;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.EmptyDoubleHdrHistogram;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.Percentile;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

abstract class AbstractInternalHDRPercentiles
extends InternalNumericMetricsAggregation.MultiValue {
    protected static final Iterator<Percentile> EMPTY_ITERATOR = Collections.emptyIterator();
    private static final DoubleHistogram EMPTY_HISTOGRAM_THREE_DIGITS = new DoubleHistogram(3);
    private static final DoubleHistogram EMPTY_HISTOGRAM_ZERO_DIGITS = new EmptyDoubleHdrHistogram();
    protected final double[] keys;
    protected final DoubleHistogram state;
    protected final boolean keyed;

    AbstractInternalHDRPercentiles(String name, double[] keys, DoubleHistogram state, boolean keyed, DocValueFormat format, Map<String, Object> metadata) {
        super(name, format, metadata);
        this.keys = keys;
        this.state = state;
        this.keyed = keyed;
    }

    protected AbstractInternalHDRPercentiles(StreamInput in) throws IOException {
        super(in);
        this.keys = in.readDoubleArray();
        this.state = in.readBoolean() ? this.decode(in) : null;
        this.keyed = in.readBoolean();
    }

    private DoubleHistogram decode(StreamInput in) throws IOException {
        long minBarForHighestToLowestValueRatio = in.readLong();
        int serializedLen = in.readVInt();
        byte[] bytes = new byte[serializedLen];
        in.readBytes(bytes, 0, serializedLen);
        ByteBuffer stateBuffer = ByteBuffer.wrap(bytes);
        try {
            return DoubleHistogram.decodeFromCompressedByteBuffer((ByteBuffer)stateBuffer, (long)minBarForHighestToLowestValueRatio);
        }
        catch (DataFormatException e) {
            throw new IOException("Failed to decode DoubleHistogram for aggregation [" + this.name + "]", e);
        }
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.format);
        out.writeDoubleArray(this.keys);
        if (this.state != null) {
            out.writeBoolean(true);
            AbstractInternalHDRPercentiles.encode(this.state, out);
        } else {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.keyed);
    }

    private static void encode(DoubleHistogram state, StreamOutput out) throws IOException {
        out.writeLong(state.getHighestToLowestValueRatio());
        ByteBuffer stateBuffer = ByteBuffer.allocate(state.getNeededByteBufferCapacity());
        int serializedLen = state.encodeIntoCompressedByteBuffer(stateBuffer);
        out.writeVInt(serializedLen);
        out.writeBytes(stateBuffer.array(), 0, serializedLen);
    }

    @Override
    public double value(String name) {
        if (this.keys.length == 1 && this.name.equals(name)) {
            return this.value(this.keys[0]);
        }
        return this.value(Double.parseDouble(name));
    }

    @Override
    public Iterable<String> valueNames() {
        return Arrays.stream(this.getKeys()).mapToObj(String::valueOf).toList();
    }

    public DocValueFormat formatter() {
        return this.format;
    }

    public abstract double value(double var1);

    public DoubleHistogram getState() {
        return this.state == null ? EMPTY_HISTOGRAM_ZERO_DIGITS : this.state;
    }

    public double[] getKeys() {
        return this.keys;
    }

    public boolean keyed() {
        return this.keyed;
    }

    @Override
    protected AggregatorReducer getLeaderReducer(AggregationReduceContext reduceContext, int size) {
        return new AggregatorReducer(){
            DoubleHistogram merged = null;

            @Override
            public void accept(InternalAggregation aggregation) {
                AbstractInternalHDRPercentiles percentiles = (AbstractInternalHDRPercentiles)aggregation;
                if (percentiles.state != null) {
                    if (this.merged == null) {
                        this.merged = new DoubleHistogram(percentiles.state);
                        this.merged.setAutoResize(true);
                    }
                    this.merged = AbstractInternalHDRPercentiles.merge(this.merged, percentiles.state);
                }
            }

            @Override
            public InternalAggregation get() {
                return AbstractInternalHDRPercentiles.this.createReduced(AbstractInternalHDRPercentiles.this.getName(), AbstractInternalHDRPercentiles.this.keys, this.merged == null ? EMPTY_HISTOGRAM_ZERO_DIGITS : this.merged, AbstractInternalHDRPercentiles.this.keyed, AbstractInternalHDRPercentiles.this.getMetadata());
            }
        };
    }

    private static DoubleHistogram merge(DoubleHistogram histogram1, DoubleHistogram histogram2) {
        DoubleHistogram moreDigits = histogram1;
        DoubleHistogram lessDigits = histogram2;
        if (histogram2.getNumberOfSignificantValueDigits() > histogram1.getNumberOfSignificantValueDigits()) {
            moreDigits = histogram2;
            lessDigits = histogram1;
        }
        moreDigits.setAutoResize(true);
        moreDigits.add(lessDigits);
        return moreDigits;
    }

    @Override
    public InternalAggregation finalizeSampling(SamplingContext samplingContext) {
        return this;
    }

    protected abstract AbstractInternalHDRPercentiles createReduced(String var1, double[] var2, DoubleHistogram var3, boolean var4, Map<String, Object> var5);

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        DoubleHistogram state = this.getState();
        if (this.keyed) {
            builder.startObject(Aggregation.CommonFields.VALUES.getPreferredName());
            for (double v : this.keys) {
                String key = String.valueOf(v);
                double value = this.value(v);
                builder.field(key, state.getTotalCount() == 0L ? null : Double.valueOf(value));
                if (this.format == DocValueFormat.RAW || state.getTotalCount() <= 0L) continue;
                builder.field(key + "_as_string", this.format.format(value).toString());
            }
            builder.endObject();
        } else {
            builder.startArray(Aggregation.CommonFields.VALUES.getPreferredName());
            for (double key : this.keys) {
                double value = this.value(key);
                builder.startObject();
                builder.field(Aggregation.CommonFields.KEY.getPreferredName(), key);
                builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), state.getTotalCount() == 0L ? null : Double.valueOf(value));
                if (this.format != DocValueFormat.RAW && state.getTotalCount() > 0L) {
                    builder.field(Aggregation.CommonFields.VALUE_AS_STRING.getPreferredName(), this.format.format(value).toString());
                }
                builder.endObject();
            }
            builder.endArray();
        }
        return builder;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AbstractInternalHDRPercentiles that = (AbstractInternalHDRPercentiles)obj;
        return this.keyed == that.keyed && Arrays.equals(this.keys, that.keys) && Objects.equals(this.state, that.state);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.keyed, Arrays.hashCode(this.keys), this.state != null ? this.state.getIntegerToDoubleValueConversionRatio() : 0.0, this.state != null ? this.state.getTotalCount() : 0L);
    }
}

