/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.LongValues;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedNumericLongValues;
import org.elasticsearch.search.aggregations.support.ValuesSource;

class RoundingValuesSource
extends ValuesSource.Numeric {
    private final ValuesSource.Numeric vs;
    private final Rounding.Prepared rounding;

    RoundingValuesSource(ValuesSource.Numeric vs, Rounding.Prepared rounding) {
        this.vs = vs;
        this.rounding = rounding;
    }

    @Override
    public boolean isFloatingPoint() {
        return false;
    }

    public long round(long value) {
        return this.rounding.round(value);
    }

    public double roundingSize(long milliSeconds, Rounding.DateTimeUnit unit) {
        return this.rounding.roundingSize(milliSeconds, unit);
    }

    public double roundingSize(Rounding.DateTimeUnit unit) {
        return this.rounding.roundingSize(unit);
    }

    @Override
    public SortedNumericLongValues longValues(LeafReaderContext context) throws IOException {
        SortedNumericLongValues values = this.vs.longValues(context);
        LongValues singleton = SortedNumericLongValues.unwrapSingleton(values);
        return singleton != null ? SortedNumericLongValues.singleton(this.longSingleValues(singleton)) : this.longMultiValues(values);
    }

    private SortedNumericLongValues longMultiValues(final SortedNumericLongValues values) {
        return new SortedNumericLongValues(){

            @Override
            public long nextValue() throws IOException {
                return RoundingValuesSource.this.round(values.nextValue());
            }

            @Override
            public int docValueCount() {
                return values.docValueCount();
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                return values.advanceExact(target);
            }
        };
    }

    private LongValues longSingleValues(final LongValues values) {
        return new LongValues(){

            public long longValue() throws IOException {
                return RoundingValuesSource.this.round(values.longValue());
            }

            public boolean advanceExact(int target) throws IOException {
                return values.advanceExact(target);
            }
        };
    }

    @Override
    public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
        throw new UnsupportedOperationException("not applicable");
    }

    @Override
    public SortedNumericDoubleValues doubleValues(LeafReaderContext context) throws IOException {
        throw new UnsupportedOperationException("not applicable");
    }
}

