/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.util.Map;
import java.util.function.LongConsumer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.index.mapper.OnScriptError;
import org.elasticsearch.script.AbstractFieldScript;
import org.elasticsearch.search.lookup.SearchLookup;

public abstract class AbstractLongFieldScript
extends AbstractFieldScript {
    private long[] values = new long[1];
    private int count;

    public AbstractLongFieldScript(String fieldName, Map<String, Object> params, SearchLookup searchLookup, OnScriptError onScriptError, LeafReaderContext ctx) {
        super(fieldName, params, searchLookup, ctx, onScriptError);
    }

    @Override
    protected void prepareExecute() {
        this.count = 0;
    }

    public final void runForDoc(int docId, LongConsumer consumer) {
        this.runForDoc(docId);
        for (int i = 0; i < this.count; ++i) {
            consumer.accept(this.values[i]);
        }
    }

    public final long[] values() {
        return this.values;
    }

    public final int count() {
        return this.count;
    }

    public final void emit(long v) {
        if (this.values.length < this.count + 1) {
            this.values = ArrayUtil.grow((long[])this.values, (int)(this.count + 1));
        }
        this.values[this.count++] = v;
    }
}

