/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.indices.resolve.ResolveIndexAction;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.search.crossproject.CrossProjectModeDecider;
import org.elasticsearch.xcontent.XContentParser;

@ServerlessScope(value=Scope.PUBLIC)
public class RestResolveIndexAction
extends BaseRestHandler {
    private static final Set<String> CAPABILITIES = Set.of("mode_filter");
    private final CrossProjectModeDecider crossProjectModeDecider;

    public RestResolveIndexAction(Settings settings) {
        this.crossProjectModeDecider = new CrossProjectModeDecider(settings);
    }

    @Override
    public String getName() {
        return "resolve_index_action";
    }

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_resolve/index/{name}"), new RestHandler.Route(RestRequest.Method.POST, "/_resolve/index/{name}"));
    }

    @Override
    public Set<String> supportedCapabilities() {
        return CAPABILITIES;
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] indices = Strings.splitStringByCommaToArray(request.param("name"));
        String modeParam = request.param("mode");
        boolean crossProjectEnabled = this.crossProjectModeDecider.crossProjectEnabled();
        AtomicReference projectRouting = new AtomicReference();
        IndicesOptions indicesOptions = IndicesOptions.fromRequest(request, ResolveIndexAction.Request.DEFAULT_INDICES_OPTIONS);
        if (crossProjectEnabled) {
            request.withContentOrSourceParamParserOrNull((CheckedConsumer<XContentParser, IOException>)((CheckedConsumer)parser -> {
                try {
                    if (parser != null) {
                        projectRouting.set(RestResolveIndexAction.parseProjectRouting(parser));
                    }
                }
                catch (Exception e) {
                    throw new ElasticsearchException("Couldn't parse request body", (Throwable)e, new Object[0]);
                }
            }));
            indicesOptions = IndicesOptions.builder(indicesOptions).crossProjectModeOptions(new IndicesOptions.CrossProjectModeOptions(true)).build();
        }
        ResolveIndexAction.Request resolveRequest = new ResolveIndexAction.Request(indices, indicesOptions, modeParam == null ? null : Arrays.stream(modeParam.split(",")).map(IndexMode::fromString).collect(() -> EnumSet.noneOf(IndexMode.class), AbstractCollection::add, AbstractCollection::addAll), (String)projectRouting.get());
        return channel -> client.admin().indices().resolveIndex(resolveRequest, new RestToXContentListener<ResolveIndexAction.Response>((RestChannel)channel));
    }

    private static String parseProjectRouting(XContentParser parser) throws ParsingException {
        try {
            XContentParser.Token first = parser.nextToken();
            if (first == null) {
                return null;
            }
            if (first != XContentParser.Token.START_OBJECT) {
                throw new ParsingException(parser.getTokenLocation(), "Expected [" + String.valueOf(XContentParser.Token.START_OBJECT) + "] but found [" + String.valueOf(first) + "]", parser.getTokenLocation());
            }
            String projectRouting = null;
            XContentParser.Token token = parser.nextToken();
            while (token != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    String currentName = parser.currentName();
                    if ("project_routing".equals(currentName)) {
                        parser.nextToken();
                        projectRouting = parser.text();
                    } else {
                        throw new ParsingException(parser.getTokenLocation(), "request does not support [" + parser.currentName() + "]", new Object[0]);
                    }
                }
                token = parser.nextToken();
            }
            return projectRouting;
        }
        catch (ParsingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParsingException(parser == null ? null : parser.getTokenLocation(), "Failed to parse", e, new Object[0]);
        }
    }
}

