/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import org.elasticsearch.action.admin.cluster.snapshots.get.SnapshotSortKey;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestRefCountedChunkedToXContentListener;
import org.elasticsearch.rest.action.admin.cluster.GetSnapshotsFeatures;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.snapshots.SnapshotState;

@ServerlessScope(value=Scope.INTERNAL)
public class RestGetSnapshotsAction
extends BaseRestHandler {
    private static final Set<String> SUPPORTED_RESPONSE_PARAMETERS = Set.of("include_repository", "index_details", "index_names");
    private static final Set<String> SUPPORTED_QUERY_PARAMETERS = Set.of("master_timeout", "after", "from_sort_value", "ignore_unavailable", "offset", "order", "size", "slm_policy_filter", "sort", "state", "verbose");
    private static final Set<String> ALL_SUPPORTED_PARAMETERS = Set.copyOf(Sets.union(SUPPORTED_QUERY_PARAMETERS, SUPPORTED_RESPONSE_PARAMETERS, Set.of("repository", "snapshot")));
    private final Predicate<NodeFeature> clusterSupportsFeature;

    public RestGetSnapshotsAction(Predicate<NodeFeature> clusterSupportsFeature) {
        this.clusterSupportsFeature = clusterSupportsFeature;
    }

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_snapshot/{repository}/{snapshot}"));
    }

    @Override
    public String getName() {
        return "get_snapshots_action";
    }

    @Override
    protected Set<String> responseParams() {
        return SUPPORTED_RESPONSE_PARAMETERS;
    }

    @Override
    public Set<String> supportedQueryParameters() {
        return SUPPORTED_QUERY_PARAMETERS;
    }

    @Override
    public Set<String> allSupportedParameters() {
        return ALL_SUPPORTED_PARAMETERS;
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String fromSortValue;
        String[] repositories = request.paramAsStringArray("repository", Strings.EMPTY_ARRAY);
        String[] snapshots = request.paramAsStringArray("snapshot", Strings.EMPTY_ARRAY);
        GetSnapshotsRequest getSnapshotsRequest = new GetSnapshotsRequest(RestUtils.getMasterNodeTimeout(request), repositories).snapshots(snapshots);
        getSnapshotsRequest.ignoreUnavailable(request.paramAsBoolean("ignore_unavailable", getSnapshotsRequest.ignoreUnavailable()));
        getSnapshotsRequest.verbose(request.paramAsBoolean("verbose", getSnapshotsRequest.verbose()));
        SnapshotSortKey sort = SnapshotSortKey.of(request.param("sort", getSnapshotsRequest.sort().toString()));
        getSnapshotsRequest.sort(sort);
        int size = request.paramAsInt("size", getSnapshotsRequest.size());
        getSnapshotsRequest.size(size);
        int offset = request.paramAsInt("offset", getSnapshotsRequest.offset());
        getSnapshotsRequest.offset(offset);
        String afterString = request.param("after");
        if (afterString != null) {
            getSnapshotsRequest.after(SnapshotSortKey.decodeAfterQueryParam(afterString));
        }
        if ((fromSortValue = request.param("from_sort_value")) != null) {
            getSnapshotsRequest.fromSortValue(fromSortValue);
        }
        String[] policies = request.paramAsStringArray("slm_policy_filter", Strings.EMPTY_ARRAY);
        getSnapshotsRequest.policies(policies);
        SortOrder order = SortOrder.fromString(request.param("order", getSnapshotsRequest.order().toString()));
        getSnapshotsRequest.order(order);
        getSnapshotsRequest.includeIndexNames(request.paramAsBoolean("index_names", getSnapshotsRequest.includeIndexNames()));
        String stateString = request.param("state");
        if (stateString == null) {
            getSnapshotsRequest.states(EnumSet.allOf(SnapshotState.class));
        } else {
            if (!Strings.hasText(stateString)) {
                throw new IllegalArgumentException("[state] parameter must not be empty");
            }
            if (this.clusterSupportsFeature.test(GetSnapshotsFeatures.GET_SNAPSHOTS_STATE_PARAMETER)) {
                getSnapshotsRequest.states(EnumSet.copyOf(Arrays.stream(stateString.split(",")).map(SnapshotState::valueOf).toList()));
            } else {
                throw new IllegalArgumentException("[state] parameter is not supported on all nodes in the cluster");
            }
        }
        return channel -> new RestCancellableNodeClient(client, request.getHttpChannel()).admin().cluster().getSnapshots(getSnapshotsRequest, new RestRefCountedChunkedToXContentListener<GetSnapshotsResponse>((RestChannel)channel));
    }
}

