/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.broadcast.BaseBroadcastResponse;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class RestActions {
    public static final ParseField _SHARDS_FIELD = new ParseField("_shards", new String[0]);
    public static final ParseField TOTAL_FIELD = new ParseField("total", new String[0]);
    public static final ParseField SUCCESSFUL_FIELD = new ParseField("successful", new String[0]);
    public static final ParseField SKIPPED_FIELD = new ParseField("skipped", new String[0]);
    public static final ParseField FAILED_FIELD = new ParseField("failed", new String[0]);
    public static final ParseField FAILURES_FIELD = new ParseField("failures", new String[0]);
    public static final ParseField PROJECT_ROUTING = new ParseField("project_routing", new String[0]);
    private static final String[] queryStringParams = new String[]{"df", "analyzer", "analyze_wildcard", "lenient", "default_operator"};

    public static long parseVersion(RestRequest request) {
        if (request.hasParam("version")) {
            return request.paramAsLong("version", -3L);
        }
        String ifMatch = request.header("If-Match");
        if (ifMatch != null) {
            return Long.parseLong(ifMatch);
        }
        return -3L;
    }

    public static long parseVersion(RestRequest request, long defaultVersion) {
        long version = RestActions.parseVersion(request);
        return version == -3L ? defaultVersion : version;
    }

    public static XContentBuilder buildBroadcastShardsHeader(XContentBuilder builder, ToXContent.Params params, BaseBroadcastResponse response) throws IOException {
        return RestActions.buildBroadcastShardsHeader(builder, params, response.getTotalShards(), response.getSuccessfulShards(), -1, response.getFailedShards(), response.getShardFailures());
    }

    public static XContentBuilder buildBroadcastShardsHeader(XContentBuilder builder, ToXContent.Params params, int total, int successful, int skipped, int failed, ShardOperationFailedException[] shardFailures) throws IOException {
        builder.startObject(_SHARDS_FIELD.getPreferredName());
        builder.field(TOTAL_FIELD.getPreferredName(), total);
        builder.field(SUCCESSFUL_FIELD.getPreferredName(), successful);
        if (skipped >= 0) {
            builder.field(SKIPPED_FIELD.getPreferredName(), skipped);
        }
        builder.field(FAILED_FIELD.getPreferredName(), failed);
        if (!CollectionUtils.isEmpty(shardFailures)) {
            builder.startArray(FAILURES_FIELD.getPreferredName());
            for (ShardOperationFailedException shardFailure : ExceptionsHelper.groupBy(shardFailures)) {
                shardFailure.toXContent(builder, params);
            }
            builder.endArray();
        }
        return builder.endObject();
    }

    public static <NodeResponse extends BaseNodeResponse> XContentBuilder buildNodesHeader(XContentBuilder builder, ToXContent.Params params, BaseNodesResponse<NodeResponse> response) throws IOException {
        int successful = response.getNodes().size();
        int failed = response.failures().size();
        RestActions.buildNodesHeader(builder, params, successful + failed, successful, failed, response.failures());
        return builder;
    }

    public static void buildNodesHeader(XContentBuilder builder, ToXContent.Params params, int total, int successful, int failed, List<FailedNodeException> failures) throws IOException {
        builder.startObject("_nodes");
        builder.field("total", total);
        builder.field("successful", successful);
        builder.field("failed", failed);
        if (!failures.isEmpty()) {
            builder.startArray("failures");
            for (FailedNodeException failure : failures) {
                builder.startObject();
                failure.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
        }
        builder.endObject();
    }

    public static <NodesResponse extends BaseNodesResponse> RestResponse nodesResponse(XContentBuilder builder, ToXContent.Params params, NodesResponse response) throws IOException {
        builder.startObject();
        RestActions.buildNodesHeader(builder, params, response);
        builder.field("cluster_name", response.getClusterName().value());
        ((ToXContent)response).toXContent(builder, params);
        builder.endObject();
        return new RestResponse(RestStatus.OK, builder);
    }

    public static QueryBuilder urlParamsToQueryBuilder(RestRequest request) {
        String queryString = request.param("q");
        if (queryString == null) {
            List<String> unconsumedParams = Arrays.stream(queryStringParams).filter(key -> request.param((String)key) != null).toList();
            if (!unconsumedParams.isEmpty()) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "request [%s] contains parameters %s but missing query string parameter 'q'.", request.path(), unconsumedParams.toString()));
            }
            return null;
        }
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery(queryString);
        queryBuilder.defaultField(request.param("df"));
        queryBuilder.analyzer(request.param("analyzer"));
        queryBuilder.analyzeWildcard(request.paramAsBoolean("analyze_wildcard", false));
        queryBuilder.lenient(request.paramAsBoolean("lenient", null));
        String defaultOperator = request.param("default_operator");
        if (defaultOperator != null) {
            queryBuilder.defaultOperator(Operator.fromString(defaultOperator));
        }
        return queryBuilder;
    }

    public static QueryBuilder getQueryContent(XContentParser parser) {
        return RestActions.getQueryContent(parser, null);
    }

    public static QueryBuilder getQueryContent(XContentParser parser, SearchRequest searchRequest) {
        try {
            QueryBuilder queryBuilder = null;
            XContentParser.Token first = parser.nextToken();
            if (first == null) {
                return null;
            }
            if (first != XContentParser.Token.START_OBJECT) {
                throw new ParsingException(parser.getTokenLocation(), "Expected [" + String.valueOf(XContentParser.Token.START_OBJECT) + "] but found [" + String.valueOf(first) + "]", parser.getTokenLocation());
            }
            XContentParser.Token token = parser.nextToken();
            while (token != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    String currentName = parser.currentName();
                    if ("query".equals(currentName)) {
                        queryBuilder = AbstractQueryBuilder.parseTopLevelQuery(parser);
                    } else if (PROJECT_ROUTING.match(currentName, parser.getDeprecationHandler()) && searchRequest != null) {
                        parser.nextToken();
                        searchRequest.setProjectRouting(parser.text());
                    } else {
                        throw new ParsingException(parser.getTokenLocation(), "request does not support [" + parser.currentName() + "]", new Object[0]);
                    }
                }
                token = parser.nextToken();
            }
            return queryBuilder;
        }
        catch (ParsingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParsingException(parser == null ? null : parser.getTokenLocation(), "Failed to parse", e, new Object[0]);
        }
    }

    public static class NodesResponseRestListener<NodesResponse extends BaseNodesResponse<?>>
    extends RestBuilderListener<NodesResponse> {
        public NodesResponseRestListener(RestChannel channel) {
            super(channel);
        }

        @Override
        public RestResponse buildResponse(NodesResponse response, XContentBuilder builder) throws Exception {
            return RestActions.nodesResponse(builder, this.channel.request(), response);
        }
    }
}

