/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.os;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.SingleObjectCache;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.monitor.os.OsInfo;
import org.elasticsearch.monitor.os.OsProbe;
import org.elasticsearch.monitor.os.OsStats;
import org.elasticsearch.node.ReportingService;

public class OsService
implements ReportingService<OsInfo> {
    private static final Logger logger = LogManager.getLogger(OsService.class);
    private final OsInfo info;
    private final SingleObjectCache<OsStats> osStatsCache;
    public static final Setting<TimeValue> REFRESH_INTERVAL_SETTING = Setting.timeSetting("monitor.os.refresh_interval", TimeValue.timeValueSeconds((long)1L), TimeValue.timeValueSeconds((long)1L), Setting.Property.NodeScope);

    public OsService(Settings settings) throws IOException {
        TimeValue refreshInterval = REFRESH_INTERVAL_SETTING.get(settings);
        this.info = OsProbe.getInstance().osInfo(refreshInterval.millis(), EsExecutors.nodeProcessors(settings));
        this.osStatsCache = new OsStatsCache(refreshInterval);
        logger.debug("using refresh_interval [{}]", (Object)refreshInterval);
    }

    @Override
    public OsInfo info() {
        return this.info;
    }

    public OsStats stats() {
        return this.osStatsCache.getOrRefresh();
    }

    private static class OsStatsCache
    extends SingleObjectCache<OsStats> {
        private static final OsStats MISSING = new OsStats(0L, new OsStats.Cpu(0, new double[0], 0), new OsStats.Mem(0L, 0L, 0L), new OsStats.Swap(0L, 0L), null);

        OsStatsCache(TimeValue interval) {
            super(interval, MISSING);
        }

        @Override
        protected OsStats refresh() {
            return OsProbe.getInstance().osStats();
        }

        @Override
        protected boolean needsRefresh() {
            return this.getNoRefresh() == MISSING || super.needsRefresh();
        }
    }
}

