/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.lucene.spatial;

import org.elasticsearch.geometry.Circle;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryCollection;
import org.elasticsearch.geometry.GeometryVisitor;
import org.elasticsearch.geometry.Line;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.MultiLine;
import org.elasticsearch.geometry.MultiPoint;
import org.elasticsearch.geometry.MultiPolygon;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.Polygon;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.lucene.spatial.DimensionalShapeType;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;

public class CentroidCalculator {
    private final CentroidCalculatorVisitor visitor = new CentroidCalculatorVisitor();

    public void add(Geometry geometry) {
        geometry.visit((GeometryVisitor)this.visitor);
    }

    public double getX() {
        return this.visitor.compSumX.value() / this.visitor.compSumWeight.value();
    }

    public double getY() {
        return this.visitor.compSumY.value() / this.visitor.compSumWeight.value();
    }

    public double sumWeight() {
        double sumWeight = this.visitor.compSumWeight.value();
        if (sumWeight < 0.0) {
            return 0.0;
        }
        return sumWeight;
    }

    public DimensionalShapeType getDimensionalShapeType() {
        return this.visitor.dimensionalShapeType;
    }

    private static class CentroidCalculatorVisitor
    implements GeometryVisitor<Void, IllegalArgumentException> {
        final CompensatedSum compSumX = new CompensatedSum(0.0, 0.0);
        final CompensatedSum compSumY = new CompensatedSum(0.0, 0.0);
        final CompensatedSum compSumWeight = new CompensatedSum(0.0, 0.0);
        DimensionalShapeType dimensionalShapeType = DimensionalShapeType.POINT;

        private CentroidCalculatorVisitor() {
        }

        public Void visit(Circle circle) {
            throw new IllegalArgumentException("invalid shape type found [Circle] while calculating centroid");
        }

        public Void visit(GeometryCollection<?> collection) {
            for (Geometry shape : collection) {
                shape.visit((GeometryVisitor)this);
            }
            return null;
        }

        public Void visit(Line line) {
            if (this.dimensionalShapeType != DimensionalShapeType.POLYGON) {
                this.visitLine(line.length(), arg_0 -> ((Line)line).getX(arg_0), arg_0 -> ((Line)line).getY(arg_0));
            }
            return null;
        }

        public Void visit(LinearRing ring) {
            throw new IllegalArgumentException("invalid shape type found [LinearRing] while calculating centroid");
        }

        public Void visit(MultiLine multiLine) {
            if (this.dimensionalShapeType != DimensionalShapeType.POLYGON) {
                for (Line line : multiLine) {
                    this.visit(line);
                }
            }
            return null;
        }

        public Void visit(MultiPoint multiPoint) {
            if (this.dimensionalShapeType == DimensionalShapeType.POINT) {
                for (Point point : multiPoint) {
                    this.visit(point);
                }
            }
            return null;
        }

        public Void visit(MultiPolygon multiPolygon) {
            for (Polygon polygon : multiPolygon) {
                this.visit(polygon);
            }
            return null;
        }

        public Void visit(Point point) {
            if (this.dimensionalShapeType == DimensionalShapeType.POINT) {
                this.visitPoint(point.getX(), point.getY());
            }
            return null;
        }

        public Void visit(Polygon polygon) {
            double[] centroidX = new double[1 + polygon.getNumberOfHoles()];
            double[] centroidY = new double[1 + polygon.getNumberOfHoles()];
            double[] weight = new double[1 + polygon.getNumberOfHoles()];
            this.visitLinearRing(polygon.getPolygon().length(), arg_0 -> ((LinearRing)polygon.getPolygon()).getX(arg_0), arg_0 -> ((LinearRing)polygon.getPolygon()).getY(arg_0), false, centroidX, centroidY, weight, 0);
            for (int i = 0; i < polygon.getNumberOfHoles(); ++i) {
                this.visitLinearRing(polygon.getHole(i).length(), arg_0 -> ((LinearRing)polygon.getHole(i)).getX(arg_0), arg_0 -> ((LinearRing)polygon.getHole(i)).getY(arg_0), true, centroidX, centroidY, weight, i + 1);
            }
            double sumWeight = 0.0;
            for (double w : weight) {
                sumWeight += w;
            }
            if (sumWeight == 0.0 && this.dimensionalShapeType != DimensionalShapeType.POLYGON) {
                this.visitLine(polygon.getPolygon().length(), arg_0 -> ((LinearRing)polygon.getPolygon()).getX(arg_0), arg_0 -> ((LinearRing)polygon.getPolygon()).getY(arg_0));
            } else {
                for (int i = 0; i < 1 + polygon.getNumberOfHoles(); ++i) {
                    this.addCoordinate(centroidX[i], centroidY[i], weight[i], DimensionalShapeType.POLYGON);
                }
            }
            return null;
        }

        public Void visit(Rectangle rectangle) {
            double diffY;
            double diffX = rectangle.getMaxX() - rectangle.getMinX();
            double rectWeight = Math.abs(diffX * (diffY = rectangle.getMaxY() - rectangle.getMinY()));
            if (rectWeight != 0.0) {
                double sumX = rectangle.getMaxX() + rectangle.getMinX();
                double sumY = rectangle.getMaxY() + rectangle.getMinY();
                this.addCoordinate(sumX / 2.0, sumY / 2.0, rectWeight, DimensionalShapeType.POLYGON);
            } else {
                Line line = new Line(new double[]{rectangle.getMinX(), rectangle.getMaxX()}, new double[]{rectangle.getMinY(), rectangle.getMaxY()});
                this.visit(line);
            }
            return null;
        }

        private void visitPoint(double x, double y) {
            this.addCoordinate(x, y, 1.0, DimensionalShapeType.POINT);
        }

        private void visitLine(int length, CoordinateSupplier x, CoordinateSupplier y) {
            for (int i = 0; i < length - 1; ++i) {
                double diffX = x.get(i) - x.get(i + 1);
                double diffY = y.get(i) - y.get(i + 1);
                double xAvg = (x.get(i) + x.get(i + 1)) / 2.0;
                double yAvg = (y.get(i) + y.get(i + 1)) / 2.0;
                double weight = Math.sqrt(diffX * diffX + diffY * diffY);
                if (weight == 0.0) {
                    this.visitPoint(x.get(i), y.get(i));
                    continue;
                }
                this.addCoordinate(xAvg, yAvg, weight, DimensionalShapeType.LINE);
            }
        }

        private void visitLinearRing(int length, CoordinateSupplier x, CoordinateSupplier y, boolean isHole, double[] centroidX, double[] centroidY, double[] weight, int idx) {
            int sign = isHole ? -1 : 1;
            double totalRingArea = 0.0;
            for (int i = 0; i < length - 1; ++i) {
                totalRingArea += x.get(i) * y.get(i + 1) - x.get(i + 1) * y.get(i);
            }
            totalRingArea /= 2.0;
            double sumX = 0.0;
            double sumY = 0.0;
            for (int i = 0; i < length - 1; ++i) {
                double twiceArea = x.get(i) * y.get(i + 1) - x.get(i + 1) * y.get(i);
                sumX += twiceArea * (x.get(i) + x.get(i + 1));
                sumY += twiceArea * (y.get(i) + y.get(i + 1));
            }
            centroidX[idx] = sumX / (6.0 * totalRingArea);
            centroidY[idx] = sumY / (6.0 * totalRingArea);
            weight[idx] = (double)sign * Math.abs(totalRingArea);
        }

        private void addCoordinate(double x, double y, double weight, DimensionalShapeType shapeType) {
            if (Double.isFinite(x) && Double.isFinite(y)) {
                if (this.dimensionalShapeType == shapeType) {
                    this.compSumX.add(x * weight);
                    this.compSumY.add(y * weight);
                    this.compSumWeight.add(weight);
                    this.dimensionalShapeType = shapeType;
                } else if (shapeType.compareTo(this.dimensionalShapeType) > 0) {
                    this.compSumX.reset(x * weight, 0.0);
                    this.compSumY.reset(y * weight, 0.0);
                    this.compSumWeight.reset(weight, 0.0);
                    this.dimensionalShapeType = shapeType;
                }
            }
        }
    }

    @FunctionalInterface
    private static interface CoordinateSupplier {
        public double get(int var1);
    }
}

