/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.SimulateBulkRequest;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.ingest.Pipeline;

public class SimulateIngestService
extends IngestService {
    private final Map<String, Pipeline> pipelineSubstitutions;

    public SimulateIngestService(IngestService ingestService, BulkRequest request) {
        super(ingestService);
        if (request instanceof SimulateBulkRequest) {
            SimulateBulkRequest simulateBulkRequest = (SimulateBulkRequest)request;
            try {
                this.pipelineSubstitutions = this.getPipelineSubstitutions(simulateBulkRequest.getPipelineSubstitutions(), ingestService);
            }
            catch (ElasticsearchException elasticEx) {
                throw elasticEx;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new IllegalArgumentException("Expecting a SimulateBulkRequest but got " + String.valueOf(request.getClass()));
        }
    }

    private Map<String, Pipeline> getPipelineSubstitutions(Map<String, Map<String, Object>> rawPipelineSubstitutions, IngestService ingestService) throws Exception {
        HashMap<String, Pipeline> parsedPipelineSubstitutions = new HashMap<String, Pipeline>();
        if (rawPipelineSubstitutions != null) {
            for (Map.Entry<String, Map<String, Object>> entry : rawPipelineSubstitutions.entrySet()) {
                String pipelineId = entry.getKey();
                Map<String, Object> pipelineConfig = entry.getValue();
                IngestService.validateNoSystemPropertiesInPipelineConfig(pipelineConfig);
                Pipeline pipeline = Pipeline.create(pipelineId, pipelineConfig, ingestService.getProcessorFactories(), ingestService.getScriptService(), ingestService.getProjectResolver().getProjectId(), nodeFeature -> ingestService.getFeatureService().clusterHasFeature(ingestService.getClusterService().state(), (NodeFeature)nodeFeature));
                parsedPipelineSubstitutions.put(pipelineId, pipeline);
            }
        }
        return parsedPipelineSubstitutions;
    }

    @Override
    public Pipeline getPipeline(String pipelineId) {
        Pipeline pipeline = this.pipelineSubstitutions.get(pipelineId);
        if (pipeline == null) {
            pipeline = super.getPipeline(pipelineId);
        }
        return pipeline;
    }

    @Override
    public Pipeline getPipeline(ProjectId projectId, String id) {
        Pipeline pipeline = this.pipelineSubstitutions.get(id);
        if (pipeline != null) {
            return pipeline;
        }
        return super.getPipeline(projectId, id);
    }
}

