/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.inference;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.VersionedNamedWriteable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class ModelSecrets
implements ToXContentObject,
VersionedNamedWriteable {
    public static final String SECRET_SETTINGS = "secret_settings";
    private static final String NAME = "inference_model_secrets";
    private final SecretSettings secretSettings;

    public ModelSecrets() {
        this.secretSettings = null;
    }

    public ModelSecrets(@Nullable SecretSettings secretSettings) {
        this.secretSettings = secretSettings;
    }

    public ModelSecrets(StreamInput in) throws IOException {
        this(in.readOptionalNamedWriteable(SecretSettings.class));
    }

    public SecretSettings getSecretSettings() {
        return this.secretSettings;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalNamedWriteable(this.secretSettings);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.secretSettings != null) {
            builder.field(SECRET_SETTINGS, (ToXContent)this.secretSettings);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.minimumCompatible();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelSecrets that = (ModelSecrets)o;
        return Objects.equals(this.secretSettings, that.secretSettings);
    }

    public int hashCode() {
        return Objects.hash(this.secretSettings);
    }
}

