/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.inference;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.core.Strings;

public enum InputType {
    INGEST,
    SEARCH,
    UNSPECIFIED,
    CLASSIFICATION,
    CLUSTERING,
    INTERNAL_SEARCH,
    INTERNAL_INGEST;

    private static final EnumSet<InputType> SUPPORTED_REQUEST_VALUES;

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static InputType fromString(String name) {
        return InputType.valueOf(name.trim().toUpperCase(Locale.ROOT));
    }

    public static InputType fromRestString(String name) {
        InputType inputType = InputType.fromString(name);
        if (inputType == INTERNAL_INGEST || inputType == INTERNAL_SEARCH) {
            throw new IllegalArgumentException(Strings.format((String)"Unrecognized input_type [%s]", (Object[])new Object[]{inputType}));
        }
        return inputType;
    }

    public static boolean isInternalTypeOrUnspecified(InputType inputType) {
        return inputType == INTERNAL_INGEST || inputType == INTERNAL_SEARCH || inputType == UNSPECIFIED;
    }

    public static boolean isIngest(InputType inputType) {
        return inputType == INGEST || inputType == INTERNAL_INGEST;
    }

    public static boolean isSpecified(InputType inputType) {
        return inputType != null && inputType != UNSPECIFIED;
    }

    public static String invalidInputTypeMessage(InputType inputType) {
        return org.elasticsearch.common.Strings.format("received invalid input type value [%s]", inputType.toString());
    }

    public static Map<InputType, String> validateInputTypeTranslationValues(Map<String, Object> inputTypeTranslation, ValidationException validationException) {
        if (inputTypeTranslation == null || inputTypeTranslation.isEmpty()) {
            return Map.of();
        }
        HashMap<InputType, String> translationMap = new HashMap<InputType, String>();
        for (Map.Entry<String, Object> entry : inputTypeTranslation.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof String) || org.elasticsearch.common.Strings.isNullOrEmpty((String)value)) {
                validationException.addValidationError(org.elasticsearch.common.Strings.format("Input type translation value for key [%s] must be a String that is not null and not empty, received: [%s], type: [%s].", key, value, value == null ? "null" : value.getClass().getSimpleName()));
                throw validationException;
            }
            try {
                InputType inputTypeKey = InputType.fromStringValidateSupportedRequestValue(key);
                translationMap.put(inputTypeKey, (String)value);
            }
            catch (Exception e) {
                validationException.addValidationError(org.elasticsearch.common.Strings.format("Invalid input type translation for key: [%s], is not a valid value. Must be one of %s", key, SUPPORTED_REQUEST_VALUES));
                throw validationException;
            }
        }
        return translationMap;
    }

    private static InputType fromStringValidateSupportedRequestValue(String name) {
        InputType inputType = InputType.fromRestString(name);
        if (!SUPPORTED_REQUEST_VALUES.contains((Object)inputType)) {
            throw new IllegalArgumentException(Strings.format((String)"Unrecognized input_type [%s], must be one of %s", (Object[])new Object[]{inputType, SUPPORTED_REQUEST_VALUES}));
        }
        return inputType;
    }

    static {
        SUPPORTED_REQUEST_VALUES = EnumSet.of(CLASSIFICATION, CLUSTERING, INGEST, SEARCH);
    }
}

