/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.inference;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.inference.InferenceString;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;

public record InferenceStringGroup(List<InferenceString> inferenceStrings) implements Writeable,
ToXContentObject
{
    private static final String CONTENT_FIELD = "content";
    public static final ConstructingObjectParser<InferenceStringGroup, Void> PARSER = new ConstructingObjectParser(InferenceStringGroup.class.getSimpleName(), args -> new InferenceStringGroup((List)args[0]));

    public InferenceStringGroup(StreamInput in) throws IOException {
        this(in.readCollectionAsImmutableList(InferenceString::new));
    }

    public InferenceStringGroup(InferenceString input) {
        this(Collections.singletonList(input));
    }

    public InferenceStringGroup(String input) {
        this(Collections.singletonList(new InferenceString(InferenceString.DataType.TEXT, input)));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.inferenceStrings);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(CONTENT_FIELD, this.inferenceStrings);
        builder.endObject();
        return builder;
    }

    public static InferenceStringGroup parse(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            return new InferenceStringGroup(Collections.singletonList(new InferenceString(InferenceString.DataType.TEXT, parser.text())));
        }
        if (token == XContentParser.Token.START_OBJECT || token == XContentParser.Token.START_ARRAY) {
            return (InferenceStringGroup)PARSER.apply(parser, null);
        }
        throw new XContentParseException("Unsupported token [" + String.valueOf(token) + "]");
    }

    public InferenceString value() {
        this.assertSingleElement();
        return this.inferenceStrings.getFirst();
    }

    public String textValue() {
        this.assertSingleElement();
        return InferenceString.textValue(this.inferenceStrings.getFirst());
    }

    private void assertSingleElement() {
        assert (this.inferenceStrings.size() == 1) : "Multiple-input InferenceStringGroup used in code path expecting a single input.";
    }

    public static List<InferenceString> toInferenceStringList(List<InferenceStringGroup> inferenceStringGroups) {
        return inferenceStringGroups.stream().map(group -> {
            assert (group.inferenceStrings.size() == 1) : "Multiple-input InferenceStringGroup passed to InferenceStringGroup.toStringList";
            return group.inferenceStrings.getFirst();
        }).toList();
    }

    public static List<String> toStringList(List<InferenceStringGroup> inferenceStringGroups) {
        return InferenceString.toStringList(InferenceStringGroup.toInferenceStringList(inferenceStringGroups));
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (arg_0, arg_1) -> InferenceString.PARSER.apply(arg_0, arg_1), new ParseField(CONTENT_FIELD, new String[0]));
    }
}

