/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.action.admin.indices.rollover.Condition;
import org.elasticsearch.action.admin.indices.rollover.MaxAgeCondition;
import org.elasticsearch.action.admin.indices.rollover.MaxDocsCondition;
import org.elasticsearch.action.admin.indices.rollover.MaxPrimaryShardDocsCondition;
import org.elasticsearch.action.admin.indices.rollover.MaxPrimaryShardSizeCondition;
import org.elasticsearch.action.admin.indices.rollover.MaxSizeCondition;
import org.elasticsearch.action.admin.indices.rollover.MinAgeCondition;
import org.elasticsearch.action.admin.indices.rollover.MinDocsCondition;
import org.elasticsearch.action.admin.indices.rollover.MinPrimaryShardDocsCondition;
import org.elasticsearch.action.admin.indices.rollover.MinPrimaryShardSizeCondition;
import org.elasticsearch.action.admin.indices.rollover.MinSizeCondition;
import org.elasticsearch.action.admin.indices.rollover.OptimalShardCountCondition;
import org.elasticsearch.action.resync.TransportResyncReplicationAction;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.index.mapper.BinaryFieldMapper;
import org.elasticsearch.index.mapper.BooleanFieldMapper;
import org.elasticsearch.index.mapper.BooleanScriptFieldType;
import org.elasticsearch.index.mapper.CompletionFieldMapper;
import org.elasticsearch.index.mapper.CompositeRuntimeField;
import org.elasticsearch.index.mapper.DataStreamTimestampFieldMapper;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.DateScriptFieldType;
import org.elasticsearch.index.mapper.DocCountFieldMapper;
import org.elasticsearch.index.mapper.DoubleScriptFieldType;
import org.elasticsearch.index.mapper.FieldAliasMapper;
import org.elasticsearch.index.mapper.FieldNamesFieldMapper;
import org.elasticsearch.index.mapper.GeoPointFieldMapper;
import org.elasticsearch.index.mapper.GeoPointScriptFieldType;
import org.elasticsearch.index.mapper.IdFieldMapper;
import org.elasticsearch.index.mapper.IgnoredFieldMapper;
import org.elasticsearch.index.mapper.IgnoredSourceFieldMapper;
import org.elasticsearch.index.mapper.IndexFieldMapper;
import org.elasticsearch.index.mapper.IndexModeFieldMapper;
import org.elasticsearch.index.mapper.IpFieldMapper;
import org.elasticsearch.index.mapper.IpScriptFieldType;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.KeywordScriptFieldType;
import org.elasticsearch.index.mapper.LongScriptFieldType;
import org.elasticsearch.index.mapper.LookupRuntimeFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperRegistry;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.NestedObjectMapper;
import org.elasticsearch.index.mapper.NestedPathFieldMapper;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.PassThroughObjectMapper;
import org.elasticsearch.index.mapper.RangeType;
import org.elasticsearch.index.mapper.RootObjectMapperNamespaceValidator;
import org.elasticsearch.index.mapper.RoutingFieldMapper;
import org.elasticsearch.index.mapper.RuntimeField;
import org.elasticsearch.index.mapper.SeqNoFieldMapper;
import org.elasticsearch.index.mapper.SourceFieldMapper;
import org.elasticsearch.index.mapper.TextFieldMapper;
import org.elasticsearch.index.mapper.TimeSeriesIdFieldMapper;
import org.elasticsearch.index.mapper.TimeSeriesRoutingHashFieldMapper;
import org.elasticsearch.index.mapper.VersionFieldMapper;
import org.elasticsearch.index.mapper.flattened.FlattenedFieldMapper;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.index.mapper.vectors.SparseVectorFieldMapper;
import org.elasticsearch.index.mapper.vectors.VectorsFormatProvider;
import org.elasticsearch.index.seqno.RetentionLeaseBackgroundSyncAction;
import org.elasticsearch.index.seqno.RetentionLeaseSyncAction;
import org.elasticsearch.index.seqno.RetentionLeaseSyncer;
import org.elasticsearch.index.shard.PrimaryReplicaSyncer;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.indices.store.IndicesStore;
import org.elasticsearch.injection.guice.AbstractModule;
import org.elasticsearch.plugins.FieldPredicate;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.internal.InternalVectorFormatProviderPlugin;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;

public class IndicesModule
extends AbstractModule {
    private final MapperRegistry mapperRegistry;
    private static final Map<String, MetadataFieldMapper.TypeParser> builtInMetadataMappers = IndicesModule.initBuiltInMetadataMappers();
    private static final Set<String> builtInMetadataFields = Collections.unmodifiableSet(builtInMetadataMappers.keySet());

    public IndicesModule(List<MapperPlugin> mapperPlugins, List<InternalVectorFormatProviderPlugin> vectorFormatProviderPlugins, RootObjectMapperNamespaceValidator namespaceValidator) {
        this.mapperRegistry = new MapperRegistry(IndicesModule.getMappers(mapperPlugins), IndicesModule.getRuntimeFields(mapperPlugins), IndicesModule.getMetadataMappers(mapperPlugins), IndicesModule.getFieldFilter(mapperPlugins), IndicesModule.getVectorFormatProviders(vectorFormatProviderPlugins), namespaceValidator);
    }

    public IndicesModule(List<MapperPlugin> mapperPlugins) {
        this(mapperPlugins, Collections.emptyList(), null);
    }

    public static List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return Arrays.asList(new NamedWriteableRegistry.Entry(Condition.class, "min_age", MinAgeCondition::new), new NamedWriteableRegistry.Entry(Condition.class, "min_docs", MinDocsCondition::new), new NamedWriteableRegistry.Entry(Condition.class, "min_size", MinSizeCondition::new), new NamedWriteableRegistry.Entry(Condition.class, "min_primary_shard_size", MinPrimaryShardSizeCondition::new), new NamedWriteableRegistry.Entry(Condition.class, "min_primary_shard_docs", MinPrimaryShardDocsCondition::new), new NamedWriteableRegistry.Entry(Condition.class, "max_age", MaxAgeCondition::new), new NamedWriteableRegistry.Entry(Condition.class, "max_docs", MaxDocsCondition::new), new NamedWriteableRegistry.Entry(Condition.class, "max_size", MaxSizeCondition::new), new NamedWriteableRegistry.Entry(Condition.class, "max_primary_shard_size", MaxPrimaryShardSizeCondition::new), new NamedWriteableRegistry.Entry(Condition.class, "max_primary_shard_docs", MaxPrimaryShardDocsCondition::new), new NamedWriteableRegistry.Entry(Condition.class, "optimal_shard_count", OptimalShardCountCondition::new));
    }

    public static List<NamedXContentRegistry.Entry> getNamedXContents() {
        return Arrays.asList(new NamedXContentRegistry.Entry(Condition.class, new ParseField("min_age", new String[0]), (p, c) -> MinAgeCondition.fromXContent(p)), new NamedXContentRegistry.Entry(Condition.class, new ParseField("min_docs", new String[0]), (p, c) -> MinDocsCondition.fromXContent(p)), new NamedXContentRegistry.Entry(Condition.class, new ParseField("min_size", new String[0]), (p, c) -> MinSizeCondition.fromXContent(p)), new NamedXContentRegistry.Entry(Condition.class, new ParseField("min_primary_shard_size", new String[0]), (p, c) -> MinPrimaryShardSizeCondition.fromXContent(p)), new NamedXContentRegistry.Entry(Condition.class, new ParseField("min_primary_shard_docs", new String[0]), (p, c) -> MinPrimaryShardDocsCondition.fromXContent(p)), new NamedXContentRegistry.Entry(Condition.class, new ParseField("max_age", new String[0]), (p, c) -> MaxAgeCondition.fromXContent(p)), new NamedXContentRegistry.Entry(Condition.class, new ParseField("max_docs", new String[0]), (p, c) -> MaxDocsCondition.fromXContent(p)), new NamedXContentRegistry.Entry(Condition.class, new ParseField("max_size", new String[0]), (p, c) -> MaxSizeCondition.fromXContent(p)), new NamedXContentRegistry.Entry(Condition.class, new ParseField("max_primary_shard_size", new String[0]), (p, c) -> MaxPrimaryShardSizeCondition.fromXContent(p)), new NamedXContentRegistry.Entry(Condition.class, new ParseField("max_primary_shard_docs", new String[0]), (p, c) -> MaxPrimaryShardDocsCondition.fromXContent(p)), new NamedXContentRegistry.Entry(Condition.class, new ParseField("optimal_shard_count", new String[0]), (p, c) -> OptimalShardCountCondition.fromXContent(p)));
    }

    public static Map<String, Mapper.TypeParser> getMappers(List<MapperPlugin> mapperPlugins) {
        LinkedHashMap<String, Mapper.TypeParser> mappers = new LinkedHashMap<String, Mapper.TypeParser>();
        for (NumberFieldMapper.NumberType numberType : NumberFieldMapper.NumberType.values()) {
            mappers.put(numberType.typeName(), numberType.parser());
        }
        for (Enum enum_ : RangeType.values()) {
            mappers.put(((RangeType)enum_).typeName(), ((RangeType)enum_).parser());
        }
        mappers.put("boolean", BooleanFieldMapper.PARSER);
        mappers.put("binary", BinaryFieldMapper.PARSER);
        mappers.put("completion", CompletionFieldMapper.PARSER);
        DateFieldMapper.Resolution milliseconds = DateFieldMapper.Resolution.MILLISECONDS;
        mappers.put(milliseconds.type(), DateFieldMapper.MILLIS_PARSER);
        DateFieldMapper.Resolution nanoseconds = DateFieldMapper.Resolution.NANOSECONDS;
        mappers.put(nanoseconds.type(), DateFieldMapper.NANOS_PARSER);
        mappers.put("alias", new FieldAliasMapper.TypeParser());
        mappers.put("flattened", FlattenedFieldMapper.PARSER);
        mappers.put("geo_point", GeoPointFieldMapper.PARSER);
        mappers.put("ip", IpFieldMapper.PARSER);
        mappers.put("keyword", KeywordFieldMapper.PARSER);
        mappers.put("object", new ObjectMapper.TypeParser());
        mappers.put("nested", new NestedObjectMapper.TypeParser());
        mappers.put("passthrough", new PassThroughObjectMapper.TypeParser());
        mappers.put("text", TextFieldMapper.PARSER);
        mappers.put("dense_vector", DenseVectorFieldMapper.PARSER);
        mappers.put("sparse_vector", SparseVectorFieldMapper.PARSER);
        for (MapperPlugin mapperPlugin : mapperPlugins) {
            for (Map.Entry<String, Mapper.TypeParser> entry : mapperPlugin.getMappers().entrySet()) {
                if (mappers.put(entry.getKey(), entry.getValue()) == null) continue;
                throw new IllegalArgumentException("Mapper [" + entry.getKey() + "] is already registered");
            }
        }
        return Collections.unmodifiableMap(mappers);
    }

    private static List<VectorsFormatProvider> getVectorFormatProviders(List<InternalVectorFormatProviderPlugin> vectorFormatProviderPlugins) {
        ArrayList<VectorsFormatProvider> vectorsFormatProviders = new ArrayList<VectorsFormatProvider>();
        for (InternalVectorFormatProviderPlugin plugin : vectorFormatProviderPlugins) {
            VectorsFormatProvider vectorsFormatProvider = plugin.getVectorsFormatProvider();
            if (vectorsFormatProvider == null) continue;
            vectorsFormatProviders.add(vectorsFormatProvider);
        }
        return Collections.unmodifiableList(vectorsFormatProviders);
    }

    private static Map<String, RuntimeField.Parser> getRuntimeFields(List<MapperPlugin> mapperPlugins) {
        LinkedHashMap<String, RuntimeField.Parser> runtimeParsers = new LinkedHashMap<String, RuntimeField.Parser>();
        runtimeParsers.put("boolean", BooleanScriptFieldType.PARSER);
        runtimeParsers.put(NumberFieldMapper.NumberType.LONG.typeName(), LongScriptFieldType.PARSER);
        runtimeParsers.put(NumberFieldMapper.NumberType.DOUBLE.typeName(), DoubleScriptFieldType.PARSER);
        runtimeParsers.put("ip", IpScriptFieldType.PARSER);
        runtimeParsers.put("date", DateScriptFieldType.PARSER);
        runtimeParsers.put("keyword", KeywordScriptFieldType.PARSER);
        runtimeParsers.put("geo_point", GeoPointScriptFieldType.PARSER);
        runtimeParsers.put("composite", CompositeRuntimeField.PARSER);
        runtimeParsers.put("lookup", LookupRuntimeFieldType.PARSER);
        for (MapperPlugin mapperPlugin : mapperPlugins) {
            for (Map.Entry<String, RuntimeField.Parser> entry : mapperPlugin.getRuntimeFields().entrySet()) {
                if (runtimeParsers.put(entry.getKey(), entry.getValue()) == null) continue;
                throw new IllegalArgumentException("Runtime field type [" + entry.getKey() + "] is already registered");
            }
        }
        return Collections.unmodifiableMap(runtimeParsers);
    }

    private static Map<String, MetadataFieldMapper.TypeParser> initBuiltInMetadataMappers() {
        LinkedHashMap<String, MetadataFieldMapper.TypeParser> builtInMetadataMappers = new LinkedHashMap<String, MetadataFieldMapper.TypeParser>();
        builtInMetadataMappers.put("_ignored", IgnoredFieldMapper.PARSER);
        builtInMetadataMappers.put("_id", IdFieldMapper.PARSER);
        builtInMetadataMappers.put("_routing", RoutingFieldMapper.PARSER);
        builtInMetadataMappers.put("_tsid", TimeSeriesIdFieldMapper.PARSER);
        builtInMetadataMappers.put("_ts_routing_hash", TimeSeriesRoutingHashFieldMapper.PARSER);
        builtInMetadataMappers.put("_index", IndexFieldMapper.PARSER);
        builtInMetadataMappers.put("_index_mode", IndexModeFieldMapper.PARSER);
        builtInMetadataMappers.put("_source", SourceFieldMapper.PARSER);
        builtInMetadataMappers.put("_ignored_source", IgnoredSourceFieldMapper.PARSER);
        builtInMetadataMappers.put("_nested_path", NestedPathFieldMapper.PARSER);
        builtInMetadataMappers.put("_version", VersionFieldMapper.PARSER);
        builtInMetadataMappers.put("_seq_no", SeqNoFieldMapper.PARSER);
        builtInMetadataMappers.put("_doc_count", DocCountFieldMapper.PARSER);
        builtInMetadataMappers.put("_data_stream_timestamp", DataStreamTimestampFieldMapper.PARSER);
        builtInMetadataMappers.put("_field_names", FieldNamesFieldMapper.PARSER);
        return Collections.unmodifiableMap(builtInMetadataMappers);
    }

    public static Map<String, MetadataFieldMapper.TypeParser> getMetadataMappers(List<MapperPlugin> mapperPlugins) {
        LinkedHashMap<String, MetadataFieldMapper.TypeParser> metadataMappers = new LinkedHashMap<String, MetadataFieldMapper.TypeParser>();
        int i = 0;
        Map.Entry<String, MetadataFieldMapper.TypeParser> fieldNamesEntry = null;
        for (Map.Entry<String, MetadataFieldMapper.TypeParser> entry : builtInMetadataMappers.entrySet()) {
            if (i < builtInMetadataMappers.size() - 1) {
                metadataMappers.put(entry.getKey(), entry.getValue());
            } else {
                assert (entry.getKey().equals("_field_names")) : "_field_names must be the last registered mapper, order counts";
                fieldNamesEntry = entry;
            }
            ++i;
        }
        assert (fieldNamesEntry != null);
        for (MapperPlugin mapperPlugin : mapperPlugins) {
            for (Map.Entry<String, MetadataFieldMapper.TypeParser> entry : mapperPlugin.getMetadataMappers().entrySet()) {
                if (entry.getKey().equals("_field_names")) {
                    throw new IllegalArgumentException("Plugin cannot contain metadata mapper [_field_names]");
                }
                if (metadataMappers.put(entry.getKey(), entry.getValue()) == null) continue;
                throw new IllegalArgumentException("MetadataFieldMapper [" + entry.getKey() + "] is already registered");
            }
        }
        metadataMappers.put((String)fieldNamesEntry.getKey(), fieldNamesEntry.getValue());
        return Collections.unmodifiableMap(metadataMappers);
    }

    public static Set<String> getBuiltInMetadataFields() {
        return builtInMetadataFields;
    }

    private static Function<String, FieldPredicate> getFieldFilter(List<MapperPlugin> mapperPlugins) {
        Function<String, FieldPredicate> fieldFilter = MapperPlugin.NOOP_FIELD_FILTER;
        for (MapperPlugin mapperPlugin : mapperPlugins) {
            fieldFilter = IndicesModule.and(fieldFilter, mapperPlugin.getFieldFilter());
        }
        return fieldFilter;
    }

    private static Function<String, FieldPredicate> and(Function<String, FieldPredicate> first, Function<String, FieldPredicate> second) {
        if (first == MapperPlugin.NOOP_FIELD_FILTER) {
            return second;
        }
        if (second == MapperPlugin.NOOP_FIELD_FILTER) {
            return first;
        }
        return index -> {
            FieldPredicate firstPredicate = (FieldPredicate)first.apply((String)index);
            FieldPredicate secondPredicate = (FieldPredicate)second.apply((String)index);
            if (firstPredicate == FieldPredicate.ACCEPT_ALL) {
                return secondPredicate;
            }
            if (secondPredicate == FieldPredicate.ACCEPT_ALL) {
                return firstPredicate;
            }
            return new FieldPredicate.And(firstPredicate, secondPredicate);
        };
    }

    @Override
    protected void configure() {
        this.bind(IndicesStore.class).asEagerSingleton();
        this.bind(IndicesClusterStateService.class).asEagerSingleton();
        this.bind(TransportResyncReplicationAction.class).asEagerSingleton();
        this.bind(PrimaryReplicaSyncer.class).asEagerSingleton();
        this.bind(RetentionLeaseSyncAction.class).asEagerSingleton();
        this.bind(RetentionLeaseBackgroundSyncAction.class).asEagerSingleton();
        this.bind(RetentionLeaseSyncer.class).asEagerSingleton();
    }

    public MapperRegistry getMapperRegistry() {
        return this.mapperRegistry;
    }
}

