/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.snapshots;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.repositories.ShardGeneration;
import org.elasticsearch.repositories.ShardSnapshotResult;
import org.elasticsearch.snapshots.AbortedSnapshotException;
import org.elasticsearch.snapshots.PausedSnapshotException;

public class IndexShardSnapshotStatus {
    private final AtomicReference<Stage> stage;
    private final AtomicReference<ShardGeneration> generation;
    private final AtomicReference<ShardSnapshotResult> shardSnapshotResult;
    private long startTimeMillis;
    private long totalTimeMillis;
    private int incrementalFileCount;
    private int totalFileCount;
    private int processedFileCount;
    private long totalSize;
    private long incrementalSize;
    private long processedSize;
    private String failure;
    private final SubscribableListener<AbortStatus> abortListeners = new SubscribableListener();
    private volatile String statusDescription;

    private IndexShardSnapshotStatus(Stage stage, long startTimeMillis, long totalTimeMillis, int incrementalFileCount, int totalFileCount, int processedFileCount, long incrementalSize, long totalSize, long processedSize, String failure, ShardGeneration generation, String statusDescription) {
        this.stage = new AtomicReference<Stage>(Objects.requireNonNull(stage));
        this.generation = new AtomicReference<ShardGeneration>(generation);
        this.shardSnapshotResult = new AtomicReference();
        this.startTimeMillis = startTimeMillis;
        this.totalTimeMillis = totalTimeMillis;
        this.incrementalFileCount = incrementalFileCount;
        this.totalFileCount = totalFileCount;
        this.processedFileCount = processedFileCount;
        this.totalSize = totalSize;
        this.processedSize = processedSize;
        this.incrementalSize = incrementalSize;
        this.failure = failure;
        this.updateStatusDescription(statusDescription);
    }

    public synchronized Copy moveToStarted(long startTimeMillis, int incrementalFileCount, int totalFileCount, long incrementalSize, long totalSize) {
        if (!this.stage.compareAndSet(Stage.INIT, Stage.STARTED)) {
            this.ensureNotAborted();
            assert (false) : "Should not try to move stage [" + String.valueOf((Object)this.stage.get()) + "] to [STARTED]";
            throw new IllegalStateException("Unable to move the shard snapshot status to [STARTED]: expecting [INIT] but got [" + String.valueOf((Object)this.stage.get()) + "]");
        }
        this.startTimeMillis = startTimeMillis;
        this.incrementalFileCount = incrementalFileCount;
        this.totalFileCount = totalFileCount;
        this.incrementalSize = incrementalSize;
        this.totalSize = totalSize;
        return this.asCopy();
    }

    public synchronized Copy moveToFinalize() {
        Stage prevStage = this.stage.compareAndExchange(Stage.STARTED, Stage.FINALIZE);
        switch (prevStage.ordinal()) {
            case 1: {
                this.abortListeners.onResponse(AbortStatus.NO_ABORT);
                break;
            }
            case 7: {
                throw new AbortedSnapshotException();
            }
            case 5: {
                throw new PausedSnapshotException();
            }
            default: {
                String message = Strings.format("Unable to move the shard snapshot status to [FINALIZE]: expecting [STARTED] but got [%s]", new Object[]{prevStage});
                assert (false) : message;
                throw new IllegalStateException(message);
            }
        }
        return this.asCopy();
    }

    public synchronized void moveToDone(long endTimeMillis, ShardSnapshotResult shardSnapshotResult) {
        assert (shardSnapshotResult != null);
        assert (shardSnapshotResult.getGeneration() != null);
        if (!this.stage.compareAndSet(Stage.FINALIZE, Stage.DONE)) {
            assert (false) : "Should not try to move stage [" + String.valueOf((Object)this.stage.get()) + "] to [DONE]";
            throw new IllegalStateException("Unable to move the shard snapshot status to [DONE]: expecting [FINALIZE] but got [" + String.valueOf((Object)this.stage.get()) + "]");
        }
        this.totalTimeMillis = Math.max(0L, endTimeMillis - this.startTimeMillis);
        this.shardSnapshotResult.set(shardSnapshotResult);
        this.generation.set(shardSnapshotResult.getGeneration());
    }

    public Stage getStage() {
        return this.stage.get();
    }

    public long getTotalTimeMillis() {
        return this.totalTimeMillis;
    }

    public void addAbortListener(ActionListener<AbortStatus> listener) {
        this.abortListeners.addListener(listener);
    }

    public void abortIfNotCompleted(String failure, Consumer<ActionListener<Releasable>> notifyRunner) {
        this.abortAndMoveToStageIfNotCompleted(Stage.ABORTED, failure, notifyRunner);
    }

    public void pauseIfNotCompleted(Consumer<ActionListener<Releasable>> notifyRunner) {
        this.abortAndMoveToStageIfNotCompleted(Stage.PAUSING, "paused for removal of node holding primary", notifyRunner);
    }

    private synchronized void abortAndMoveToStageIfNotCompleted(Stage newStage, String failure, Consumer<ActionListener<Releasable>> notifyRunner) {
        assert (newStage == Stage.ABORTED || newStage == Stage.PAUSING) : newStage;
        if (this.stage.compareAndSet(Stage.INIT, newStage) || this.stage.compareAndSet(Stage.STARTED, newStage)) {
            this.failure = failure;
            notifyRunner.accept(this.abortListeners.map(r -> {
                Releasables.closeExpectNoException((Releasable)r);
                return AbortStatus.ABORTED;
            }));
        }
    }

    public synchronized SnapshotsInProgress.ShardState moveToUnsuccessful(Stage newStage, String failure, long endTime) {
        assert (newStage == Stage.PAUSED || newStage == Stage.FAILURE) : newStage;
        if (newStage == Stage.PAUSED && this.stage.compareAndSet(Stage.PAUSING, Stage.PAUSED)) {
            this.totalTimeMillis = Math.max(0L, endTime - this.startTimeMillis);
            this.failure = failure;
            return SnapshotsInProgress.ShardState.PAUSED_FOR_NODE_REMOVAL;
        }
        this.moveToFailed(endTime, failure);
        return SnapshotsInProgress.ShardState.FAILED;
    }

    public synchronized void moveToFailed(long endTime, String failure) {
        if (this.stage.getAndSet(Stage.FAILURE) != Stage.FAILURE) {
            this.abortListeners.onResponse(AbortStatus.NO_ABORT);
            this.totalTimeMillis = Math.max(0L, endTime - this.startTimeMillis);
            this.failure = failure;
        }
    }

    public ShardGeneration generation() {
        return this.generation.get();
    }

    public ShardSnapshotResult getShardSnapshotResult() {
        assert (this.stage.get() == Stage.DONE) : this.stage.get();
        return this.shardSnapshotResult.get();
    }

    public void ensureNotAborted() {
        IndexShardSnapshotStatus.ensureNotAborted(this.stage.get());
    }

    public static void ensureNotAborted(Stage shardSnapshotStage) {
        switch (shardSnapshotStage.ordinal()) {
            case 7: {
                throw new AbortedSnapshotException();
            }
            case 5: {
                throw new PausedSnapshotException();
            }
        }
    }

    public boolean isPaused() {
        return this.stage.get() == Stage.PAUSED;
    }

    public synchronized void addProcessedFile(long size) {
        ++this.processedFileCount;
        this.processedSize += size;
    }

    public synchronized void addProcessedFiles(int count, long totalSize) {
        this.processedFileCount += count;
        this.processedSize += totalSize;
    }

    public void updateStatusDescription(String statusString) {
        assert (statusString != null);
        assert (!statusString.isEmpty());
        this.statusDescription = statusString;
    }

    public synchronized Copy asCopy() {
        return new Copy(this.stage.get(), this.startTimeMillis, this.totalTimeMillis, this.incrementalFileCount, this.totalFileCount, this.processedFileCount, this.incrementalSize, this.totalSize, this.processedSize, this.failure, this.statusDescription);
    }

    public static IndexShardSnapshotStatus newInitializing(ShardGeneration generation) {
        return new IndexShardSnapshotStatus(Stage.INIT, 0L, 0L, 0, 0, 0, 0L, 0L, 0L, null, generation, "initializing");
    }

    public static Copy newFailed(String failure) {
        assert (failure != null) : "expecting non null failure for a failed IndexShardSnapshotStatus";
        if (failure == null) {
            throw new IllegalArgumentException("A failure description is required for a failed IndexShardSnapshotStatus");
        }
        return new IndexShardSnapshotStatus(Stage.FAILURE, 0L, 0L, 0, 0, 0, 0L, 0L, 0L, failure, null, "initialized as failed").asCopy();
    }

    public static Copy newDone(long startTime, long totalTime, int incrementalFileCount, int fileCount, long incrementalSize, long size, ShardGeneration generation) {
        return new IndexShardSnapshotStatus(Stage.DONE, startTime, totalTime, incrementalFileCount, fileCount, incrementalFileCount, incrementalSize, size, incrementalSize, null, generation, "initialized as done").asCopy();
    }

    public String toString() {
        return "index shard snapshot status (stage=" + String.valueOf(this.stage) + ", startTimeMillis=" + this.startTimeMillis + ", totalTimeMillis=" + this.totalTimeMillis + ", incrementalFileCount=" + this.incrementalFileCount + ", totalFileCount=" + this.totalFileCount + ", processedFileCount=" + this.processedFileCount + ", incrementalSize=" + this.incrementalSize + ", totalSize=" + this.totalSize + ", processedSize=" + this.processedSize + ", failure='" + this.failure + "', statusDescription='" + this.statusDescription + "')";
    }

    public static enum Stage {
        INIT,
        STARTED,
        FINALIZE,
        DONE,
        FAILURE,
        PAUSING,
        PAUSED,
        ABORTED;

    }

    public static class Copy {
        private final Stage stage;
        private final long startTimeMillis;
        private final long totalTimeMillis;
        private final int incrementalFileCount;
        private final int totalFileCount;
        private final int processedFileCount;
        private final long totalSize;
        private final long processedSize;
        private final long incrementalSize;
        private final String failure;
        private final String statusDescription;

        public Copy(Stage stage, long startTime, long totalTime, int incrementalFileCount, int totalFileCount, int processedFileCount, long incrementalSize, long totalSize, long processedSize, String failure, String statusDescription) {
            this.stage = stage;
            this.startTimeMillis = startTime;
            this.totalTimeMillis = totalTime;
            this.incrementalFileCount = incrementalFileCount;
            this.totalFileCount = totalFileCount;
            this.processedFileCount = processedFileCount;
            this.totalSize = totalSize;
            this.processedSize = processedSize;
            this.incrementalSize = incrementalSize;
            this.failure = failure;
            this.statusDescription = statusDescription;
        }

        public Stage getStage() {
            return this.stage;
        }

        public long getStartTimeMillis() {
            return this.startTimeMillis;
        }

        public long getTotalTimeMillis() {
            return this.totalTimeMillis;
        }

        public int getIncrementalFileCount() {
            return this.incrementalFileCount;
        }

        public int getTotalFileCount() {
            return this.totalFileCount;
        }

        public int getProcessedFileCount() {
            return this.processedFileCount;
        }

        public long getIncrementalSize() {
            return this.incrementalSize;
        }

        public long getTotalSize() {
            return this.totalSize;
        }

        public long getProcessedSize() {
            return this.processedSize;
        }

        public String getFailure() {
            return this.failure;
        }

        public String getStatusDescription() {
            return this.statusDescription;
        }

        public String toString() {
            return "index shard snapshot status (stage=" + String.valueOf((Object)this.stage) + ", startTimeMillis=" + this.startTimeMillis + ", totalTimeMillis=" + this.totalTimeMillis + ", incrementalFileCount=" + this.incrementalFileCount + ", totalFileCount=" + this.totalFileCount + ", processedFileCount=" + this.processedFileCount + ", incrementalSize=" + this.incrementalSize + ", totalSize=" + this.totalSize + ", processedSize=" + this.processedSize + ", failure='" + this.failure + "', statusDescription='" + this.statusDescription + "')";
        }
    }

    public static enum AbortStatus {
        NO_ABORT,
        ABORTED;

    }
}

