/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.stats;

import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;

public class SearchStatsSettings {
    public static final TimeValue RECENT_READ_LOAD_HALF_LIFE_DEFAULT = TimeValue.timeValueMinutes((long)5L);
    static final TimeValue RECENT_READ_LOAD_HALF_LIFE_MIN = TimeValue.timeValueSeconds((long)1L);
    static final TimeValue RECENT_READ_LOAD_HALF_LIFE_MAX = TimeValue.timeValueDays((long)100000L);
    public static final Setting<TimeValue> RECENT_READ_LOAD_HALF_LIFE_SETTING = Setting.timeSetting("indices.stats.recent_read_load.half_life", RECENT_READ_LOAD_HALF_LIFE_DEFAULT, RECENT_READ_LOAD_HALF_LIFE_MIN, RECENT_READ_LOAD_HALF_LIFE_MAX, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile TimeValue recentReadLoadHalfLifeForNewShards = RECENT_READ_LOAD_HALF_LIFE_SETTING.getDefault(Settings.EMPTY);

    public SearchStatsSettings(ClusterSettings clusterSettings) {
        clusterSettings.initializeAndWatch(RECENT_READ_LOAD_HALF_LIFE_SETTING, value -> {
            this.recentReadLoadHalfLifeForNewShards = value;
        });
    }

    public TimeValue getRecentReadLoadHalfLifeForNewShards() {
        return this.recentReadLoadHalfLifeForNewShards;
    }
}

