/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.blockloader.docvalues;

import java.io.IOException;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;

public interface DenseVectorBlockLoaderProcessor<B extends BlockLoader.Builder> {
    public B createBuilder(BlockLoader.BlockFactory var1, int var2, int var3);

    public void process(float[] var1, B var2) throws IOException;

    public void process(byte[] var1, B var2) throws IOException;

    default public void appendNull(B builder) {
        builder.appendNull();
    }

    public String name();

    public static class DenseVectorSimilarityProcessor
    implements DenseVectorBlockLoaderProcessor<BlockLoader.DoubleBuilder> {
        private final DenseVectorFieldMapper.VectorSimilarityFunctionConfig config;

        public DenseVectorSimilarityProcessor(DenseVectorFieldMapper.VectorSimilarityFunctionConfig config) {
            this.config = config;
        }

        @Override
        public BlockLoader.DoubleBuilder createBuilder(BlockLoader.BlockFactory factory, int expectedCount, int dimensions) {
            return factory.doubles(expectedCount);
        }

        @Override
        public void process(float[] vector, BlockLoader.DoubleBuilder builder) {
            double similarity = this.config.similarityFunction().calculateSimilarity(vector, this.config.vector());
            builder.appendDouble(similarity);
        }

        @Override
        public void process(byte[] vector, BlockLoader.DoubleBuilder builder) {
            double similarity = this.config.similarityFunction().calculateSimilarity(vector, this.config.vectorAsBytes());
            builder.appendDouble(similarity);
        }

        @Override
        public String name() {
            return this.config.similarityFunction().function().toString();
        }
    }

    public static class DenseVectorLoaderProcessor
    implements DenseVectorBlockLoaderProcessor<BlockLoader.FloatBuilder> {
        @Override
        public BlockLoader.FloatBuilder createBuilder(BlockLoader.BlockFactory factory, int expectedCount, int dimensions) {
            return factory.denseVectors(expectedCount, dimensions);
        }

        @Override
        public void process(float[] vector, BlockLoader.FloatBuilder builder) {
            builder.beginPositionEntry();
            for (float f : vector) {
                builder.appendFloat(f);
            }
            builder.endPositionEntry();
        }

        @Override
        public void process(byte[] vector, BlockLoader.FloatBuilder builder) {
            builder.beginPositionEntry();
            for (byte b : vector) {
                builder.appendFloat(b);
            }
            builder.endPositionEntry();
        }

        @Override
        public String name() {
            return "Load";
        }
    }
}

