/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.blockloader.docvalues;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.blockloader.docvalues.BlockDocValuesReader;
import org.elasticsearch.index.mapper.blockloader.docvalues.CustomBinaryDocValuesReader;

public class BytesRefsFromCustomBinaryBlockLoader
extends BlockDocValuesReader.DocValuesBlockLoader {
    private final String fieldName;

    public BytesRefsFromCustomBinaryBlockLoader(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
        return factory.bytesRefs(expectedCount);
    }

    @Override
    public BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
        BinaryDocValues docValues = context.reader().getBinaryDocValues(this.fieldName);
        if (docValues == null) {
            return new BlockLoader.ConstantNullsReader();
        }
        return new BytesRefsFromCustomBinary(docValues);
    }

    static class BytesRefsFromCustomBinary
    extends AbstractBytesRefsFromBinary {
        private final CustomBinaryDocValuesReader reader = new CustomBinaryDocValuesReader();

        BytesRefsFromCustomBinary(BinaryDocValues docValues) {
            super(docValues);
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
            BlockLoader.OptionalColumnAtATimeReader direct;
            BlockLoader.Block block;
            BinaryDocValues binaryDocValues = this.docValues;
            if (binaryDocValues instanceof BlockLoader.OptionalColumnAtATimeReader && (block = (direct = (BlockLoader.OptionalColumnAtATimeReader)binaryDocValues).tryRead(factory, docs, offset, nullsFiltered, null, false, true)) != null) {
                return block;
            }
            return super.read(factory, docs, offset, nullsFiltered);
        }

        @Override
        public void read(int doc, BlockLoader.BytesRefBuilder builder) throws IOException {
            if (!this.docValues.advanceExact(doc)) {
                builder.appendNull();
                return;
            }
            BytesRef bytes = this.docValues.binaryValue();
            this.reader.read(bytes, builder);
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.BytesCustom";
        }
    }

    public static abstract class AbstractBytesRefsFromBinary
    extends BlockDocValuesReader {
        protected final BinaryDocValues docValues;

        public AbstractBytesRefsFromBinary(BinaryDocValues docValues) {
            this.docValues = docValues;
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
            try (BlockLoader.BytesRefBuilder builder = factory.bytesRefs(docs.count() - offset);){
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    this.read(doc, builder);
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            this.read(docId, (BlockLoader.BytesRefBuilder)builder);
        }

        @Override
        public int docId() {
            return this.docValues.docID();
        }

        public abstract void read(int var1, BlockLoader.BytesRefBuilder var2) throws IOException;
    }
}

