/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.blockloader.docvalues;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.search.fetch.StoredFieldsSpec;

public abstract class BlockDocValuesReader
implements BlockLoader.AllReader {
    private final Thread creationThread = Thread.currentThread();

    protected abstract int docId();

    @Override
    public final boolean canReuse(int startingDocID) {
        return this.creationThread == Thread.currentThread() && this.docId() <= startingDocID;
    }

    public abstract String toString();

    public static interface ToDouble {
        public double convert(long var1);
    }

    public static interface NumericDocValuesAccessor {
        public NumericDocValues numericDocValues();
    }

    public static abstract class DocValuesBlockLoader
    implements BlockLoader {
        public abstract BlockLoader.AllReader reader(LeafReaderContext var1) throws IOException;

        @Override
        public final BlockLoader.ColumnAtATimeReader columnAtATimeReader(LeafReaderContext context) throws IOException {
            return this.reader(context);
        }

        @Override
        public final BlockLoader.RowStrideReader rowStrideReader(LeafReaderContext context) throws IOException {
            return this.reader(context);
        }

        @Override
        public final StoredFieldsSpec rowStrideStoredFieldSpec() {
            return StoredFieldsSpec.NO_REQUIREMENTS;
        }

        @Override
        public boolean supportsOrdinals() {
            return false;
        }

        @Override
        public SortedSetDocValues ordinals(LeafReaderContext context) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

