/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Locale;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.cluster.routing.IndexRouting;
import org.elasticsearch.cluster.routing.RoutingHashBuilder;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.hash.MurmurHash3;
import org.elasticsearch.common.util.ByteUtils;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.DataStreamTimestampFieldMapper;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.IdFieldMapper;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.TimeSeriesIdFieldMapper;
import org.elasticsearch.index.mapper.TimeSeriesRoutingHashFieldMapper;
import org.elasticsearch.index.mapper.Uid;

public class TsidExtractingIdFieldMapper
extends IdFieldMapper {
    static final int DESCRIPTION_TSID_LIMIT = 1000;
    public static final TsidExtractingIdFieldMapper INSTANCE = new TsidExtractingIdFieldMapper();
    private static final long SEED = 0L;

    private TsidExtractingIdFieldMapper() {
        super(new IdFieldMapper.AbstractIdFieldType(){

            @Override
            public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
                throw new IllegalArgumentException("Fielddata is not supported on [_id] field in [time_series] indices");
            }
        });
    }

    public static BytesRef createField(DocumentParserContext context, RoutingHashBuilder routingBuilder, BytesRef tsid) {
        String id;
        long timestamp = DataStreamTimestampFieldMapper.extractTimestampValue(context.doc());
        if (routingBuilder != null) {
            byte[] suffix = new byte[16];
            id = TsidExtractingIdFieldMapper.createId(context.hasDynamicMappers(), routingBuilder, tsid, timestamp, suffix);
            IndexRouting.ExtractFromSource.ForRoutingPath indexRouting = (IndexRouting.ExtractFromSource.ForRoutingPath)context.indexSettings().getIndexRouting();
            assert (!context.getDynamicMappers().isEmpty() || !context.getDynamicRuntimeFields().isEmpty() || id.equals(indexRouting.createId(context.sourceToParse().getXContentType(), context.sourceToParse().source(), suffix)));
        } else if (context.sourceToParse().routing() != null) {
            int routingHash = TimeSeriesRoutingHashFieldMapper.decode(context.sourceToParse().routing());
            id = context.indexSettings().useTimeSeriesSyntheticId() ? TsidExtractingIdFieldMapper.createSyntheticId(tsid, timestamp, routingHash) : TsidExtractingIdFieldMapper.createId(routingHash, tsid, timestamp);
        } else {
            if (context.sourceToParse().id() == null) {
                throw new IllegalArgumentException("_ts_routing_hash was null but must be set because index [" + context.indexSettings().getIndexMetadata().getIndex().getName() + "] is in time_series mode");
            }
            id = context.sourceToParse().id();
        }
        if (context.sourceToParse().id() != null && !context.sourceToParse().id().equals(id)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "_id must be unset or set to [%s] but was [%s] because [%s] is in time_series mode", id, context.sourceToParse().id(), context.indexSettings().getIndexMetadata().getIndex().getName()));
        }
        assert (id != null);
        context.id(id);
        Field idField = context.indexSettings().useTimeSeriesSyntheticId() ? TsidExtractingIdFieldMapper.syntheticIdField(context.id()) : TsidExtractingIdFieldMapper.standardIdField(context.id());
        assert ("_id".equals(idField.name())) : idField.name();
        assert (idField.binaryValue() != null);
        context.doc().add((IndexableField)idField);
        return idField.binaryValue();
    }

    public static String createId(int routingHash, BytesRef tsid, long timestamp) {
        MurmurHash3.Hash128 hash = new MurmurHash3.Hash128();
        MurmurHash3.hash128(tsid.bytes, tsid.offset, tsid.length, 0L, hash);
        byte[] bytes = new byte[20];
        ByteUtils.writeIntLE(routingHash, bytes, 0);
        ByteUtils.writeLongLE(hash.h1, bytes, 4);
        ByteUtils.writeLongBE(timestamp, bytes, 12);
        return Strings.BASE_64_NO_PADDING_URL_ENCODER.encodeToString(bytes);
    }

    public static long extractTimestampFromId(byte[] id) {
        assert (id.length == 20);
        return ByteUtils.readLongBE(id, 12);
    }

    public static String createId(boolean dynamicMappersExists, RoutingHashBuilder routingBuilder, BytesRef tsid, long timestamp, byte[] suffix) {
        MurmurHash3.Hash128 hash = new MurmurHash3.Hash128();
        MurmurHash3.hash128(tsid.bytes, tsid.offset, tsid.length, 0L, hash);
        ByteUtils.writeLongLE(hash.h1, suffix, 0);
        ByteUtils.writeLongBE(timestamp, suffix, 8);
        String id = routingBuilder.createId(suffix, dynamicMappersExists ? () -> 0 : () -> {
            throw new IllegalStateException("Didn't find any fields to include in the routing which would be fine if there are dynamic mapping waiting but we couldn't find any of those either!");
        });
        assert (Uid.isURLBase64WithoutPadding(id));
        return id;
    }

    public static BytesRef createSyntheticIdBytesRef(BytesRef tsid, long timestamp, int routingHash) {
        byte[] bytes = new byte[tsid.length + 8 + 4];
        System.arraycopy(tsid.bytes, tsid.offset, bytes, 0, tsid.length);
        ByteUtils.writeLongBE(Long.MAX_VALUE - timestamp, bytes, tsid.length);
        ByteUtils.writeIntBE(routingHash, bytes, tsid.length + 8);
        return new BytesRef(bytes);
    }

    public static String createSyntheticId(BytesRef tsid, long timestamp, int routingHash) {
        BytesRef id = TsidExtractingIdFieldMapper.createSyntheticIdBytesRef(tsid, timestamp, routingHash);
        return Strings.BASE_64_NO_PADDING_URL_ENCODER.encodeToString(id.bytes);
    }

    public static BytesRef extractTimeSeriesIdFromSyntheticId(BytesRef id) {
        assert (id.length > 12);
        byte[] tsId = new byte[Math.toIntExact(id.length - 8 - 4)];
        System.arraycopy(id.bytes, id.offset, tsId, 0, tsId.length);
        return new BytesRef(tsId);
    }

    public static long extractTimestampFromSyntheticId(BytesRef id) {
        assert (id.length > 12);
        long delta = ByteUtils.readLongBE(id.bytes, id.offset + id.length - 8 - 4);
        long timestamp = Long.MAX_VALUE - delta;
        assert (timestamp >= 0L) : delta;
        return timestamp;
    }

    public static int extractRoutingHashFromSyntheticId(BytesRef id) {
        assert (id.length > 12);
        return ByteUtils.readIntBE(id.bytes, id.offset + id.length - 4);
    }

    public static BytesRef extractRoutingHashBytesFromSyntheticId(BytesRef id) {
        int hash = TsidExtractingIdFieldMapper.extractRoutingHashFromSyntheticId(id);
        return Uid.encodeId(TimeSeriesRoutingHashFieldMapper.encode(hash));
    }

    @Override
    public String documentDescription(DocumentParserContext context) {
        IndexableField timestampField;
        StringBuilder description = new StringBuilder("a time series document");
        IndexableField tsidField = context.doc().getField("_tsid");
        if (tsidField != null) {
            description.append(" with tsid ").append(TsidExtractingIdFieldMapper.tsidDescription(tsidField));
        }
        if ((timestampField = context.doc().getField("@timestamp")) != null) {
            String timestamp = DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.formatMillis(timestampField.numericValue().longValue());
            description.append(" at [").append(timestamp).append(']');
        }
        return description.toString();
    }

    @Override
    public String documentDescription(ParsedDocument parsedDocument) {
        IndexableField tsidField = parsedDocument.rootDoc().getField("_tsid");
        long timestamp = parsedDocument.rootDoc().getField("@timestamp").numericValue().longValue();
        String timestampStr = DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.formatMillis(timestamp);
        return "[" + parsedDocument.id() + "][" + TsidExtractingIdFieldMapper.tsidDescription(tsidField) + "@" + timestampStr + "]";
    }

    private static String tsidDescription(IndexableField tsidField) {
        String tsid = TimeSeriesIdFieldMapper.encodeTsid(tsidField.binaryValue()).toString();
        if (tsid.length() <= 1000) {
            return tsid;
        }
        return tsid.substring(0, 1000) + "...}";
    }

    @Override
    public String reindexId(String id) {
        return null;
    }
}

