/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.queries.intervals.IntervalsSource;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.IndexType;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.query.SearchExecutionContext;

public abstract class TextFamilyFieldType
extends StringFieldType {
    public static final String FALLBACK_FIELD_NAME_SUFFIX = "._original";
    private final boolean isSyntheticSourceEnabled;
    private final boolean isWithinMultiField;

    public TextFamilyFieldType(String name, IndexType indexType, boolean isStored, TextSearchInfo textSearchInfo, Map<String, String> meta, boolean isSyntheticSourceEnabled, boolean isWithinMultiField) {
        super(name, indexType, isStored, textSearchInfo, meta);
        this.isSyntheticSourceEnabled = isSyntheticSourceEnabled;
        this.isWithinMultiField = isWithinMultiField;
    }

    public boolean isSyntheticSourceEnabled() {
        return this.isSyntheticSourceEnabled;
    }

    public boolean isWithinMultiField() {
        return this.isWithinMultiField;
    }

    public String syntheticSourceFallbackFieldName() {
        return this.name() + FALLBACK_FIELD_NAME_SUFFIX;
    }

    public IntervalsSource termIntervals(BytesRef term, SearchExecutionContext context) {
        throw new IllegalArgumentException("Can only use interval queries on text fields - not on [" + this.name() + "] which is of type [" + this.typeName() + "]");
    }

    public IntervalsSource prefixIntervals(BytesRef prefix, SearchExecutionContext context) {
        throw new IllegalArgumentException("Can only use interval queries on text fields - not on [" + this.name() + "] which is of type [" + this.typeName() + "]");
    }

    public IntervalsSource fuzzyIntervals(String term, int maxDistance, int prefixLength, boolean transpositions, SearchExecutionContext context) {
        throw new IllegalArgumentException("Can only use interval queries on text fields - not on [" + this.name() + "] which is of type [" + this.typeName() + "]");
    }

    public IntervalsSource wildcardIntervals(BytesRef pattern, SearchExecutionContext context) {
        throw new IllegalArgumentException("Can only use interval queries on text fields - not on [" + this.name() + "] which is of type [" + this.typeName() + "]");
    }

    public IntervalsSource regexpIntervals(BytesRef pattern, SearchExecutionContext context) {
        throw new IllegalArgumentException("Can only use interval queries on text fields - not on [" + this.name() + "] which is of type [" + this.typeName() + "]");
    }

    public IntervalsSource rangeIntervals(BytesRef lowerTerm, BytesRef upperTerm, boolean includeLower, boolean includeUpper, SearchExecutionContext context) {
        throw new IllegalArgumentException("Can only use interval queries on text fields - not on [" + this.name() + "] which is of type [" + this.typeName() + "]");
    }

    public static final class ConditionalBlockLoaderWithIgnoreField
    extends BlockLoader.ConditionalBlockLoader {
        private LeafReaderContext lastContext;
        private DocIdSetIterator postings;
        private final String preferField;

        public ConditionalBlockLoaderWithIgnoreField(String preferField, BlockLoader preferLoader, BlockLoader fallbackLoader) {
            super(preferLoader, fallbackLoader);
            this.preferField = preferField;
        }

        private DocIdSetIterator loadPostings(LeafReaderContext context) throws IOException {
            if (context.reader().getFieldInfos().fieldInfo(this.preferField) == null) {
                return DocIdSetIterator.all((int)context.reader().maxDoc());
            }
            Terms terms = context.reader().terms("_ignored");
            if (terms == null) {
                SegmentReader segmentReader = Lucene.tryUnwrapSegmentReader(context.reader());
                if (segmentReader == null) {
                    return DocIdSetIterator.all((int)context.reader().maxDoc());
                }
                terms = segmentReader.terms("_ignored");
            }
            if (terms == null) {
                return null;
            }
            TermsEnum iterator = terms.iterator();
            if (iterator.seekExact(new BytesRef((CharSequence)this.preferField))) {
                return iterator.postings(null, 0);
            }
            return null;
        }

        @Override
        protected boolean canUsePreferLoaderForLeaf(LeafReaderContext context) throws IOException {
            if (this.lastContext != context) {
                this.lastContext = context;
                this.postings = this.loadPostings(context);
                if (this.postings != null) {
                    this.postings.nextDoc();
                }
            }
            return this.postings == null || this.postings.docID() == Integer.MAX_VALUE;
        }

        @Override
        protected boolean canUsePreferLoaderForDoc(int docId) throws IOException {
            if (this.postings == null) {
                return true;
            }
            int current = this.postings.docID();
            if (current < docId) {
                return this.postings.advance(docId) > docId;
            }
            return current > docId;
        }
    }
}

