/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.cluster.routing.IndexRouting;
import org.elasticsearch.cluster.routing.RoutingHashBuilder;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.fieldvisitor.LeafStoredFieldLoader;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.BlockStoredFieldsReader;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.TimeSeriesRoutingHashFieldMapper;
import org.elasticsearch.index.mapper.TsidExtractingIdFieldMapper;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.blockloader.docvalues.BlockDocValuesReader;

public sealed interface IdLoader {
    public static IdLoader create(IndexSettings indexSettings, MappingLookup mappingLookup) {
        if (indexSettings.getMode() == IndexMode.TIME_SERIES) {
            IndexRouting.ExtractFromSource.ForRoutingPath indexRouting = null;
            List<String> routingPaths = null;
            if (indexSettings.getIndexVersionCreated().before(IndexVersions.TIME_SERIES_ROUTING_HASH_IN_ID)) {
                indexRouting = (IndexRouting.ExtractFromSource.ForRoutingPath)indexSettings.getIndexRouting();
                routingPaths = indexSettings.getIndexMetadata().getRoutingPaths();
                for (String routingField : routingPaths) {
                    if (!routingField.contains("*")) continue;
                    TreeSet<String> matchingRoutingPaths = new TreeSet<String>(routingPaths);
                    for (Mapper mapper : mappingLookup.fieldMappers()) {
                        if (!(mapper instanceof KeywordFieldMapper) || !indexRouting.matchesField(mapper.fullPath())) continue;
                        matchingRoutingPaths.add(mapper.fullPath());
                    }
                    routingPaths = new ArrayList<String>(matchingRoutingPaths);
                    break;
                }
            }
            return IdLoader.createTsIdLoader(indexRouting, routingPaths, indexSettings.useTimeSeriesSyntheticId());
        }
        return IdLoader.fromLeafStoredFieldLoader();
    }

    public static IdLoader fromLeafStoredFieldLoader() {
        return new StoredIdLoader();
    }

    public static IdLoader createTsIdLoader(IndexRouting.ExtractFromSource.ForRoutingPath indexRouting, List<String> routingPaths, boolean useSyntheticId) {
        return new TsIdLoader(indexRouting, routingPaths, useSyntheticId);
    }

    public Leaf leaf(LeafStoredFieldLoader var1, LeafReader var2, int[] var3) throws IOException;

    public BlockLoader blockLoader();

    public static final class StoredIdLoader
    implements IdLoader {
        @Override
        public Leaf leaf(LeafStoredFieldLoader loader, LeafReader reader, int[] docIdsInLeaf) throws IOException {
            return new StoredLeaf(loader);
        }

        @Override
        public BlockLoader blockLoader() {
            return new BlockStoredFieldsReader.IdBlockLoader();
        }
    }

    public static final class TsIdLoader
    implements IdLoader {
        private final IndexRouting.ExtractFromSource.ForRoutingPath indexRouting;
        private final List<String> routingPaths;
        private final boolean useSyntheticId;

        TsIdLoader(IndexRouting.ExtractFromSource.ForRoutingPath indexRouting, List<String> routingPaths, boolean useSyntheticId) {
            this.routingPaths = routingPaths;
            this.indexRouting = indexRouting;
            this.useSyntheticId = useSyntheticId;
        }

        @Override
        public Leaf leaf(LeafStoredFieldLoader loader, LeafReader reader, int[] docIdsInLeaf) throws IOException {
            RoutingHashBuilder[] builders = null;
            if (this.indexRouting != null) {
                builders = new RoutingHashBuilder[docIdsInLeaf.length];
                for (int i = 0; i < builders.length; ++i) {
                    builders[i] = this.indexRouting.builder();
                }
                for (String routingField : this.routingPaths) {
                    SortedSetDocValues dv = DocValues.getSortedSet((LeafReader)reader, (String)routingField);
                    for (int i = 0; i < docIdsInLeaf.length; ++i) {
                        int docId = docIdsInLeaf[i];
                        RoutingHashBuilder builder = builders[i];
                        if (!dv.advanceExact(docId)) continue;
                        for (int j = 0; j < dv.docValueCount(); ++j) {
                            BytesRef routingValue = dv.lookupOrd(dv.nextOrd());
                            builder.addMatching(routingField, routingValue);
                        }
                    }
                }
            }
            String[] ids = new String[docIdsInLeaf.length];
            SortedDocValues tsIdDocValues = DocValues.getSorted((LeafReader)reader, (String)"_tsid");
            SortedNumericDocValues timestampDocValues = DocValues.getSortedNumeric((LeafReader)reader, (String)"@timestamp");
            SortedDocValues routingHashDocValues = builders == null ? DocValues.getSorted((LeafReader)reader, (String)"_ts_routing_hash") : null;
            for (int i = 0; i < docIdsInLeaf.length; ++i) {
                int docId = docIdsInLeaf[i];
                boolean found = tsIdDocValues.advanceExact(docId);
                assert (found);
                BytesRef tsid = tsIdDocValues.lookupOrd(tsIdDocValues.ordValue());
                found = timestampDocValues.advanceExact(docId);
                assert (found);
                assert (timestampDocValues.docValueCount() == 1);
                long timestamp = timestampDocValues.nextValue();
                if (builders != null) {
                    RoutingHashBuilder routingBuilder = builders[i];
                    ids[i] = TsidExtractingIdFieldMapper.createId(false, routingBuilder, tsid, timestamp, new byte[16]);
                    continue;
                }
                found = routingHashDocValues.advanceExact(docId);
                assert (found);
                BytesRef routingHashBytes = routingHashDocValues.lookupOrd(routingHashDocValues.ordValue());
                int routingHash = TimeSeriesRoutingHashFieldMapper.decode(Uid.decodeId(routingHashBytes.bytes, routingHashBytes.offset, routingHashBytes.length));
                ids[i] = this.useSyntheticId ? TsidExtractingIdFieldMapper.createSyntheticId(tsid, timestamp, routingHash) : TsidExtractingIdFieldMapper.createId(routingHash, tsid, timestamp);
            }
            return new TsIdLeaf(docIdsInLeaf, ids);
        }

        @Override
        public BlockLoader blockLoader() {
            return new BlockDocValuesReader.DocValuesBlockLoader(){

                @Override
                public BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
                    if (indexRouting != null) {
                        return new LegacyTsIdFieldReader(context.reader(), indexRouting, routingPaths);
                    }
                    return new TsIdFieldReader(context.reader(), useSyntheticId);
                }

                @Override
                public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
                    return factory.bytesRefs(expectedCount);
                }
            };
        }

        private static class LegacyTsIdFieldReader
        extends BlockDocValuesReader {
            final RoutingHashBuilder routingBuilder;
            final SortedDocValues tsidDVs;
            final SortedNumericDocValues timestampDVs;
            final SortedDocValues[] routingHashDVs;
            final List<String> routingPaths;
            final byte[] scratch = new byte[16];

            LegacyTsIdFieldReader(LeafReader leafReader, IndexRouting.ExtractFromSource.ForRoutingPath indexRouting, List<String> routingPaths) throws IOException {
                this.routingBuilder = indexRouting.builder();
                this.routingPaths = routingPaths;
                this.routingHashDVs = new SortedDocValues[routingPaths.size()];
                for (int i = 0; i < routingPaths.size(); ++i) {
                    this.routingHashDVs[i] = DocValues.getSorted((LeafReader)leafReader, (String)routingPaths.get(i));
                }
                this.tsidDVs = DocValues.getSorted((LeafReader)leafReader, (String)"_tsid");
                this.timestampDVs = DocValues.getSortedNumeric((LeafReader)leafReader, (String)"@timestamp");
            }

            @Override
            protected int docId() {
                return this.tsidDVs.docID();
            }

            @Override
            public String toString() {
                return "LegacyTsIdFieldReader";
            }

            @Override
            public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
                try (BlockLoader.BytesRefBuilder builder = factory.bytesRefs(docs.count() - offset);){
                    for (int i = offset; i < docs.count(); ++i) {
                        this.read(docs.get(i), null, builder);
                    }
                    BlockLoader.Block block = builder.build();
                    return block;
                }
            }

            @Override
            public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
                if (!this.tsidDVs.advanceExact(docId) || !this.timestampDVs.advanceExact(docId)) {
                    assert (false) : "_tsid or @timestamp missing for docId " + docId;
                    throw new IllegalStateException("_tsid or @timestamp missing for docId " + docId);
                }
                this.routingBuilder.clear();
                BytesRef tsid = this.tsidDVs.lookupOrd(this.tsidDVs.ordValue());
                long timestamp = this.timestampDVs.nextValue();
                for (int i = 0; i < this.routingHashDVs.length; ++i) {
                    SortedDocValues dv = this.routingHashDVs[i];
                    if (!dv.advanceExact(docId)) continue;
                    BytesRef v = dv.lookupOrd(dv.ordValue());
                    this.routingBuilder.addMatching(this.routingPaths.get(i), v);
                }
                String id = TsidExtractingIdFieldMapper.createId(false, this.routingBuilder, tsid, timestamp, this.scratch);
                ((BlockLoader.BytesRefBuilder)builder).appendBytesRef(new BytesRef((CharSequence)id));
            }
        }

        private static class TsIdFieldReader
        extends BlockDocValuesReader {
            final SortedDocValues tsidDVs;
            final SortedNumericDocValues timestampDVs;
            final SortedDocValues routingHashDVs;
            final boolean useSyntheticId;

            TsIdFieldReader(LeafReader leafReader, boolean useSyntheticId) throws IOException {
                this.tsidDVs = DocValues.getSorted((LeafReader)leafReader, (String)"_tsid");
                this.timestampDVs = DocValues.getSortedNumeric((LeafReader)leafReader, (String)"@timestamp");
                this.routingHashDVs = DocValues.getSorted((LeafReader)leafReader, (String)"_ts_routing_hash");
                this.useSyntheticId = useSyntheticId;
            }

            @Override
            protected int docId() {
                return this.tsidDVs.docID();
            }

            @Override
            public String toString() {
                return "TsIdFieldReader";
            }

            @Override
            public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
                try (BlockLoader.BytesRefBuilder builder = factory.bytesRefs(docs.count() - offset);){
                    for (int i = offset; i < docs.count(); ++i) {
                        this.read(docs.get(i), null, builder);
                    }
                    BlockLoader.Block block = builder.build();
                    return block;
                }
            }

            @Override
            public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
                if (!(this.tsidDVs.advanceExact(docId) && this.timestampDVs.advanceExact(docId) && this.routingHashDVs.advanceExact(docId))) {
                    assert (false) : "_tsid or @timestamp or _ts_routing_hash missing for docId " + docId;
                    throw new IllegalStateException("_tsid or @timestamp or _ts_routing_hash missing for docId " + docId);
                }
                BytesRef tsid = this.tsidDVs.lookupOrd(this.tsidDVs.ordValue());
                long timestamp = this.timestampDVs.nextValue();
                BytesRef routingHashBytes = this.routingHashDVs.lookupOrd(this.routingHashDVs.ordValue());
                int routingHash = TimeSeriesRoutingHashFieldMapper.decode(Uid.decodeId(routingHashBytes.bytes, routingHashBytes.offset, routingHashBytes.length));
                String id = this.useSyntheticId ? TsidExtractingIdFieldMapper.createSyntheticId(tsid, timestamp, routingHash) : TsidExtractingIdFieldMapper.createId(routingHash, tsid, timestamp);
                ((BlockLoader.BytesRefBuilder)builder).appendBytesRef(new BytesRef((CharSequence)id));
            }
        }
    }

    public static final class StoredLeaf
    implements Leaf {
        private final LeafStoredFieldLoader loader;

        StoredLeaf(LeafStoredFieldLoader loader) {
            this.loader = loader;
        }

        @Override
        public String getId(int subDocId) {
            return this.loader.id();
        }
    }

    public static final class TsIdLeaf
    implements Leaf {
        private final String[] ids;
        private final int[] docIdsInLeaf;
        private int idx = -1;

        TsIdLeaf(int[] docIdsInLeaf, String[] ids) {
            this.ids = ids;
            this.docIdsInLeaf = docIdsInLeaf;
        }

        @Override
        public String getId(int subDocId) {
            ++this.idx;
            if (this.docIdsInLeaf[this.idx] != subDocId) {
                throw new IllegalArgumentException("expected to be called with [" + this.docIdsInLeaf[this.idx] + "] but was called with " + subDocId + " instead");
            }
            return this.ids[this.idx];
        }
    }

    public static sealed interface Leaf
    permits StoredLeaf, TsIdLeaf {
        public String getId(int var1);
    }
}

