/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.util.LocaleUtils;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.fielddata.DateScriptFieldData;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.mapper.AbstractScriptFieldType;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.DateScriptBlockDocValuesReader;
import org.elasticsearch.index.mapper.FallbackSyntheticSourceBlockLoader;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.OnScriptError;
import org.elasticsearch.index.mapper.RuntimeField;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.CompositeFieldScript;
import org.elasticsearch.script.DateFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.runtime.LongScriptFieldDistanceFeatureQuery;
import org.elasticsearch.search.runtime.LongScriptFieldExistsQuery;
import org.elasticsearch.search.runtime.LongScriptFieldRangeQuery;
import org.elasticsearch.search.runtime.LongScriptFieldTermQuery;
import org.elasticsearch.search.runtime.LongScriptFieldTermsQuery;
import org.elasticsearch.xcontent.XContentParser;

public class DateScriptFieldType
extends AbstractScriptFieldType<DateFieldScript.LeafFactory> {
    public static final RuntimeField.Parser PARSER = new RuntimeField.Parser(Builder::new);
    private final DateFormatter dateTimeFormatter;
    private final DateMathParser dateMathParser;

    public static RuntimeField sourceOnly(String name, DateFormatter dateTimeFormatter, IndexVersion supportedVersion) {
        Builder builder = new Builder(name);
        builder.format.setValue(dateTimeFormatter.pattern());
        return builder.createRuntimeField(DateFieldScript.PARSE_FROM_SOURCE, supportedVersion);
    }

    DateScriptFieldType(String name, DateFieldScript.Factory scriptFactory, DateFormatter dateTimeFormatter, Script script, Map<String, String> meta, OnScriptError onScriptError) {
        super(name, (SearchLookup searchLookup) -> scriptFactory.newFactory(name, script.getParams(), (SearchLookup)searchLookup, dateTimeFormatter, onScriptError), script, scriptFactory.isResultDeterministic(), meta, scriptFactory.isParsedFromSource());
        this.dateTimeFormatter = dateTimeFormatter;
        this.dateMathParser = dateTimeFormatter.toDateMathParser();
    }

    @Override
    public String typeName() {
        return "date";
    }

    @Override
    public Object valueForDisplay(Object value) {
        Long val = (Long)value;
        if (val == null) {
            return null;
        }
        return this.dateTimeFormatter.format(DateFieldMapper.Resolution.MILLISECONDS.toInstant(val).atZone(ZoneOffset.UTC));
    }

    @Override
    public DocValueFormat docValueFormat(@Nullable String format, ZoneId timeZone) {
        DateFormatter dateTimeFormatter = this.dateTimeFormatter;
        if (format != null) {
            dateTimeFormatter = DateFormatter.forPattern(format).withLocale(dateTimeFormatter.locale());
        }
        if (timeZone == null) {
            timeZone = ZoneOffset.UTC;
        }
        return new DocValueFormat.DateTime(dateTimeFormatter, timeZone, DateFieldMapper.Resolution.MILLISECONDS);
    }

    @Override
    public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
        FallbackSyntheticSourceBlockLoader fallbackSyntheticSourceBlockLoader = this.fallbackSyntheticSourceBlockLoader(blContext, BlockLoader.BlockFactory::longs, this::fallbackSyntheticSourceBlockLoaderReader);
        if (fallbackSyntheticSourceBlockLoader != null) {
            return fallbackSyntheticSourceBlockLoader;
        }
        return new DateScriptBlockDocValuesReader.DateScriptBlockLoader((DateFieldScript.LeafFactory)this.leafFactory(blContext.lookup()));
    }

    private FallbackSyntheticSourceBlockLoader.Reader<?> fallbackSyntheticSourceBlockLoaderReader() {
        return new FallbackSyntheticSourceBlockLoader.SingleValueReader<Long>(null){

            @Override
            public void convertValue(Object value, List<Long> accumulator) {
                try {
                    if (value instanceof Number) {
                        accumulator.add(((Number)value).longValue());
                    } else {
                        accumulator.add(DateScriptFieldType.this.dateTimeFormatter.parseMillis(value.toString()));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void writeToBlock(List<Long> values, BlockLoader.Builder blockBuilder) {
                BlockLoader.LongBuilder longBuilder = (BlockLoader.LongBuilder)blockBuilder;
                for (Long value : values) {
                    longBuilder.appendLong(value);
                }
            }

            @Override
            protected void parseNonNullValue(XContentParser parser, List<Long> accumulator) throws IOException {
                try {
                    String dateAsStr = parser.textOrNull();
                    if (dateAsStr == null) {
                        accumulator.add(DateScriptFieldType.this.dateTimeFormatter.parseMillis(null));
                    } else {
                        accumulator.add(DateScriptFieldType.this.dateTimeFormatter.parseMillis(dateAsStr));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }

    @Override
    public DateScriptFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
        return new DateScriptFieldData.Builder(this.name(), (DateFieldScript.LeafFactory)this.leafFactory(fieldDataContext.lookupSupplier().get()), DateFieldMapper.Resolution.MILLISECONDS.getDefaultToScriptFieldFactory());
    }

    @Override
    public Query distanceFeatureQuery(Object origin, String pivot, SearchExecutionContext context) {
        this.applyScriptContext(context);
        return DateFieldMapper.DateFieldType.handleNow(context, now -> {
            long originLong = DateFieldMapper.DateFieldType.parseToLong(origin, true, null, this.dateMathParser, now, DateFieldMapper.Resolution.MILLISECONDS);
            TimeValue pivotTime = TimeValue.parseTimeValue((String)pivot, (String)"distance_feature.pivot");
            return new LongScriptFieldDistanceFeatureQuery(this.script, ((DateFieldScript.LeafFactory)this.leafFactory(context))::newInstance, this.name(), originLong, pivotTime.getMillis());
        });
    }

    @Override
    public Query existsQuery(SearchExecutionContext context) {
        this.applyScriptContext(context);
        return new LongScriptFieldExistsQuery(this.script, ((DateFieldScript.LeafFactory)this.leafFactory(context))::newInstance, this.name());
    }

    @Override
    public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ZoneId timeZone, @Nullable DateMathParser parser, SearchExecutionContext context) {
        parser = parser == null ? this.dateMathParser : parser;
        this.applyScriptContext(context);
        return DateFieldMapper.DateFieldType.dateRangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, timeZone, parser, context, DateFieldMapper.Resolution.MILLISECONDS, this.name(), (l, u) -> new LongScriptFieldRangeQuery(this.script, ((DateFieldScript.LeafFactory)this.leafFactory(context))::newInstance, this.name(), (long)l, (long)u));
    }

    @Override
    public Query termQuery(Object value, SearchExecutionContext context) {
        return DateFieldMapper.DateFieldType.handleNow(context, now -> {
            long l = DateFieldMapper.DateFieldType.parseToLong(value, false, null, this.dateMathParser, now, DateFieldMapper.Resolution.MILLISECONDS);
            this.applyScriptContext(context);
            return new LongScriptFieldTermQuery(this.script, ((DateFieldScript.LeafFactory)this.leafFactory(context))::newInstance, this.name(), l);
        });
    }

    @Override
    public Query termsQuery(Collection<?> values, SearchExecutionContext context) {
        if (values.isEmpty()) {
            return Queries.ALL_DOCS_INSTANCE;
        }
        return DateFieldMapper.DateFieldType.handleNow(context, now -> {
            HashSet<Long> terms = Sets.newHashSetWithExpectedSize(values.size());
            for (Object value : values) {
                terms.add(DateFieldMapper.DateFieldType.parseToLong(value, false, null, this.dateMathParser, now, DateFieldMapper.Resolution.MILLISECONDS));
            }
            this.applyScriptContext(context);
            return new LongScriptFieldTermsQuery(this.script, ((DateFieldScript.LeafFactory)this.leafFactory(context))::newInstance, this.name(), terms);
        });
    }

    private static class Builder
    extends AbstractScriptFieldType.Builder<DateFieldScript.Factory> {
        private final FieldMapper.Parameter<String> format = FieldMapper.Parameter.stringParam("format", true, RuntimeField.initializerNotSupported(), null, (b, n, v) -> {
            if (v != null && !v.equals(DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.pattern())) {
                b.field(n, v);
            }
        }).acceptsNull();
        private final FieldMapper.Parameter<Locale> locale = new FieldMapper.Parameter<Locale>("locale", true, () -> null, (n, c, o) -> o == null ? null : LocaleUtils.parse(o.toString()), RuntimeField.initializerNotSupported(), (b, n, v) -> {
            if (v != null && !v.equals(DateFieldMapper.DEFAULT_LOCALE)) {
                b.field(n, v.toString());
            }
        }, Object::toString).acceptsNull();

        protected Builder(String name) {
            super(name, DateFieldScript.CONTEXT);
        }

        @Override
        protected List<FieldMapper.Parameter<?>> getParameters() {
            ArrayList parameters = new ArrayList(super.getParameters());
            parameters.add(this.format);
            parameters.add(this.locale);
            return Collections.unmodifiableList(parameters);
        }

        @Override
        protected AbstractScriptFieldType<?> createFieldType(String name, DateFieldScript.Factory factory, Script script, Map<String, String> meta, IndexVersion supportedVersion, OnScriptError onScriptError) {
            String pattern = this.format.getValue() == null ? DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.pattern() : this.format.getValue();
            Locale locale = this.locale.getValue() == null ? DateFieldMapper.DEFAULT_LOCALE : this.locale.getValue();
            DateFormatter dateTimeFormatter = DateFormatter.forPattern(pattern, supportedVersion).withLocale(locale);
            return new DateScriptFieldType(name, factory, dateTimeFormatter, script, meta, onScriptError);
        }

        @Override
        protected AbstractScriptFieldType<?> createFieldType(String name, DateFieldScript.Factory factory, Script script, Map<String, String> meta, OnScriptError onScriptError) {
            return this.createFieldType(name, factory, script, meta, IndexVersion.current(), onScriptError);
        }

        @Override
        protected DateFieldScript.Factory getParseFromSourceFactory() {
            return DateFieldScript.PARSE_FROM_SOURCE;
        }

        @Override
        protected DateFieldScript.Factory getCompositeLeafFactory(Function<SearchLookup, CompositeFieldScript.LeafFactory> parentScriptFactory) {
            return DateFieldScript.leafAdapter(parentScriptFactory);
        }
    }
}

