/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.index.fieldvisitor.LeafStoredFieldLoader;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.search.lookup.Source;

public class BlockLoaderStoredFieldsFromLeafLoader
implements BlockLoader.StoredFields {
    private final LeafStoredFieldLoader loader;
    private final SourceLoader.Leaf sourceLoader;
    private Source source;
    private int docId = -1;
    private int loaderDocId = -1;
    private int sourceDocId = -1;

    public BlockLoaderStoredFieldsFromLeafLoader(LeafStoredFieldLoader loader, SourceLoader.Leaf sourceLoader) {
        this.loader = loader;
        this.sourceLoader = sourceLoader;
    }

    public void advanceTo(int docId) {
        this.docId = docId;
    }

    private void advanceIfNeeded() throws IOException {
        if (this.loaderDocId != this.docId) {
            this.loader.advanceTo(this.docId);
            this.loaderDocId = this.docId;
        }
    }

    @Override
    public Source source() throws IOException {
        this.advanceIfNeeded();
        if (this.sourceLoader != null && this.sourceDocId != this.docId) {
            this.source = this.sourceLoader.source(this.loader, this.docId);
            this.sourceDocId = this.docId;
        }
        return this.source;
    }

    @Override
    public String id() throws IOException {
        this.advanceIfNeeded();
        return this.loader.id();
    }

    @Override
    public String routing() throws IOException {
        this.advanceIfNeeded();
        return this.loader.routing();
    }

    @Override
    public Map<String, List<Object>> storedFields() throws IOException {
        this.advanceIfNeeded();
        return this.loader.storedFields();
    }

    @Override
    public boolean loaded() {
        return this.loaderDocId == this.docId;
    }
}

