/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.IgnoredSourceFieldMapper;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.fetch.StoredFieldsSpec;
import org.elasticsearch.search.lookup.Source;

public abstract class ArraySourceValueFetcher
implements ValueFetcher {
    private final Set<String> sourcePaths;
    @Nullable
    private final Object nullValue;
    private final IgnoredSourceFieldMapper.IgnoredSourceFormat ignoredSourceFormat;

    public ArraySourceValueFetcher(String fieldName, SearchExecutionContext context) {
        this(fieldName, context, null);
    }

    public ArraySourceValueFetcher(String fieldName, SearchExecutionContext context, Object nullValue) {
        this.sourcePaths = context.isSourceEnabled() ? context.sourcePath(fieldName) : Collections.emptySet();
        this.nullValue = nullValue;
        this.ignoredSourceFormat = context.getIndexSettings().getIgnoredSourceFormat();
    }

    public ArraySourceValueFetcher(Set<String> sourcePaths, Object nullValue, IgnoredSourceFieldMapper.IgnoredSourceFormat ignoredSourceFormat) {
        this.sourcePaths = sourcePaths;
        this.nullValue = nullValue;
        this.ignoredSourceFormat = ignoredSourceFormat;
    }

    @Override
    public List<Object> fetchValues(Source source, int doc, List<Object> ignoredValues) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (String path : this.sourcePaths) {
            Object sourceValue = source.extractValue(path, this.nullValue);
            if (sourceValue == null) {
                return List.of();
            }
            try {
                values.addAll((List)this.parseSourceValue(sourceValue));
            }
            catch (Exception e) {
                ignoredValues.add(sourceValue);
            }
        }
        values.trimToSize();
        return values;
    }

    @Override
    public StoredFieldsSpec storedFieldsSpec() {
        return StoredFieldsSpec.withSourcePaths(this.ignoredSourceFormat, this.sourcePaths);
    }

    protected abstract Object parseSourceValue(Object var1);
}

