/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.LongValues;

public abstract class SortedNumericLongValues {
    public static SortedNumericLongValues EMPTY = new SortedNumericLongValues(){

        @Override
        public boolean advanceExact(int target) {
            return false;
        }

        @Override
        public long nextValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int docValueCount() {
            throw new UnsupportedOperationException();
        }
    };

    public abstract boolean advanceExact(int var1) throws IOException;

    public abstract long nextValue() throws IOException;

    public abstract int docValueCount();

    public static LongValues unwrapSingleton(SortedNumericLongValues values) {
        if (values instanceof SingletonSortedNumericLongValues) {
            SingletonSortedNumericLongValues sv = (SingletonSortedNumericLongValues)values;
            return sv.values;
        }
        return null;
    }

    public static SortedNumericLongValues singleton(LongValues values) {
        return new SingletonSortedNumericLongValues(values);
    }

    public static SortedNumericLongValues wrap(final SortedNumericDocValues values) {
        final NumericDocValues singleton = DocValues.unwrapSingleton((SortedNumericDocValues)values);
        if (singleton != null) {
            return new SingletonSortedNumericLongValues(new LongValues(){

                public long longValue() throws IOException {
                    return singleton.longValue();
                }

                public boolean advanceExact(int doc) throws IOException {
                    return singleton.advanceExact(doc);
                }
            });
        }
        return new SortedNumericLongValues(){

            @Override
            public boolean advanceExact(int target) throws IOException {
                return values.advanceExact(target);
            }

            @Override
            public long nextValue() throws IOException {
                return values.nextValue();
            }

            @Override
            public int docValueCount() {
                return values.docValueCount();
            }
        };
    }

    private static class SingletonSortedNumericLongValues
    extends SortedNumericLongValues {
        private final LongValues values;

        private SingletonSortedNumericLongValues(LongValues values) {
            this.values = values;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            return this.values.advanceExact(target);
        }

        @Override
        public long nextValue() throws IOException {
            return this.values.longValue();
        }

        @Override
        public int docValueCount() {
            return 1;
        }
    }
}

