/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.LongScriptDocValues;
import org.elasticsearch.index.fielddata.SortedNumericLongValues;
import org.elasticsearch.index.fielddata.plain.LeafLongFieldData;
import org.elasticsearch.index.mapper.IndexType;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.script.LongFieldScript;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.script.field.ToScriptFieldFactory;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public final class LongScriptFieldData
extends IndexNumericFieldData {
    private final String fieldName;
    private final LongFieldScript.LeafFactory leafFactory;
    protected final ToScriptFieldFactory<SortedNumericLongValues> toScriptFieldFactory;

    private LongScriptFieldData(String fieldName, LongFieldScript.LeafFactory leafFactory, ToScriptFieldFactory<SortedNumericLongValues> toScriptFieldFactory) {
        this.fieldName = fieldName;
        this.leafFactory = leafFactory;
        this.toScriptFieldFactory = toScriptFieldFactory;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public ValuesSourceType getValuesSourceType() {
        return CoreValuesSourceType.NUMERIC;
    }

    @Override
    public LongScriptLeafFieldData load(LeafReaderContext context) {
        try {
            return this.loadDirect(context);
        }
        catch (Exception e) {
            throw ExceptionsHelper.convertToElastic(e);
        }
    }

    @Override
    public LongScriptLeafFieldData loadDirect(LeafReaderContext context) {
        return new LongScriptLeafFieldData(new LongScriptDocValues(this.leafFactory.newInstance(context)), this.toScriptFieldFactory);
    }

    @Override
    public IndexNumericFieldData.NumericType getNumericType() {
        return IndexNumericFieldData.NumericType.LONG;
    }

    @Override
    protected boolean sortRequiresCustomComparator() {
        return true;
    }

    @Override
    protected IndexType indexType() {
        return IndexType.NONE;
    }

    public static class LongScriptLeafFieldData
    extends LeafLongFieldData {
        private final LongScriptDocValues longScriptDocValues;
        protected final ToScriptFieldFactory<SortedNumericLongValues> toScriptFieldFactory;

        LongScriptLeafFieldData(LongScriptDocValues longScriptDocValues, ToScriptFieldFactory<SortedNumericLongValues> toScriptFieldFactory) {
            super(0L);
            this.longScriptDocValues = longScriptDocValues;
            this.toScriptFieldFactory = toScriptFieldFactory;
        }

        @Override
        public SortedNumericLongValues getLongValues() {
            return this.longScriptDocValues;
        }

        @Override
        public DocValuesScriptFieldFactory getScriptFieldFactory(String name) {
            return this.toScriptFieldFactory.getScriptFieldFactory(this.getLongValues(), name);
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private final String name;
        private final LongFieldScript.LeafFactory leafFactory;
        protected final ToScriptFieldFactory<SortedNumericLongValues> toScriptFieldFactory;

        public Builder(String name, LongFieldScript.LeafFactory leafFactory, ToScriptFieldFactory<SortedNumericLongValues> toScriptFieldFactory) {
            this.name = name;
            this.leafFactory = leafFactory;
            this.toScriptFieldFactory = toScriptFieldFactory;
        }

        public LongScriptFieldData build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new LongScriptFieldData(this.name, this.leafFactory, this.toScriptFieldFactory);
        }
    }
}

