/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.es816;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.codecs.lucene90.IndexedDISI;
import org.apache.lucene.codecs.lucene95.OrdToDocDISIReaderConfiguration;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.packed.DirectMonotonicReader;
import org.elasticsearch.index.codec.vectors.BQVectorUtils;
import org.elasticsearch.index.codec.vectors.es816.BinarizedByteVectorValues;
import org.elasticsearch.index.codec.vectors.es816.BinaryQuantizer;

abstract class OffHeapBinarizedVectorValues
extends BinarizedByteVectorValues {
    protected final int dimension;
    protected final int size;
    protected final int numBytes;
    protected final VectorSimilarityFunction similarityFunction;
    protected final FlatVectorsScorer vectorsScorer;
    protected final IndexInput slice;
    protected final byte[] binaryValue;
    protected final ByteBuffer byteBuffer;
    protected final int byteSize;
    private int lastOrd = -1;
    protected final float[] correctiveValues;
    protected final BinaryQuantizer binaryQuantizer;
    protected final float[] centroid;
    protected final float centroidDp;
    private final int discretizedDimensions;
    private final float maxX1;
    private final float sqrtDimensions;
    private final int correctionsCount;

    OffHeapBinarizedVectorValues(int dimension, int size, float[] centroid, float centroidDp, BinaryQuantizer quantizer, VectorSimilarityFunction similarityFunction, FlatVectorsScorer vectorsScorer, IndexInput slice) {
        this.dimension = dimension;
        this.size = size;
        this.similarityFunction = similarityFunction;
        this.vectorsScorer = vectorsScorer;
        this.slice = slice;
        this.centroid = centroid;
        this.centroidDp = centroidDp;
        this.numBytes = BQVectorUtils.discretize(dimension, 64) / 8;
        this.correctionsCount = similarityFunction != VectorSimilarityFunction.EUCLIDEAN ? 3 : 2;
        this.correctiveValues = new float[this.correctionsCount];
        this.byteSize = this.numBytes + 4 * this.correctionsCount;
        this.byteBuffer = ByteBuffer.allocate(this.numBytes);
        this.binaryValue = this.byteBuffer.array();
        this.binaryQuantizer = quantizer;
        this.discretizedDimensions = BQVectorUtils.discretize(dimension, 64);
        this.sqrtDimensions = (float)BQVectorUtils.constSqrt(dimension);
        this.maxX1 = (float)(1.9 / BQVectorUtils.constSqrt((double)this.discretizedDimensions - 1.0));
    }

    @Override
    public int dimension() {
        return this.dimension;
    }

    @Override
    public int size() {
        return this.size;
    }

    public byte[] vectorValue(int targetOrd) throws IOException {
        if (this.lastOrd == targetOrd) {
            return this.binaryValue;
        }
        this.slice.seek((long)targetOrd * (long)this.byteSize);
        this.slice.readBytes(this.byteBuffer.array(), this.byteBuffer.arrayOffset(), this.numBytes);
        this.slice.readFloats(this.correctiveValues, 0, this.correctionsCount);
        this.lastOrd = targetOrd;
        return this.binaryValue;
    }

    @Override
    public int discretizedDimensions() {
        return this.discretizedDimensions;
    }

    @Override
    public float sqrtDimensions() {
        return this.sqrtDimensions;
    }

    @Override
    public float maxX1() {
        return this.maxX1;
    }

    @Override
    public float getCentroidDP() {
        return this.centroidDp;
    }

    @Override
    public float[] getCorrectiveTerms(int targetOrd) throws IOException {
        if (this.lastOrd == targetOrd) {
            return this.correctiveValues;
        }
        this.slice.seek((long)targetOrd * (long)this.byteSize + (long)this.numBytes);
        this.slice.readFloats(this.correctiveValues, 0, this.correctionsCount);
        return this.correctiveValues;
    }

    @Override
    public float getCentroidDistance(int targetOrd) throws IOException {
        if (this.lastOrd == targetOrd) {
            return this.correctiveValues[0];
        }
        this.slice.seek((long)targetOrd * (long)this.byteSize + (long)this.numBytes);
        this.slice.readFloats(this.correctiveValues, 0, this.correctionsCount);
        return this.correctiveValues[0];
    }

    @Override
    public float getVectorMagnitude(int targetOrd) throws IOException {
        if (this.lastOrd == targetOrd) {
            return this.correctiveValues[1];
        }
        this.slice.seek((long)targetOrd * (long)this.byteSize + (long)this.numBytes);
        this.slice.readFloats(this.correctiveValues, 0, this.correctionsCount);
        return this.correctiveValues[1];
    }

    @Override
    public float getOOQ(int targetOrd) throws IOException {
        if (this.lastOrd == targetOrd) {
            return this.correctiveValues[0];
        }
        this.slice.seek((long)targetOrd * (long)this.byteSize + (long)this.numBytes);
        this.slice.readFloats(this.correctiveValues, 0, this.correctionsCount);
        return this.correctiveValues[0];
    }

    @Override
    public float getNormOC(int targetOrd) throws IOException {
        if (this.lastOrd == targetOrd) {
            return this.correctiveValues[1];
        }
        this.slice.seek((long)targetOrd * (long)this.byteSize + (long)this.numBytes);
        this.slice.readFloats(this.correctiveValues, 0, this.correctionsCount);
        return this.correctiveValues[1];
    }

    @Override
    public float getODotC(int targetOrd) throws IOException {
        if (this.lastOrd == targetOrd) {
            return this.correctiveValues[2];
        }
        this.slice.seek((long)targetOrd * (long)this.byteSize + (long)this.numBytes);
        this.slice.readFloats(this.correctiveValues, 0, this.correctionsCount);
        return this.correctiveValues[2];
    }

    @Override
    public BinaryQuantizer getQuantizer() {
        return this.binaryQuantizer;
    }

    @Override
    public float[] getCentroid() {
        return this.centroid;
    }

    public int getVectorByteLength() {
        return this.numBytes;
    }

    public static OffHeapBinarizedVectorValues load(OrdToDocDISIReaderConfiguration configuration, int dimension, int size, BinaryQuantizer binaryQuantizer, VectorSimilarityFunction similarityFunction, FlatVectorsScorer vectorsScorer, float[] centroid, float centroidDp, long quantizedVectorDataOffset, long quantizedVectorDataLength, IndexInput vectorData) throws IOException {
        if (configuration.isEmpty()) {
            return new EmptyOffHeapVectorValues(dimension, similarityFunction, vectorsScorer);
        }
        assert (centroid != null);
        IndexInput bytesSlice = vectorData.slice("quantized-vector-data", quantizedVectorDataOffset, quantizedVectorDataLength);
        if (configuration.isDense()) {
            return new DenseOffHeapVectorValues(dimension, size, centroid, centroidDp, binaryQuantizer, similarityFunction, vectorsScorer, bytesSlice);
        }
        return new SparseOffHeapVectorValues(configuration, dimension, size, centroid, centroidDp, binaryQuantizer, vectorData, similarityFunction, vectorsScorer, bytesSlice);
    }

    private static class EmptyOffHeapVectorValues
    extends OffHeapBinarizedVectorValues {
        private int doc = -1;

        EmptyOffHeapVectorValues(int dimension, VectorSimilarityFunction similarityFunction, FlatVectorsScorer vectorsScorer) {
            super(dimension, 0, null, Float.NaN, null, similarityFunction, vectorsScorer, null);
        }

        public KnnVectorValues.DocIndexIterator iterator() {
            return this.createDenseIterator();
        }

        @Override
        public DenseOffHeapVectorValues copy() {
            throw new UnsupportedOperationException();
        }

        public Bits getAcceptOrds(Bits acceptDocs) {
            return null;
        }

        @Override
        public VectorScorer scorer(float[] target) throws IOException {
            return null;
        }
    }

    static class DenseOffHeapVectorValues
    extends OffHeapBinarizedVectorValues {
        DenseOffHeapVectorValues(int dimension, int size, float[] centroid, float centroidDp, BinaryQuantizer binaryQuantizer, VectorSimilarityFunction similarityFunction, FlatVectorsScorer vectorsScorer, IndexInput slice) {
            super(dimension, size, centroid, centroidDp, binaryQuantizer, similarityFunction, vectorsScorer, slice);
        }

        @Override
        public DenseOffHeapVectorValues copy() throws IOException {
            return new DenseOffHeapVectorValues(this.dimension, this.size, this.centroid, this.centroidDp, this.binaryQuantizer, this.similarityFunction, this.vectorsScorer, this.slice.clone());
        }

        public Bits getAcceptOrds(Bits acceptDocs) {
            return acceptDocs;
        }

        @Override
        public VectorScorer scorer(float[] target) throws IOException {
            DenseOffHeapVectorValues copy = this.copy();
            final KnnVectorValues.DocIndexIterator iterator = copy.iterator();
            final RandomVectorScorer scorer = this.vectorsScorer.getRandomVectorScorer(this.similarityFunction, (KnnVectorValues)copy, target);
            return new VectorScorer(){

                public float score() throws IOException {
                    return scorer.score(iterator.index());
                }

                public DocIdSetIterator iterator() {
                    return iterator;
                }
            };
        }

        public KnnVectorValues.DocIndexIterator iterator() {
            return this.createDenseIterator();
        }
    }

    private static class SparseOffHeapVectorValues
    extends OffHeapBinarizedVectorValues {
        private final DirectMonotonicReader ordToDoc;
        private final IndexedDISI disi;
        private final IndexInput dataIn;
        private final OrdToDocDISIReaderConfiguration configuration;

        SparseOffHeapVectorValues(OrdToDocDISIReaderConfiguration configuration, int dimension, int size, float[] centroid, float centroidDp, BinaryQuantizer binaryQuantizer, IndexInput dataIn, VectorSimilarityFunction similarityFunction, FlatVectorsScorer vectorsScorer, IndexInput slice) throws IOException {
            super(dimension, size, centroid, centroidDp, binaryQuantizer, similarityFunction, vectorsScorer, slice);
            this.configuration = configuration;
            this.dataIn = dataIn;
            this.ordToDoc = configuration.getDirectMonotonicReader(dataIn);
            this.disi = configuration.getIndexedDISI(dataIn);
        }

        @Override
        public SparseOffHeapVectorValues copy() throws IOException {
            return new SparseOffHeapVectorValues(this.configuration, this.dimension, this.size, this.centroid, this.centroidDp, this.binaryQuantizer, this.dataIn, this.similarityFunction, this.vectorsScorer, this.slice.clone());
        }

        public int ordToDoc(int ord) {
            return (int)this.ordToDoc.get((long)ord);
        }

        public Bits getAcceptOrds(final Bits acceptDocs) {
            if (acceptDocs == null) {
                return null;
            }
            return new Bits(){

                public boolean get(int index) {
                    return acceptDocs.get(this.ordToDoc(index));
                }

                public int length() {
                    return size;
                }
            };
        }

        public KnnVectorValues.DocIndexIterator iterator() {
            return IndexedDISI.asDocIndexIterator((IndexedDISI)this.disi);
        }

        @Override
        public VectorScorer scorer(float[] target) throws IOException {
            SparseOffHeapVectorValues copy = this.copy();
            final KnnVectorValues.DocIndexIterator iterator = copy.iterator();
            final RandomVectorScorer scorer = this.vectorsScorer.getRandomVectorScorer(this.similarityFunction, (KnnVectorValues)copy, target);
            return new VectorScorer(){

                public float score() throws IOException {
                    return scorer.score(iterator.index());
                }

                public DocIdSetIterator iterator() {
                    return iterator;
                }
            };
        }
    }
}

