/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.diskbbq.next;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.function.IntUnaryOperator;
import org.apache.lucene.codecs.hnsw.FlatVectorsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.search.CheckedIntConsumer;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.VectorUtil;
import org.apache.lucene.util.hnsw.IntToIntFunction;
import org.apache.lucene.util.packed.DirectWriter;
import org.apache.lucene.util.packed.PackedLongValues;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.index.codec.vectors.OptimizedScalarQuantizer;
import org.elasticsearch.index.codec.vectors.cluster.HierarchicalKMeans;
import org.elasticsearch.index.codec.vectors.cluster.KMeansResult;
import org.elasticsearch.index.codec.vectors.cluster.KmeansFloatVectorValues;
import org.elasticsearch.index.codec.vectors.diskbbq.CentroidAssignments;
import org.elasticsearch.index.codec.vectors.diskbbq.CentroidSupplier;
import org.elasticsearch.index.codec.vectors.diskbbq.DiskBBQBulkWriter;
import org.elasticsearch.index.codec.vectors.diskbbq.DocIdsWriter;
import org.elasticsearch.index.codec.vectors.diskbbq.IVFVectorsWriter;
import org.elasticsearch.index.codec.vectors.diskbbq.IntSorter;
import org.elasticsearch.index.codec.vectors.diskbbq.IntToBooleanFunction;
import org.elasticsearch.index.codec.vectors.diskbbq.QuantizedVectorValues;
import org.elasticsearch.index.codec.vectors.diskbbq.next.ESNextDiskBBQVectorsFormat;
import org.elasticsearch.index.codec.vectors.diskbbq.next.ESNextDiskBBQVectorsReader;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;

public class ESNextDiskBBQVectorsWriter
extends IVFVectorsWriter {
    private static final Logger logger = LogManager.getLogger(ESNextDiskBBQVectorsWriter.class);
    private final int vectorPerCluster;
    private final int centroidsPerParentCluster;
    private final ESNextDiskBBQVectorsFormat.QuantEncoding quantEncoding;

    public ESNextDiskBBQVectorsWriter(SegmentWriteState state, String rawVectorFormatName, boolean useDirectIOReads, FlatVectorsWriter rawVectorDelegate, ESNextDiskBBQVectorsFormat.QuantEncoding encoding, int vectorPerCluster, int centroidsPerParentCluster) throws IOException {
        super(state, rawVectorFormatName, useDirectIOReads, rawVectorDelegate, 1);
        this.vectorPerCluster = vectorPerCluster;
        this.centroidsPerParentCluster = centroidsPerParentCluster;
        this.quantEncoding = encoding;
    }

    @Override
    public IVFVectorsWriter.CentroidOffsetAndLength buildAndWritePostingsLists(FieldInfo fieldInfo, CentroidSupplier centroidSupplier, FloatVectorValues floatVectorValues, IndexOutput postingsOutput, long fileOffset, int[] assignments, int[] overspillAssignments) throws IOException {
        int[] centroidVectorCount = new int[centroidSupplier.size()];
        for (int i2 = 0; i2 < assignments.length; ++i2) {
            int n = assignments[i2];
            centroidVectorCount[n] = centroidVectorCount[n] + 1;
            if (overspillAssignments.length <= i2 || overspillAssignments[i2] == -1) continue;
            int n2 = overspillAssignments[i2];
            centroidVectorCount[n2] = centroidVectorCount[n2] + 1;
        }
        int maxPostingListSize = 0;
        int[][] assignmentsByCluster = new int[centroidSupplier.size()][];
        for (int c = 0; c < centroidSupplier.size(); ++c) {
            int size = centroidVectorCount[c];
            maxPostingListSize = Math.max(maxPostingListSize, size);
            assignmentsByCluster[c] = new int[size];
        }
        Arrays.fill(centroidVectorCount, 0);
        for (int i3 = 0; i3 < assignments.length; ++i3) {
            int s;
            int c;
            int n = c = assignments[i3];
            int n3 = centroidVectorCount[n];
            centroidVectorCount[n] = n3 + 1;
            assignmentsByCluster[c][n3] = i3;
            if (overspillAssignments.length <= i3 || (s = overspillAssignments[i3]) == -1) continue;
            int n4 = s;
            int n5 = centroidVectorCount[n4];
            centroidVectorCount[n4] = n5 + 1;
            assignmentsByCluster[s][n5] = i3;
        }
        PackedLongValues.Builder offsets = PackedLongValues.monotonicBuilder((float)0.0f);
        PackedLongValues.Builder lengths = PackedLongValues.monotonicBuilder((float)0.0f);
        DiskBBQBulkWriter bulkWriter = DiskBBQBulkWriter.fromBitSize(this.quantEncoding.bits(), 16, postingsOutput);
        OnHeapQuantizedVectors onHeapQuantizedVectors = new OnHeapQuantizedVectors(floatVectorValues, this.quantEncoding, fieldInfo.getVectorDimension(), new OptimizedScalarQuantizer(fieldInfo.getVectorSimilarityFunction()));
        ByteBuffer buffer = ByteBuffer.allocate(fieldInfo.getVectorDimension() * 4).order(ByteOrder.LITTLE_ENDIAN);
        int[] docIds = new int[maxPostingListSize];
        int[] docDeltas = new int[maxPostingListSize];
        int[] clusterOrds = new int[maxPostingListSize];
        DocIdsWriter idsWriter = new DocIdsWriter();
        for (int c = 0; c < centroidSupplier.size(); ++c) {
            int j;
            float[] centroid = centroidSupplier.centroid(c);
            int[] cluster = assignmentsByCluster[c];
            long offset = postingsOutput.alignFilePointer(4) - fileOffset;
            offsets.add(offset);
            buffer.asFloatBuffer().put(centroid);
            postingsOutput.writeBytes(buffer.array(), buffer.array().length);
            postingsOutput.writeInt(Float.floatToIntBits(VectorUtil.dotProduct((float[])centroid, (float[])centroid)));
            int size = cluster.length;
            postingsOutput.writeVInt(size);
            for (j = 0; j < size; ++j) {
                docIds[j] = floatVectorValues.ordToDoc(cluster[j]);
                clusterOrds[j] = j;
            }
            new IntSorter(clusterOrds, i -> docIds[i]).sort(0, size);
            for (j = 0; j < size; ++j) {
                docDeltas[j] = j == 0 ? docIds[clusterOrds[j]] : docIds[clusterOrds[j]] - docIds[clusterOrds[j - 1]];
            }
            onHeapQuantizedVectors.reset(centroid, size, ord -> cluster[clusterOrds[ord]]);
            byte encoding = idsWriter.calculateBlockEncoding(i -> docDeltas[i], size, 16);
            postingsOutput.writeByte(encoding);
            bulkWriter.writeVectors(onHeapQuantizedVectors, (CheckedIntConsumer<IOException>)((CheckedIntConsumer)i -> idsWriter.writeDocIds(d -> docDeltas[i + d], Math.min(16, size - i), encoding, (DataOutput)postingsOutput)));
            lengths.add(postingsOutput.getFilePointer() - fileOffset - offset);
        }
        if (logger.isDebugEnabled()) {
            ESNextDiskBBQVectorsWriter.printClusterQualityStatistics(assignmentsByCluster);
        }
        return new IVFVectorsWriter.CentroidOffsetAndLength((LongValues)offsets.build(), (LongValues)lengths.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @SuppressForbidden(reason="require usage of Lucene's IOUtils#deleteFilesIgnoringExceptions(...)")
    public IVFVectorsWriter.CentroidOffsetAndLength buildAndWritePostingsLists(FieldInfo fieldInfo, CentroidSupplier centroidSupplier, FloatVectorValues floatVectorValues, IndexOutput postingsOutput, long fileOffset, MergeState mergeState, int[] assignments, int[] overspillAssignments) throws IOException {
        block28: {
            quantizedVectorsTempName = null;
            success = false;
            try {
                quantizedVectorsTemp = mergeState.segmentInfo.dir.createTempOutput(mergeState.segmentInfo.name, "qvec_", IOContext.DEFAULT);
                try {
                    quantizedVectorsTempName = quantizedVectorsTemp.getName();
                    quantizer = new OptimizedScalarQuantizer(fieldInfo.getVectorSimilarityFunction());
                    quantized = new int[this.quantEncoding.discretizedDimensions(fieldInfo.getVectorDimension())];
                    binary = new byte[this.quantEncoding.getDocPackedLength(fieldInfo.getVectorDimension())];
                    scratch = new float[fieldInfo.getVectorDimension()];
                    for (i = 0; i < assignments.length; ++i) {
                        c = assignments[i];
                        centroid = centroidSupplier.centroid(c);
                        vector = floatVectorValues.vectorValue(i);
                        overspill = overspillAssignments.length > i && overspillAssignments[i] != -1;
                        result = quantizer.scalarQuantize(vector, scratch, quantized, this.quantEncoding.bits(), centroid);
                        this.quantEncoding.pack(quantized, binary);
                        ESNextDiskBBQVectorsWriter.writeQuantizedValue(quantizedVectorsTemp, binary, result);
                        if (overspill) {
                            s = overspillAssignments[i];
                            result = quantizer.scalarQuantize(vector, scratch, quantized, this.quantEncoding.bits(), centroidSupplier.centroid(s));
                            this.quantEncoding.pack(quantized, binary);
                            ESNextDiskBBQVectorsWriter.writeQuantizedValue(quantizedVectorsTemp, binary, result);
                            continue;
                        }
                        Arrays.fill(binary, (byte)0);
                        zeroResult = new OptimizedScalarQuantizer.QuantizationResult(0.0f, 0.0f, 0.0f, 0);
                        ESNextDiskBBQVectorsWriter.writeQuantizedValue(quantizedVectorsTemp, binary, zeroResult);
                    }
                    success = true;
                }
                finally {
                    if (quantizedVectorsTemp != null) {
                        quantizedVectorsTemp.close();
                    }
                }
                ** if (success || quantizedVectorsTempName == null) goto lbl-1000
            }
            catch (Throwable var24_35) {
                if (!success && quantizedVectorsTempName != null) {
                    IOUtils.deleteFilesIgnoringExceptions((Directory)mergeState.segmentInfo.dir, (String[])new String[]{quantizedVectorsTempName});
                }
                throw var24_35;
            }
lbl-1000:
            // 1 sources

            {
                IOUtils.deleteFilesIgnoringExceptions((Directory)mergeState.segmentInfo.dir, (String[])new String[]{quantizedVectorsTempName});
            }
lbl-1000:
            // 2 sources

            {
            }
            centroidVectorCount = new int[centroidSupplier.size()];
            for (i = 0; i < assignments.length; ++i) {
                v0 = assignments[i];
                centroidVectorCount[v0] = centroidVectorCount[v0] + 1;
                if (overspillAssignments.length <= i || overspillAssignments[i] == -1) continue;
                v1 = overspillAssignments[i];
                centroidVectorCount[v1] = centroidVectorCount[v1] + 1;
            }
            maxPostingListSize = 0;
            assignmentsByCluster = new int[centroidSupplier.size()][];
            isOverspillByCluster = new boolean[centroidSupplier.size()][];
            for (c = 0; c < centroidSupplier.size(); ++c) {
                size = centroidVectorCount[c];
                maxPostingListSize = Math.max(maxPostingListSize, size);
                assignmentsByCluster[c] = new int[size];
                isOverspillByCluster[c] = new boolean[size];
            }
            Arrays.fill(centroidVectorCount, 0);
            for (i = 0; i < assignments.length; ++i) {
                v2 = c = assignments[i];
                v3 = centroidVectorCount[v2];
                centroidVectorCount[v2] = v3 + 1;
                assignmentsByCluster[c][v3] = i;
                if (overspillAssignments.length <= i || (s = overspillAssignments[i]) == -1) continue;
                assignmentsByCluster[s][centroidVectorCount[s]] = i;
                v4 = s;
                v5 = centroidVectorCount[v4];
                centroidVectorCount[v4] = v5 + 1;
                isOverspillByCluster[s][v5] = true;
            }
            quantizedVectorsInput = mergeState.segmentInfo.dir.openInput(quantizedVectorsTempName, IOContext.DEFAULT);
            offsets = PackedLongValues.monotonicBuilder((float)0.0f);
            lengths = PackedLongValues.monotonicBuilder((float)0.0f);
            offHeapQuantizedVectors = new OffHeapQuantizedVectors(quantizedVectorsInput, this.quantEncoding, fieldInfo.getVectorDimension());
            bulkWriter = DiskBBQBulkWriter.fromBitSize(this.quantEncoding.bits(), 16, postingsOutput);
            buffer = ByteBuffer.allocate(fieldInfo.getVectorDimension() * 4).order(ByteOrder.LITTLE_ENDIAN);
            docIds = new int[maxPostingListSize];
            docDeltas = new int[maxPostingListSize];
            clusterOrds = new int[maxPostingListSize];
            idsWriter = new DocIdsWriter();
            for (c = 0; c < centroidSupplier.size(); ++c) {
                centroid = centroidSupplier.centroid(c);
                cluster = assignmentsByCluster[c];
                isOverspill = isOverspillByCluster[c];
                offset = postingsOutput.alignFilePointer(4) - fileOffset;
                offsets.add(offset);
                buffer.asFloatBuffer().put(centroid);
                postingsOutput.writeBytes(buffer.array(), buffer.array().length);
                postingsOutput.writeInt(Float.floatToIntBits(VectorUtil.dotProduct((float[])centroid, (float[])centroid)));
                size = cluster.length;
                postingsOutput.writeVInt(size);
                for (j = 0; j < size; ++j) {
                    docIds[j] = floatVectorValues.ordToDoc(cluster[j]);
                    clusterOrds[j] = j;
                }
                new IntSorter(clusterOrds, (IntToIntFunction)LambdaMetafactory.metafactory(null, null, null, (I)I, lambda$buildAndWritePostingsLists$5(int[] int ), (I)I)((int[])docIds)).sort(0, size);
                for (j = 0; j < size; ++j) {
                    docDeltas[j] = j == 0 ? docIds[clusterOrds[j]] : docIds[clusterOrds[j]] - docIds[clusterOrds[j - 1]];
                }
                encoding = idsWriter.calculateBlockEncoding((IntToIntFunction)LambdaMetafactory.metafactory(null, null, null, (I)I, lambda$buildAndWritePostingsLists$6(int[] int ), (I)I)((int[])docDeltas), size, 16);
                postingsOutput.writeByte(encoding);
                offHeapQuantizedVectors.reset(size, (IntToBooleanFunction)LambdaMetafactory.metafactory(null, null, null, (I)Z, lambda$buildAndWritePostingsLists$7(boolean[] int[] int ), (I)Z)((boolean[])isOverspill, (int[])clusterOrds), (IntToIntFunction)LambdaMetafactory.metafactory(null, null, null, (I)I, lambda$buildAndWritePostingsLists$8(int[] int[] int ), (I)I)((int[])cluster, (int[])clusterOrds));
                bulkWriter.writeVectors(offHeapQuantizedVectors, (CheckedIntConsumer<IOException>)(CheckedIntConsumer)LambdaMetafactory.metafactory(null, null, null, (I)V, lambda$buildAndWritePostingsLists$10(org.elasticsearch.index.codec.vectors.diskbbq.DocIdsWriter int[] int byte org.apache.lucene.store.IndexOutput int ), (I)V)((DocIdsWriter)idsWriter, (int[])docDeltas, (int)size, (byte)encoding, (IndexOutput)postingsOutput));
                lengths.add(postingsOutput.getFilePointer() - fileOffset - offset);
            }
            if (ESNextDiskBBQVectorsWriter.logger.isDebugEnabled()) {
                ESNextDiskBBQVectorsWriter.printClusterQualityStatistics(assignmentsByCluster);
            }
            var26_39 = new IVFVectorsWriter.CentroidOffsetAndLength((LongValues)offsets.build(), (LongValues)lengths.build());
            if (quantizedVectorsInput == null) break block28;
            quantizedVectorsInput.close();
        }
        IOUtils.deleteFilesIgnoringExceptions((Directory)mergeState.segmentInfo.dir, (String[])new String[]{quantizedVectorsTempName});
        return var26_39;
        {
            catch (Throwable var17_23) {
                try {
                    if (quantizedVectorsInput != null) {
                        try {
                            quantizedVectorsInput.close();
                        }
                        catch (Throwable var18_26) {
                            var17_23.addSuppressed(var18_26);
                        }
                    }
                    throw var17_23;
                }
                catch (Throwable var34_46) {
                    IOUtils.deleteFilesIgnoringExceptions((Directory)mergeState.segmentInfo.dir, (String[])new String[]{quantizedVectorsTempName});
                    throw var34_46;
                }
            }
        }
    }

    private static void printClusterQualityStatistics(int[][] clusters) {
        float min = Float.MAX_VALUE;
        float max = Float.MIN_VALUE;
        float mean = 0.0f;
        float m2 = 0.0f;
        int count = 0;
        for (int[] cluster : clusters) {
            ++count;
            if (cluster == null) continue;
            float delta = (float)cluster.length - mean;
            m2 += delta * ((float)cluster.length - (mean += delta / (float)count));
            min = Math.min(min, (float)cluster.length);
            max = Math.max(max, (float)cluster.length);
        }
        float variance = m2 / (float)(clusters.length - 1);
        logger.debug("Centroid count: {} min: {} max: {} mean: {} stdDev: {} variance: {}", new Object[]{clusters.length, Float.valueOf(min), Float.valueOf(max), Float.valueOf(mean), Math.sqrt(variance), Float.valueOf(variance)});
    }

    @Override
    public CentroidSupplier createCentroidSupplier(IndexInput centroidsInput, int numCentroids, FieldInfo fieldInfo, float[] globalCentroid) {
        return new OffHeapCentroidSupplier(centroidsInput, numCentroids, fieldInfo);
    }

    @Override
    protected void doWriteMeta(IndexOutput metaOutput, FieldInfo field, int numCentroids) throws IOException {
        metaOutput.writeInt(this.quantEncoding.id());
    }

    @Override
    public void writeCentroids(FieldInfo fieldInfo, CentroidSupplier centroidSupplier, int[] centroidAssignments, float[] globalCentroid, IVFVectorsWriter.CentroidOffsetAndLength centroidOffsetAndLength, IndexOutput centroidOutput) throws IOException {
        if (centroidSupplier.size() > this.centroidsPerParentCluster * this.centroidsPerParentCluster) {
            CentroidGroups centroidGroups = this.buildCentroidGroups(fieldInfo, centroidSupplier);
            int[] centroidOrdinalMap = new int[centroidSupplier.size()];
            int idx = 0;
            int[][] nArray = centroidGroups.vectors();
            int n = nArray.length;
            for (int j = 0; j < n; ++j) {
                int[] centroidVectors;
                for (int assignment : centroidVectors = nArray[j]) {
                    centroidOrdinalMap[assignment] = idx++;
                }
            }
            assert (idx == centroidSupplier.size()) : "Expected [" + centroidSupplier.size() + "], got [" + idx + "]";
            this.writeCentroidLookup(centroidOutput, centroidAssignments, i -> centroidOrdinalMap[i], centroidSupplier.size());
            this.writeCentroidsWithParents(fieldInfo, centroidSupplier, globalCentroid, centroidOffsetAndLength, centroidOutput, centroidGroups);
        } else {
            this.writeCentroidLookup(centroidOutput, centroidAssignments, IntUnaryOperator.identity(), centroidSupplier.size());
            this.writeCentroidsWithoutParents(fieldInfo, centroidSupplier, globalCentroid, centroidOffsetAndLength, centroidOutput);
        }
    }

    private void writeCentroidLookup(IndexOutput out, int[] centroidAssignments, IntUnaryOperator OrdinalMap2, int numberCentroids) throws IOException {
        int bitsRequired = DirectWriter.bitsRequired((long)numberCentroids);
        long bytesRequired = ESNextDiskBBQVectorsReader.directWriterSizeOnDisk(centroidAssignments.length, bitsRequired);
        ByteBuffersDataOutput memory = new ByteBuffersDataOutput(bytesRequired);
        DirectWriter writer = DirectWriter.getInstance((DataOutput)memory, (long)centroidAssignments.length, (int)bitsRequired);
        for (int centroidAssignment : centroidAssignments) {
            writer.add((long)OrdinalMap2.applyAsInt(centroidAssignment));
        }
        writer.finish();
        out.copyBytes((DataInput)memory.toDataInput(), memory.size());
    }

    private void writeCentroidsWithParents(FieldInfo fieldInfo, CentroidSupplier centroidSupplier, float[] globalCentroid, IVFVectorsWriter.CentroidOffsetAndLength centroidOffsetAndLength, IndexOutput centroidOutput, CentroidGroups centroidGroups) throws IOException {
        DiskBBQBulkWriter bulkWriter = DiskBBQBulkWriter.fromBitSize(7, 16, centroidOutput);
        OptimizedScalarQuantizer osq = new OptimizedScalarQuantizer(fieldInfo.getVectorSimilarityFunction());
        centroidOutput.writeVInt(centroidGroups.centroids.length);
        centroidOutput.writeVInt(centroidGroups.maxVectorsPerCentroidLength);
        QuantizedCentroids parentQuantizeCentroid = new QuantizedCentroids(CentroidSupplier.fromArray(centroidGroups.centroids, fieldInfo.getVectorDimension()), fieldInfo.getVectorDimension(), osq, globalCentroid);
        bulkWriter.writeVectors(parentQuantizeCentroid, null);
        int offset = 0;
        for (int[] centroidVectors : centroidGroups.vectors()) {
            centroidOutput.writeInt(offset);
            centroidOutput.writeInt(centroidVectors.length);
            offset += centroidVectors.length;
        }
        QuantizedCentroids childrenQuantizeCentroid = new QuantizedCentroids(centroidSupplier, fieldInfo.getVectorDimension(), osq, globalCentroid);
        for (int[] centroidVectors : centroidGroups.vectors()) {
            childrenQuantizeCentroid.reset(idx -> centroidVectors[idx], centroidVectors.length);
            bulkWriter.writeVectors(childrenQuantizeCentroid, null);
        }
        int[][] nArray = centroidGroups.vectors();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[] centroidVectors;
            for (int assignment : centroidVectors = nArray[i]) {
                centroidOutput.writeLong(centroidOffsetAndLength.offsets().get((long)assignment));
                centroidOutput.writeLong(centroidOffsetAndLength.lengths().get((long)assignment));
            }
        }
    }

    private void writeCentroidsWithoutParents(FieldInfo fieldInfo, CentroidSupplier centroidSupplier, float[] globalCentroid, IVFVectorsWriter.CentroidOffsetAndLength centroidOffsetAndLength, IndexOutput centroidOutput) throws IOException {
        centroidOutput.writeVInt(0);
        DiskBBQBulkWriter bulkWriter = DiskBBQBulkWriter.fromBitSize(7, 16, centroidOutput);
        OptimizedScalarQuantizer osq = new OptimizedScalarQuantizer(fieldInfo.getVectorSimilarityFunction());
        QuantizedCentroids quantizedCentroids = new QuantizedCentroids(centroidSupplier, fieldInfo.getVectorDimension(), osq, globalCentroid);
        bulkWriter.writeVectors(quantizedCentroids, null);
        for (int i = 0; i < centroidSupplier.size(); ++i) {
            centroidOutput.writeLong(centroidOffsetAndLength.offsets().get((long)i));
            centroidOutput.writeLong(centroidOffsetAndLength.lengths().get((long)i));
        }
    }

    private CentroidGroups buildCentroidGroups(FieldInfo fieldInfo, CentroidSupplier centroidSupplier) throws IOException {
        int i;
        FloatVectorValues floatVectorValues = centroidSupplier.asFloatVectorValues();
        KMeansResult kMeansResult = HierarchicalKMeans.ofSerial(fieldInfo.getVectorDimension(), 6, 64, 128, -1.0f).cluster(floatVectorValues, this.centroidsPerParentCluster);
        int[] centroidVectorCount = new int[kMeansResult.centroids().length];
        for (int i2 = 0; i2 < kMeansResult.assignments().length; ++i2) {
            int n = kMeansResult.assignments()[i2];
            centroidVectorCount[n] = centroidVectorCount[n] + 1;
        }
        int[][] vectorsPerCentroid = new int[kMeansResult.centroids().length][];
        int maxVectorsPerCentroidLength = 0;
        for (i = 0; i < kMeansResult.centroids().length; ++i) {
            vectorsPerCentroid[i] = new int[centroidVectorCount[i]];
            maxVectorsPerCentroidLength = Math.max(maxVectorsPerCentroidLength, centroidVectorCount[i]);
        }
        Arrays.fill(centroidVectorCount, 0);
        i = 0;
        while (i < kMeansResult.assignments().length) {
            int c;
            int n = c = kMeansResult.assignments()[i];
            int n2 = centroidVectorCount[n];
            centroidVectorCount[n] = n2 + 1;
            vectorsPerCentroid[c][n2] = i++;
        }
        return new CentroidGroups(kMeansResult.centroids(), vectorsPerCentroid, maxVectorsPerCentroidLength);
    }

    @Override
    public CentroidAssignments calculateCentroids(FieldInfo fieldInfo, FloatVectorValues floatVectorValues, MergeState mergeState) throws IOException {
        return this.calculateCentroids(fieldInfo, floatVectorValues);
    }

    @Override
    public CentroidAssignments calculateCentroids(FieldInfo fieldInfo, FloatVectorValues floatVectorValues) throws IOException {
        KMeansResult kMeansResult = HierarchicalKMeans.ofSerial(floatVectorValues.dimension()).cluster(floatVectorValues, this.vectorPerCluster);
        float[][] centroids = kMeansResult.centroids();
        if (logger.isDebugEnabled()) {
            logger.debug("final centroid count: {}", new Object[]{centroids.length});
        }
        int[] assignments = kMeansResult.assignments();
        int[] soarAssignments = kMeansResult.soarAssignments();
        return new CentroidAssignments(fieldInfo.getVectorDimension(), centroids, assignments, soarAssignments);
    }

    static void writeQuantizedValue(IndexOutput indexOutput, byte[] binaryValue, OptimizedScalarQuantizer.QuantizationResult corrections) throws IOException {
        indexOutput.writeBytes(binaryValue, binaryValue.length);
        indexOutput.writeInt(Float.floatToIntBits(corrections.lowerInterval()));
        indexOutput.writeInt(Float.floatToIntBits(corrections.upperInterval()));
        indexOutput.writeInt(Float.floatToIntBits(corrections.additionalCorrection()));
        assert (corrections.quantizedComponentSum() >= 0 && corrections.quantizedComponentSum() <= 65535);
        indexOutput.writeShort((short)corrections.quantizedComponentSum());
    }

    private static /* synthetic */ void lambda$buildAndWritePostingsLists$10(DocIdsWriter idsWriter, int[] docDeltas, int size, byte encoding, IndexOutput postingsOutput, int i) throws IOException {
        idsWriter.writeDocIds(d -> docDeltas[d + i], Math.min(16, size - i), encoding, (DataOutput)postingsOutput);
    }

    private static /* synthetic */ int lambda$buildAndWritePostingsLists$8(int[] cluster, int[] clusterOrds, int ord) {
        return cluster[clusterOrds[ord]];
    }

    private static /* synthetic */ boolean lambda$buildAndWritePostingsLists$7(boolean[] isOverspill, int[] clusterOrds, int ord) {
        return isOverspill[clusterOrds[ord]];
    }

    private static /* synthetic */ int lambda$buildAndWritePostingsLists$6(int[] docDeltas, int i) {
        return docDeltas[i];
    }

    private static /* synthetic */ int lambda$buildAndWritePostingsLists$5(int[] docIds, int i) {
        return docIds[i];
    }

    static class OnHeapQuantizedVectors
    implements QuantizedVectorValues {
        private final FloatVectorValues vectorValues;
        private final OptimizedScalarQuantizer quantizer;
        private final byte[] quantizedVector;
        private final int[] quantizedVectorScratch;
        private final float[] floatVectorScratch;
        private final ESNextDiskBBQVectorsFormat.QuantEncoding encoding;
        private OptimizedScalarQuantizer.QuantizationResult corrections;
        private float[] currentCentroid;
        private IntToIntFunction ordTransformer = null;
        private int currOrd = -1;
        private int count;

        OnHeapQuantizedVectors(FloatVectorValues vectorValues, ESNextDiskBBQVectorsFormat.QuantEncoding encoding, int dimension, OptimizedScalarQuantizer quantizer) {
            this.vectorValues = vectorValues;
            this.encoding = encoding;
            this.quantizer = quantizer;
            this.quantizedVector = new byte[encoding.getDocPackedLength(dimension)];
            this.floatVectorScratch = new float[dimension];
            this.quantizedVectorScratch = new int[encoding.discretizedDimensions(dimension)];
            this.corrections = null;
        }

        private void reset(float[] centroid, int count, IntToIntFunction ordTransformer) {
            this.currentCentroid = centroid;
            this.ordTransformer = ordTransformer;
            this.currOrd = -1;
            this.count = count;
        }

        @Override
        public int count() {
            return this.count;
        }

        @Override
        public byte[] next() throws IOException {
            if (this.currOrd >= this.count() - 1) {
                throw new IllegalStateException("No more vectors to read, current ord: " + this.currOrd + ", count: " + this.count());
            }
            ++this.currOrd;
            int ord = this.ordTransformer.apply(this.currOrd);
            float[] vector = this.vectorValues.vectorValue(ord);
            this.corrections = this.quantizer.scalarQuantize(vector, this.floatVectorScratch, this.quantizedVectorScratch, this.encoding.bits(), this.currentCentroid);
            this.encoding.pack(this.quantizedVectorScratch, this.quantizedVector);
            return this.quantizedVector;
        }

        @Override
        public OptimizedScalarQuantizer.QuantizationResult getCorrections() {
            if (this.currOrd == -1) {
                throw new IllegalStateException("No vector read yet, call next first");
            }
            return this.corrections;
        }
    }

    static class OffHeapQuantizedVectors
    implements QuantizedVectorValues {
        private final IndexInput quantizedVectorsInput;
        private final byte[] binaryScratch;
        private final float[] corrections = new float[3];
        private final int vectorByteSize;
        private int bitSum;
        private int currOrd = -1;
        private int count;
        private IntToBooleanFunction isOverspill = null;
        private IntToIntFunction ordTransformer = null;

        OffHeapQuantizedVectors(IndexInput quantizedVectorsInput, ESNextDiskBBQVectorsFormat.QuantEncoding encoding, int dimension) {
            this.quantizedVectorsInput = quantizedVectorsInput;
            this.binaryScratch = new byte[encoding.getDocPackedLength(dimension)];
            this.vectorByteSize = this.binaryScratch.length + 12 + 2;
        }

        private void reset(int count, IntToBooleanFunction isOverspill, IntToIntFunction ordTransformer) {
            this.count = count;
            this.isOverspill = isOverspill;
            this.ordTransformer = ordTransformer;
            this.currOrd = -1;
        }

        @Override
        public int count() {
            return this.count;
        }

        @Override
        public byte[] next() throws IOException {
            if (this.currOrd >= this.count - 1) {
                throw new IllegalStateException("No more vectors to read, current ord: " + this.currOrd + ", count: " + this.count);
            }
            ++this.currOrd;
            int ord = this.ordTransformer.apply(this.currOrd);
            boolean isOverspill = this.isOverspill.apply(this.currOrd);
            return this.getVector(ord, isOverspill);
        }

        @Override
        public OptimizedScalarQuantizer.QuantizationResult getCorrections() {
            if (this.currOrd == -1) {
                throw new IllegalStateException("No vector read yet, call readQuantizedVector first");
            }
            return new OptimizedScalarQuantizer.QuantizationResult(this.corrections[0], this.corrections[1], this.corrections[2], this.bitSum);
        }

        byte[] getVector(int ord, boolean isOverspill) throws IOException {
            this.readQuantizedVector(ord, isOverspill);
            return this.binaryScratch;
        }

        public void readQuantizedVector(int ord, boolean isOverspill) throws IOException {
            long offset = (long)ord * ((long)this.vectorByteSize * 2L) + (long)(isOverspill ? this.vectorByteSize : 0);
            this.quantizedVectorsInput.seek(offset);
            this.quantizedVectorsInput.readBytes(this.binaryScratch, 0, this.binaryScratch.length);
            this.quantizedVectorsInput.readFloats(this.corrections, 0, 3);
            this.bitSum = Short.toUnsignedInt(this.quantizedVectorsInput.readShort());
        }
    }

    static class OffHeapCentroidSupplier
    implements CentroidSupplier {
        private final IndexInput centroidsInput;
        private final int numCentroids;
        private final int dimension;
        private final float[] scratch;
        private int currOrd = -1;

        OffHeapCentroidSupplier(IndexInput centroidsInput, int numCentroids, FieldInfo info) {
            this.centroidsInput = centroidsInput;
            this.numCentroids = numCentroids;
            this.dimension = info.getVectorDimension();
            this.scratch = new float[this.dimension];
        }

        @Override
        public int size() {
            return this.numCentroids;
        }

        @Override
        public float[] centroid(int centroidOrdinal) throws IOException {
            if (centroidOrdinal == this.currOrd) {
                return this.scratch;
            }
            this.centroidsInput.seek((long)centroidOrdinal * (long)this.dimension * 4L);
            this.centroidsInput.readFloats(this.scratch, 0, this.dimension);
            this.currOrd = centroidOrdinal;
            return this.scratch;
        }

        @Override
        public FloatVectorValues asFloatVectorValues() throws IOException {
            return KmeansFloatVectorValues.build(this.centroidsInput, null, this.numCentroids, this.dimension);
        }
    }

    private record CentroidGroups(float[][] centroids, int[][] vectors, int maxVectorsPerCentroidLength) {
    }

    static class QuantizedCentroids
    implements QuantizedVectorValues {
        private final CentroidSupplier supplier;
        private final OptimizedScalarQuantizer quantizer;
        private final byte[] quantizedVector;
        private final int[] quantizedVectorScratch;
        private final float[] floatVectorScratch;
        private OptimizedScalarQuantizer.QuantizationResult corrections;
        private final float[] centroid;
        private int currOrd = -1;
        private IntToIntFunction ordTransformer = i -> i;
        int size;

        QuantizedCentroids(CentroidSupplier supplier, int dimension, OptimizedScalarQuantizer quantizer, float[] centroid) {
            this.supplier = supplier;
            this.quantizer = quantizer;
            this.quantizedVector = new byte[dimension];
            this.floatVectorScratch = new float[dimension];
            this.quantizedVectorScratch = new int[dimension];
            this.centroid = centroid;
            this.size = supplier.size();
        }

        @Override
        public int count() {
            return this.size;
        }

        void reset(IntToIntFunction ordTransformer, int size) {
            this.ordTransformer = ordTransformer;
            this.currOrd = -1;
            this.size = size;
            this.corrections = null;
        }

        @Override
        public byte[] next() throws IOException {
            if (this.currOrd >= this.count() - 1) {
                throw new IllegalStateException("No more vectors to read, current ord: " + this.currOrd + ", count: " + this.count());
            }
            ++this.currOrd;
            float[] vector = this.supplier.centroid(this.ordTransformer.apply(this.currOrd));
            this.corrections = this.quantizer.scalarQuantize(vector, this.floatVectorScratch, this.quantizedVectorScratch, (byte)7, this.centroid);
            for (int i = 0; i < this.quantizedVectorScratch.length; ++i) {
                this.quantizedVector[i] = (byte)this.quantizedVectorScratch[i];
            }
            return this.quantizedVector;
        }

        @Override
        public OptimizedScalarQuantizer.QuantizationResult getCorrections() {
            return this.corrections;
        }
    }
}

