/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.cluster;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;

public final class KmeansFloatVectorValues
extends FloatVectorValues {
    private final VectorSupplier vectors;
    private final DocSupplier docs;
    private final int numVectors;

    private KmeansFloatVectorValues(VectorSupplier vectors, DocSupplier docs, int numVectors) {
        this.vectors = vectors;
        this.docs = docs;
        this.numVectors = numVectors;
    }

    public static KmeansFloatVectorValues build(List<float[]> vectors, int[] docs, int dim) {
        OnHeapVectorSupplier vectorSupplier = new OnHeapVectorSupplier(vectors, dim);
        OnHeapDocSupplier docSupplier = docs == null ? null : new OnHeapDocSupplier(docs);
        return new KmeansFloatVectorValues(vectorSupplier, docSupplier, vectors.size());
    }

    public static KmeansFloatVectorValues build(IndexInput vectors, IndexInput docs, int numVectors, int dims) throws IOException {
        OffHeapDocSupplier docSupplier;
        long vectorLength = (long)dims * 4L;
        float[] vector = new float[dims];
        OffHeapVectorSupplier vectorSupplier = new OffHeapVectorSupplier(vectors, vector, vectorLength);
        if (docs == null) {
            docSupplier = null;
        } else {
            RandomAccessInput randomDocs = docs.randomAccessSlice(0L, docs.length());
            docSupplier = new OffHeapDocSupplier(docs, randomDocs);
        }
        return new KmeansFloatVectorValues(vectorSupplier, docSupplier, numVectors);
    }

    public float[] vectorValue(int ord) throws IOException {
        return this.vectors.vector(ord);
    }

    public FloatVectorValues copy() {
        return new KmeansFloatVectorValues(this.vectors.copy(), this.docs != null ? this.docs.copy() : null, this.numVectors);
    }

    public int dimension() {
        return this.vectors.dims();
    }

    public int size() {
        return this.numVectors;
    }

    public int ordToDoc(int ord) {
        if (this.docs == null) {
            return ord;
        }
        return this.docs.ordToDoc(ord);
    }

    private static sealed interface VectorSupplier
    permits OffHeapVectorSupplier, OnHeapVectorSupplier {
        public float[] vector(int var1) throws IOException;

        public int dims();

        public VectorSupplier copy();
    }

    private static sealed interface DocSupplier
    permits OnHeapDocSupplier, OffHeapDocSupplier {
        public int ordToDoc(int var1);

        public DocSupplier copy();
    }

    private record OnHeapVectorSupplier(List<float[]> vectors, int dims) implements VectorSupplier
    {
        @Override
        public float[] vector(int ord) {
            return this.vectors.get(ord);
        }

        @Override
        public VectorSupplier copy() {
            return this;
        }
    }

    private record OnHeapDocSupplier(int[] docs) implements DocSupplier
    {
        @Override
        public int ordToDoc(int ord) {
            return this.docs[ord];
        }

        @Override
        public DocSupplier copy() {
            return this;
        }
    }

    private record OffHeapVectorSupplier(IndexInput vectors, float[] vector, long vectorLength) implements VectorSupplier
    {
        @Override
        public float[] vector(int ord) throws IOException {
            this.vectors.seek((long)ord * this.vectorLength);
            this.vectors.readFloats(this.vector, 0, this.vector.length);
            return this.vector;
        }

        @Override
        public int dims() {
            return this.vector.length;
        }

        @Override
        public VectorSupplier copy() {
            return new OffHeapVectorSupplier(this.vectors.clone(), (float[])this.vector.clone(), this.vectorLength);
        }
    }

    private record OffHeapDocSupplier(IndexInput docs, RandomAccessInput randomDocs) implements DocSupplier
    {
        @Override
        public int ordToDoc(int ord) {
            try {
                return this.randomDocs.readInt((long)ord * 4L);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public DocSupplier copy() {
            IndexInput docsCopy = this.docs.clone();
            try {
                RandomAccessInput randomDocsCopy = docsCopy.randomAccessSlice(0L, docsCopy.length());
                return new OffHeapDocSupplier(docsCopy, randomDocsCopy);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

