/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.cluster;

import java.io.IOException;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.hnsw.IntToIntFunction;
import org.elasticsearch.index.codec.vectors.cluster.KMeansIntermediate;
import org.elasticsearch.index.codec.vectors.cluster.KMeansLocal;
import org.elasticsearch.index.codec.vectors.cluster.NeighborHood;

class KMeansLocalSerial
extends KMeansLocal {
    KMeansLocalSerial(int sampleSize, int maxIterations) {
        super(sampleSize, maxIterations);
    }

    @Override
    protected int numWorkers() {
        return 1;
    }

    @Override
    protected boolean stepLloyd(FloatVectorValues vectors, IntToIntFunction translateOrd, float[][] centroids, FixedBitSet[] centroidChangedSlices, int[] assignments, NeighborHood[] neighborHoods) throws IOException {
        assert (centroidChangedSlices.length == 1);
        return KMeansLocalSerial.stepLloydSlice(vectors, translateOrd, centroids, centroidChangedSlices[0], assignments, neighborHoods, 0, vectors.size());
    }

    @Override
    protected void assignSpilled(FloatVectorValues vectors, KMeansIntermediate kmeansIntermediate, NeighborHood[] neighborhoods, float soarLambda) throws IOException {
        KMeansLocalSerial.assignSpilledSlice(vectors, kmeansIntermediate, neighborhoods, soarLambda, 0, vectors.size());
    }

    @Override
    protected NeighborHood[] computeNeighborhoods(float[][] centroids, int clustersPerNeighborhood) throws IOException {
        return NeighborHood.computeNeighborhoods(centroids, clustersPerNeighborhood);
    }
}

