/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.tsdb;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.index.codec.bloomfilter.BloomFilter;
import org.elasticsearch.index.codec.bloomfilter.DelegatingBloomFilterFieldsProducer;
import org.elasticsearch.index.codec.storedfields.TSDBStoredFieldsFormat;
import org.elasticsearch.index.codec.tsdb.TSDBSyntheticIdFieldsProducer;

public class TSDBSyntheticIdPostingsFormat
extends PostingsFormat {
    public static final String SYNTHETIC_ID = "_id";
    public static final String TIMESTAMP = "@timestamp";
    public static final String TS_ID = "_tsid";
    public static final String TS_ROUTING_HASH = "_ts_routing_hash";
    static final String FORMAT_NAME = "TSDBSyntheticId";
    static final String SUFFIX = "0";

    public TSDBSyntheticIdPostingsFormat() {
        super(FORMAT_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        DelegatingBloomFilterFieldsProducer delegatingBloomFilterFieldsProducer;
        block3: {
            DocValuesProducer docValuesProducer = null;
            boolean success = false;
            try {
                Codec codec = state.segmentInfo.getCodec();
                BloomFilter bloomFilter = TSDBStoredFieldsFormat.getBloomFilterForId(state);
                docValuesProducer = codec.docValuesFormat().fieldsProducer(new SegmentReadState(state, ""));
                TSDBSyntheticIdFieldsProducer fieldsProducer = new TSDBSyntheticIdFieldsProducer(state, docValuesProducer);
                success = true;
                delegatingBloomFilterFieldsProducer = new DelegatingBloomFilterFieldsProducer(fieldsProducer, bloomFilter);
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.close(docValuesProducer);
                }
                throw throwable;
            }
            IOUtils.close((Closeable)docValuesProducer);
        }
        return delegatingBloomFilterFieldsProducer;
    }

    public FieldsConsumer fieldsConsumer(final SegmentWriteState state) throws IOException {
        return new FieldsConsumer(this){

            public void write(Fields fields, NormsProducer norms) {
                if (state.context.flushInfo() != null) {
                    for (String field : fields) {
                        if (!TSDBSyntheticIdPostingsFormat.SYNTHETIC_ID.equalsIgnoreCase(field)) continue;
                        String message = "Field [_id] has terms produced during indexing";
                        assert (false) : message;
                        throw new IllegalArgumentException(message);
                    }
                }
            }

            public void close() {
            }
        };
    }
}

