/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.health;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.health.Diagnosis;
import org.elasticsearch.health.HealthIndicatorDetails;
import org.elasticsearch.health.HealthIndicatorImpact;
import org.elasticsearch.health.HealthStatus;
import org.elasticsearch.xcontent.ToXContent;

public record HealthIndicatorResult(String name, HealthStatus status, String symptom, HealthIndicatorDetails details, List<HealthIndicatorImpact> impacts, List<Diagnosis> diagnosisList) implements ChunkedToXContentObject
{
    private boolean hasDiagnosis() {
        return this.diagnosisList != null && !this.diagnosisList.isEmpty();
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params outerParams) {
        return Iterators.concat(ChunkedToXContentHelper.chunk((builder, params) -> {
            builder.startObject();
            builder.field("status", this.status.xContentValue());
            builder.field("symptom", this.symptom);
            if (this.details != null && !HealthIndicatorDetails.EMPTY.equals(this.details)) {
                builder.field("details", (ToXContent)this.details, params);
            }
            if (this.impacts != null && !this.impacts.isEmpty()) {
                builder.field("impacts", this.impacts);
            }
            if (this.hasDiagnosis()) {
                builder.startArray("diagnosis");
            }
            return builder;
        }), this.hasDiagnosis() ? Iterators.flatMap(this.diagnosisList.iterator(), s -> s.toXContentChunked(outerParams)) : Collections.emptyIterator(), ChunkedToXContentHelper.chunk((b, p) -> {
            if (this.hasDiagnosis()) {
                b.endArray();
            }
            return b.endObject();
        }));
    }
}

