/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.core.Releasable;

public final class KeyedLock<T> {
    private final ConcurrentMap<T, KeyLock> map = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();

    public Releasable acquire(T key) {
        KeyLock perNodeLock;
        while (true) {
            if ((perNodeLock = (KeyLock)this.map.get(key)) == null) {
                ReleasableLock newLock = this.tryCreateNewLock(key);
                if (newLock == null) continue;
                return newLock;
            }
            int i = perNodeLock.count;
            if (i > 0 && perNodeLock.tryIncCount(i)) break;
        }
        perNodeLock.lock();
        return new ReleasableLock(key, perNodeLock);
    }

    public Releasable tryAcquire(T key) {
        KeyLock perNodeLock = (KeyLock)this.map.get(key);
        if (perNodeLock == null) {
            return this.tryCreateNewLock(key);
        }
        if (perNodeLock.tryLock()) {
            int i;
            while ((i = perNodeLock.count) > 0) {
                if (!perNodeLock.tryIncCount(i)) continue;
                return new ReleasableLock(key, perNodeLock);
            }
            perNodeLock.unlock();
        }
        return null;
    }

    private ReleasableLock tryCreateNewLock(T key) {
        KeyLock newLock = new KeyLock();
        newLock.lock();
        KeyLock keyLock = this.map.putIfAbsent(key, newLock);
        if (keyLock == null) {
            return new ReleasableLock(key, newLock);
        }
        return null;
    }

    public boolean isHeldByCurrentThread(T key) {
        KeyLock lock = (KeyLock)this.map.get(key);
        if (lock == null) {
            return false;
        }
        return lock.isHeldByCurrentThread();
    }

    private void release(T key, KeyLock lock) {
        assert (lock == this.map.get(key));
        int decrementAndGet = lock.decCountAndGet();
        lock.unlock();
        if (decrementAndGet == 0) {
            this.map.remove(key, lock);
        }
        assert (decrementAndGet >= 0) : decrementAndGet + " must be >= 0 but wasn't";
    }

    public boolean hasLockedKeys() {
        return !this.map.isEmpty();
    }

    private static final class KeyLock
    extends ReentrantLock {
        private static final VarHandle VH_COUNT_FIELD;
        private volatile int count = 1;

        KeyLock() {
        }

        int decCountAndGet() {
            int newCount;
            int i;
            while (!VH_COUNT_FIELD.weakCompareAndSet(this, i = this.count, newCount = i - 1)) {
            }
            return newCount;
        }

        boolean tryIncCount(int expectedCount) {
            return VH_COUNT_FIELD.compareAndSet(this, expectedCount, expectedCount + 1);
        }

        static {
            try {
                VH_COUNT_FIELD = MethodHandles.lookup().in(KeyLock.class).findVarHandle(KeyLock.class, "count", Integer.TYPE);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private final class ReleasableLock
    extends AtomicReference<T>
    implements Releasable {
        final KeyLock lock;

        private ReleasableLock(T key, KeyLock lock) {
            super(key);
            this.lock = lock;
        }

        public void close() {
            Object k = this.getAndSet(null);
            if (k != null) {
                KeyedLock.this.release(k, this.lock);
            }
        }
    }
}

