/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.nio.file.Path;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;
import org.elasticsearch.common.Strings;

public class CollectionUtils {
    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static <T> void uniquify(List<T> list, Comparator<T> cmp) {
        if (list.size() <= 1) {
            return;
        }
        ListIterator<T> resultItr = list.listIterator();
        ListIterator<T> currentItr = list.listIterator(1);
        T lastValue = resultItr.next();
        do {
            T currentValue;
            if (cmp.compare(lastValue, currentValue = currentItr.next()) == 0) continue;
            lastValue = currentValue;
            resultItr.next();
            if (resultItr.previousIndex() == currentItr.previousIndex()) continue;
            resultItr.set(currentValue);
        } while (currentItr.hasNext());
        list.subList(resultItr.nextIndex(), list.size()).clear();
    }

    public static <T> List<T> rotate(List<T> list, int distance) {
        if (list.isEmpty()) {
            return list;
        }
        int d = distance % list.size();
        if (d < 0) {
            d += list.size();
        }
        if (d == 0) {
            return list;
        }
        return new RotatedList<T>(list, d);
    }

    public static int[] toArray(Collection<Integer> ints) {
        Objects.requireNonNull(ints);
        return ints.stream().mapToInt(s -> s).toArray();
    }

    public static void ensureNoSelfReferences(Object value, String messageHint) {
        CollectionUtils.ensureNoSelfReferences(value, null, messageHint);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void ensureNoSelfReferences(Object value, Set<Object> ancestors, String messageHint) {
        Map m;
        if (value == null) return;
        if (value instanceof String) return;
        if (value instanceof Number) return;
        if (value instanceof Boolean) {
            return;
        }
        Set<Object> set = ancestors = ancestors != null ? ancestors : Collections.newSetFromMap(new IdentityHashMap());
        if (value instanceof Map && !(m = (Map)value).isEmpty()) {
            CollectionUtils.ensureNoSelfReferences(m, ancestors, messageHint);
            return;
        }
        if (value instanceof Iterable) {
            Iterable i = (Iterable)value;
            if (!(value instanceof Path)) {
                CollectionUtils.ensureNoSelfReferences(i, i, ancestors, messageHint);
                return;
            }
        }
        if (!(value instanceof Object[])) return;
        CollectionUtils.ensureNoSelfReferences(Arrays.asList((Object[])value), value, ancestors, messageHint);
    }

    private static void ensureNoSelfReferences(Map<?, ?> reference, Set<Object> ancestors, String messageHint) {
        CollectionUtils.addToAncestorsOrThrow(reference, ancestors, messageHint);
        for (Map.Entry<?, ?> e : reference.entrySet()) {
            CollectionUtils.ensureNoSelfReferences(e.getKey(), ancestors, messageHint);
            CollectionUtils.ensureNoSelfReferences(e.getValue(), ancestors, messageHint);
        }
        ancestors.remove(reference);
    }

    private static void ensureNoSelfReferences(Iterable<?> iterable, Object reference, Set<Object> ancestors, String messageHint) {
        CollectionUtils.addToAncestorsOrThrow(reference, ancestors, messageHint);
        for (Object o : iterable) {
            CollectionUtils.ensureNoSelfReferences(o, ancestors, messageHint);
        }
        ancestors.remove(reference);
    }

    private static void addToAncestorsOrThrow(Object reference, Set<Object> ancestors, String messageHint) {
        if (!ancestors.add(reference)) {
            StringBuilder sb = new StringBuilder("Iterable object is self-referencing itself");
            if (Strings.hasLength(messageHint)) {
                sb.append(" (").append(messageHint).append(")");
            }
            throw new IllegalArgumentException(sb.toString());
        }
    }

    public static <E> ArrayList<E> iterableAsArrayList(Iterable<? extends E> elements) {
        if (elements == null) {
            throw new NullPointerException("elements");
        }
        if (elements instanceof Collection) {
            return new ArrayList((Collection)elements);
        }
        ArrayList<E> list = new ArrayList<E>();
        for (E element : elements) {
            list.add(element);
        }
        return list;
    }

    @SafeVarargs
    public static <E> ArrayList<E> arrayAsArrayList(E ... elements) {
        if (elements == null) {
            throw new NullPointerException("elements");
        }
        return new ArrayList<E>(Arrays.asList(elements));
    }

    public static <E> List<E> appendToCopy(Collection<E> collection, E element) {
        int size = collection.size() + 1;
        Object[] array = collection.toArray(new Object[size]);
        array[size - 1] = element;
        return Collections.unmodifiableList(Arrays.asList(array));
    }

    public static <E> List<E> appendToCopyNoNullElements(Collection<E> collection, E element) {
        int existingSize = collection.size();
        if (existingSize == 0) {
            return List.of(element);
        }
        int size = existingSize + 1;
        Object[] array = collection.toArray(new Object[size]);
        array[size - 1] = element;
        return List.of(array);
    }

    public static <E> List<E> appendToCopyNoNullElements(Collection<E> collection, E ... elements) {
        int existingSize = collection.size();
        if (existingSize == 0) {
            return List.of(elements);
        }
        int addedSize = elements.length;
        int size = existingSize + addedSize;
        Object[] array = collection.toArray(new Object[size]);
        System.arraycopy(elements, 0, array, size - addedSize, addedSize);
        return List.of(array);
    }

    public static <E> ArrayList<E> newSingletonArrayList(E element) {
        return new ArrayList<E>(Collections.singletonList(element));
    }

    public static <E> List<List<E>> eagerPartition(List<E> list, int size) {
        if (list == null) {
            throw new NullPointerException("list");
        }
        if (size <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        ArrayList result = new ArrayList((int)Math.ceil(list.size() / size));
        ArrayList<E> accumulator = new ArrayList<E>(size);
        int count = 0;
        for (E element : list) {
            if (count == size) {
                result.add(accumulator);
                accumulator = new ArrayList(size);
                count = 0;
            }
            accumulator.add(element);
            ++count;
        }
        if (count > 0) {
            result.add(accumulator);
        }
        return result;
    }

    public static <E> List<E> concatLists(List<E> listA, Collection<E> listB) {
        ArrayList<E> concatList = new ArrayList<E>(listA.size() + listB.size());
        concatList.addAll(listA);
        concatList.addAll(listB);
        return concatList;
    }

    public static <E> List<E> wrapUnmodifiableOrEmptySingleton(List<E> list) {
        return list.isEmpty() ? List.of() : Collections.unmodifiableList(list);
    }

    public static <E> List<E> limitSize(List<E> list, int size) {
        return list.size() <= size ? list : list.subList(0, size);
    }

    private static class RotatedList<T>
    extends AbstractList<T>
    implements RandomAccess {
        private final List<T> in;
        private final int distance;

        RotatedList(List<T> list, int distance) {
            if (distance < 0 || distance >= list.size()) {
                throw new IllegalArgumentException();
            }
            if (!(list instanceof RandomAccess)) {
                throw new IllegalArgumentException();
            }
            this.in = list;
            this.distance = distance;
        }

        @Override
        public T get(int index) {
            int idx = this.distance + index;
            if (idx < 0 || idx >= this.in.size()) {
                idx -= this.in.size();
            }
            return this.in.get(idx);
        }

        @Override
        public int size() {
            return this.in.size();
        }
    }
}

