/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.metrics;

import java.util.Arrays;
import java.util.concurrent.atomic.LongAdder;

public class ExponentialBucketHistogram {
    private final int bucketCount;
    private final long lastBucketLowerBound;
    private final LongAdder[] buckets;

    public static int[] getBucketUpperBounds(int bucketCount) {
        int[] bounds = new int[bucketCount - 1];
        for (int i = 0; i < bounds.length; ++i) {
            bounds[i] = 1 << i;
        }
        return bounds;
    }

    private int getBucket(long observedValue) {
        if (observedValue <= 0L) {
            return 0;
        }
        if (this.lastBucketLowerBound <= observedValue) {
            return this.bucketCount - 1;
        }
        return 64 - Long.numberOfLeadingZeros(observedValue);
    }

    public ExponentialBucketHistogram(int bucketCount) {
        if (bucketCount < 2 || bucketCount > 32) {
            throw new IllegalArgumentException("Bucket count must be in [2, 32], got " + bucketCount);
        }
        this.bucketCount = bucketCount;
        this.lastBucketLowerBound = ExponentialBucketHistogram.getBucketUpperBounds(bucketCount)[bucketCount - 2];
        this.buckets = new LongAdder[bucketCount];
        for (int i = 0; i < bucketCount; ++i) {
            this.buckets[i] = new LongAdder();
        }
    }

    public int[] calculateBucketUpperBounds() {
        return ExponentialBucketHistogram.getBucketUpperBounds(this.bucketCount);
    }

    public void addObservation(long observedValue) {
        this.buckets[this.getBucket(observedValue)].increment();
    }

    public long[] getSnapshot() {
        long[] histogram = new long[this.bucketCount];
        for (int i = 0; i < this.bucketCount; ++i) {
            histogram[i] = this.buckets[i].longValue();
        }
        return histogram;
    }

    public long getPercentile(float percentile) {
        return this.getPercentile(percentile, this.getSnapshot(), this.calculateBucketUpperBounds());
    }

    public long getPercentile(float percentile, long[] snapshot, int[] bucketUpperBounds) {
        assert (snapshot.length == this.bucketCount && bucketUpperBounds.length == this.bucketCount - 1);
        if (percentile < 0.0f || percentile > 1.0f) {
            throw new IllegalArgumentException("Requested percentile must be in [0, 1.0], percentile=" + percentile);
        }
        long totalCount = Arrays.stream(snapshot).sum();
        long percentileIndex = (long)Math.ceil((float)totalCount * percentile);
        for (int i = 0; i < this.bucketCount; ++i) {
            if ((percentileIndex -= snapshot[i]) > 0L) continue;
            if (i == snapshot.length - 1) {
                return Long.MAX_VALUE;
            }
            return bucketUpperBounds[i];
        }
        assert (false) : "We shouldn't ever get here";
        return Long.MAX_VALUE;
    }

    public void clear() {
        for (int i = 0; i < this.bucketCount; ++i) {
            this.buckets[i].reset();
        }
    }
}

