/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.PrefixLogger;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.transport.NetworkTraceFlag;

public class Loggers {
    public static final String SPACE = " ";
    static final List<String> RESTRICTED_LOGGERS = NetworkTraceFlag.TRACE_ENABLED ? Collections.emptyList() : List.of("org.apache.http", "com.amazonaws.request", "software.amazon.awssdk");
    public static final Setting<Level> LOG_DEFAULT_LEVEL_SETTING = new Setting<Level>("logger.level", Level.INFO.name(), Level::valueOf, Setting.Property.NodeScope);
    public static final Setting.AffixSetting<Level> LOG_LEVEL_SETTING = Setting.prefixKeySetting("logger.", key -> new Setting<Level>((String)key, Level.INFO.name(), Level::valueOf, Setting.Property.Dynamic, Setting.Property.NodeScope));

    private Loggers() {
    }

    public static List<String> checkRestrictedLoggers(Settings settings) {
        return Loggers.checkRestrictedLoggers(settings, RESTRICTED_LOGGERS);
    }

    static List<String> checkRestrictedLoggers(Settings settings, List<String> restrictions) {
        ArrayList<String> errors = null;
        for (String key : settings.keySet()) {
            Level level;
            if (!LOG_LEVEL_SETTING.match(key) || (level = Level.toLevel((String)settings.get(key), null)) == null) continue;
            String logger = key.substring("logger.".length());
            if (level.intLevel() <= Level.INFO.intLevel() || !restrictions.stream().anyMatch(r -> Loggers.isSameOrDescendantOf(logger, r))) continue;
            if (errors == null) {
                errors = new ArrayList<String>(2);
            }
            errors.add(Strings.format("Level [%s] is not permitted for logger [%s]", level, logger));
        }
        return errors == null ? Collections.emptyList() : errors;
    }

    public static Logger getLogger(Class<?> clazz, ShardId shardId, String ... prefixes) {
        return Loggers.getLogger(clazz, shardId.getIndex(), (String[])Stream.concat(Stream.of(Integer.toString(shardId.id())), Arrays.stream(prefixes)).toArray(String[]::new));
    }

    public static Logger getLogger(String loggerName, ShardId shardId) {
        String prefix = Loggers.formatPrefix(shardId.getIndexName(), Integer.toString(shardId.id()));
        return new PrefixLogger(LogManager.getLogger((String)loggerName), prefix);
    }

    public static Logger getLogger(Class<?> clazz, Index index, String ... prefixes) {
        return Loggers.getLogger(clazz, (String[])Stream.concat(Stream.of(SPACE, index.getName()), Arrays.stream(prefixes)).toArray(String[]::new));
    }

    public static Logger getLogger(Class<?> clazz, String ... prefixes) {
        return new PrefixLogger(LogManager.getLogger(clazz), Loggers.formatPrefix(prefixes));
    }

    public static Logger getLogger(Logger parentLogger, String s) {
        Logger inner = LogManager.getLogger((String)(parentLogger.getName() + s));
        if (parentLogger instanceof PrefixLogger) {
            return new PrefixLogger(inner, ((PrefixLogger)parentLogger).prefix());
        }
        return inner;
    }

    private static String formatPrefix(String ... prefixes) {
        String prefix = null;
        if (prefixes != null && prefixes.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (String prefixX : prefixes) {
                if (prefixX == null) continue;
                if (prefixX.equals(SPACE)) {
                    sb.append(SPACE);
                    continue;
                }
                sb.append("[").append(prefixX).append("]");
            }
            if (sb.length() > 0) {
                prefix = sb.toString();
            }
        }
        return prefix;
    }

    public static void setLevel(Logger logger, String level) {
        Loggers.setLevel(logger, level == null ? null : Level.valueOf((String)level), RESTRICTED_LOGGERS);
    }

    public static void setLevel(Logger logger, Level level) {
        Loggers.setLevel(logger, level, RESTRICTED_LOGGERS);
    }

    static void setLevel(Logger logger, Level level, List<String> restrictions) {
        LoggerContext ctx;
        boolean setRestriction = false;
        if (Loggers.isRootLogger(logger.getName())) {
            assert (level != null) : "Log level is required when configuring the root logger";
            ctx = LoggerContext.getContext((boolean)false);
            Configuration config = ctx.getConfiguration();
            LoggerConfig loggerConfig = config.getLoggerConfig(logger.getName());
            loggerConfig.setLevel(level);
            ctx.updateLoggers();
            setRestriction = level.intLevel() > Level.INFO.intLevel();
        } else {
            Level actual;
            Level level2 = actual = level != null ? level : Loggers.parentLoggerLevel(logger);
            if (actual.intLevel() > Level.INFO.intLevel()) {
                for (String restricted : restrictions) {
                    if (Loggers.isSameOrDescendantOf(logger.getName(), restricted)) {
                        LogManager.getLogger(Loggers.class).warn("Level [{}/{}] not permitted for logger [{}], skipping.", (Object)level, (Object)actual, (Object)logger.getName());
                        return;
                    }
                    if (!Loggers.isDescendantOf(restricted, logger.getName())) continue;
                    setRestriction = true;
                }
            }
            Configurator.setLevel((String)logger.getName(), (Level)level);
        }
        ctx = LoggerContext.getContext((boolean)false);
        for (LoggerConfig loggerConfig : ctx.getConfiguration().getLoggers().values()) {
            if (!Loggers.isDescendantOf(loggerConfig.getName(), logger.getName())) continue;
            Configurator.setLevel((String)loggerConfig.getName(), (Level)level);
        }
        if (setRestriction) {
            for (String restricted : restrictions) {
                if (!Loggers.isDescendantOf(restricted, logger.getName())) continue;
                Loggers.setLevel(LogManager.getLogger((String)restricted), Level.INFO, Collections.emptyList());
            }
        }
    }

    private static Level parentLoggerLevel(Logger logger) {
        int idx = logger.getName().lastIndexOf(46);
        if (idx != -1) {
            return LogManager.getLogger((String)logger.getName().substring(0, idx)).getLevel();
        }
        return LogManager.getRootLogger().getLevel();
    }

    private static boolean isRootLogger(String name) {
        return "".equals(name);
    }

    private static boolean isDescendantOf(String candidate, String ancestor) {
        return Loggers.isRootLogger(ancestor) || candidate.startsWith(ancestor + ".");
    }

    private static boolean isSameOrDescendantOf(String candidate, String ancestor) {
        return candidate.equals(ancestor) || Loggers.isDescendantOf(candidate, ancestor);
    }

    public static void addAppender(Logger logger, Appender appender) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        config.addAppender(appender);
        LoggerConfig loggerConfig = config.getLoggerConfig(logger.getName());
        if (!logger.getName().equals(loggerConfig.getName())) {
            loggerConfig = new LoggerConfig(logger.getName(), logger.getLevel(), true);
            config.addLogger(logger.getName(), loggerConfig);
        }
        loggerConfig.addAppender(appender, null, null);
        ctx.updateLoggers();
    }

    public static void removeAppender(Logger logger, Appender appender) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig(logger.getName());
        if (!logger.getName().equals(loggerConfig.getName())) {
            loggerConfig = new LoggerConfig(logger.getName(), logger.getLevel(), true);
            config.addLogger(logger.getName(), loggerConfig);
        }
        loggerConfig.removeAppender(appender.getName());
        ctx.updateLoggers();
    }

    public static Appender findAppender(Logger logger, Class<? extends Appender> clazz) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig(logger.getName());
        for (Map.Entry entry : loggerConfig.getAppenders().entrySet()) {
            if (!((Appender)entry.getValue()).getClass().equals(clazz)) continue;
            return (Appender)entry.getValue();
        }
        return null;
    }
}

