/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.EOFException;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;

public class ByteBufferStreamInput
extends StreamInput {
    private final ByteBuffer buffer;

    public ByteBufferStreamInput(ByteBuffer buffer) {
        this.buffer = buffer.mark();
    }

    public static int readVInt(ByteBuffer buffer) throws IOException {
        byte b = buffer.get();
        if (b >= 0) {
            return b;
        }
        int i = b & 0x7F;
        b = buffer.get();
        i |= (b & 0x7F) << 7;
        if (b >= 0) {
            return i;
        }
        b = buffer.get();
        i |= (b & 0x7F) << 14;
        if (b >= 0) {
            return i;
        }
        b = buffer.get();
        i |= (b & 0x7F) << 21;
        if (b >= 0) {
            return i;
        }
        b = buffer.get();
        i |= (b & 0xF) << 28;
        if ((b & 0xF0) != 0) {
            ByteBufferStreamInput.throwOnBrokenVInt(b, i);
        }
        return i;
    }

    public static long readVLong(ByteBuffer buffer) throws IOException {
        byte b = buffer.get();
        long i = (long)b & 0x7FL;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = buffer.get();
        i |= ((long)b & 0x7FL) << 7;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = buffer.get();
        i |= ((long)b & 0x7FL) << 14;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = buffer.get();
        i |= ((long)b & 0x7FL) << 21;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = buffer.get();
        i |= ((long)b & 0x7FL) << 28;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = buffer.get();
        i |= ((long)b & 0x7FL) << 35;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = buffer.get();
        i |= ((long)b & 0x7FL) << 42;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = buffer.get();
        i |= ((long)b & 0x7FL) << 49;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = buffer.get();
        i |= ((long)b & 0x7FL) << 56;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = buffer.get();
        if (b != 0 && b != 1) {
            ByteBufferStreamInput.throwOnBrokenVLong(b, i);
        }
        return i |= (long)b << 63;
    }

    @Override
    public String readString() throws IOException {
        String string;
        int chars = this.readArraySize();
        ByteBuffer buffer = this.buffer;
        if (buffer.hasArray() && (string = this.tryReadStringFromBytes(buffer.array(), buffer.position() + buffer.arrayOffset(), buffer.limit() + buffer.arrayOffset(), chars)) != null) {
            return string;
        }
        return this.doReadString(chars);
    }

    @Override
    public int read() throws IOException {
        ByteBuffer buffer = this.buffer;
        if (!buffer.hasRemaining()) {
            return -1;
        }
        return buffer.get() & 0xFF;
    }

    @Override
    public byte readByte() throws IOException {
        try {
            return this.buffer.get();
        }
        catch (BufferUnderflowException ex) {
            throw ByteBufferStreamInput.newEOFException(ex);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        ByteBuffer buffer = this.buffer;
        if (!buffer.hasRemaining()) {
            return -1;
        }
        len = Math.min(len, buffer.remaining());
        buffer.get(b, off, len);
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        ByteBuffer buffer = this.buffer;
        int remaining = buffer.remaining();
        if (n > (long)remaining) {
            buffer.position(buffer.limit());
            return remaining;
        }
        buffer.position((int)((long)buffer.position() + n));
        return n;
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) throws IOException {
        try {
            this.buffer.get(b, offset, len);
        }
        catch (BufferUnderflowException ex) {
            throw ByteBufferStreamInput.newEOFException(ex);
        }
    }

    @Override
    public short readShort() throws IOException {
        try {
            return this.buffer.getShort();
        }
        catch (BufferUnderflowException ex) {
            throw ByteBufferStreamInput.newEOFException(ex);
        }
    }

    @Override
    public int readInt() throws IOException {
        try {
            return this.buffer.getInt();
        }
        catch (BufferUnderflowException ex) {
            throw ByteBufferStreamInput.newEOFException(ex);
        }
    }

    @Override
    public int readVInt() throws IOException {
        try {
            return ByteBufferStreamInput.readVInt(this.buffer);
        }
        catch (BufferUnderflowException ex) {
            throw ByteBufferStreamInput.newEOFException(ex);
        }
    }

    @Override
    public long readLong() throws IOException {
        try {
            return this.buffer.getLong();
        }
        catch (BufferUnderflowException ex) {
            throw ByteBufferStreamInput.newEOFException(ex);
        }
    }

    @Override
    public long readVLong() throws IOException {
        try {
            return ByteBufferStreamInput.readVLong(this.buffer);
        }
        catch (BufferUnderflowException ex) {
            throw ByteBufferStreamInput.newEOFException(ex);
        }
    }

    private static EOFException newEOFException(RuntimeException ex) {
        EOFException eofException = new EOFException();
        eofException.initCause(ex);
        return eofException;
    }

    @Override
    public void reset() throws IOException {
        this.buffer.reset();
    }

    @Override
    public int available() throws IOException {
        return this.buffer.remaining();
    }

    @Override
    protected void ensureCanReadBytes(int length) throws EOFException {
        int available = this.buffer.remaining();
        if (length > available) {
            ByteBufferStreamInput.throwEOF(length, available);
        }
    }

    @Override
    public BytesReference readSlicedBytesReference() throws IOException {
        ByteBuffer buffer = this.buffer;
        if (buffer.hasArray()) {
            int len = this.readVInt();
            BytesArray res = new BytesArray(buffer.array(), buffer.arrayOffset() + buffer.position(), len);
            this.skip(len);
            return res;
        }
        return super.readSlicedBytesReference();
    }

    @Override
    public void mark(int readlimit) {
        this.buffer.mark();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void close() throws IOException {
    }
}

