/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.hash;

import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.common.hash.Murmur3Hasher;
import org.elasticsearch.common.hash.MurmurHash3;
import org.elasticsearch.common.util.ByteUtils;

public class BufferedMurmur3Hasher
extends Murmur3Hasher {
    public static final int DEFAULT_BUFFER_SIZE = 128;
    private byte[] buffer;
    private int pos;

    public BufferedMurmur3Hasher(long seed) {
        this(seed, 128);
    }

    public BufferedMurmur3Hasher(long seed, int bufferSize) {
        super(seed);
        if (bufferSize < 32) {
            throw new IllegalArgumentException("Buffer size must be at least 32 bytes");
        }
        this.buffer = new byte[bufferSize];
    }

    @Override
    public MurmurHash3.Hash128 digestHash(MurmurHash3.Hash128 hash) {
        this.flush();
        return super.digestHash(hash);
    }

    @Override
    public void reset() {
        super.reset();
        this.pos = 0;
    }

    public void addString(String value) {
        int requiredBufferLength = UnicodeUtil.maxUTF8Length((int)value.length());
        this.ensureCapacity(requiredBufferLength);
        this.flushIfRemainingCapacityLowerThan(requiredBufferLength);
        this.pos = UnicodeUtil.UTF16toUTF8((CharSequence)value, (int)0, (int)value.length(), (byte[])this.buffer, (int)this.pos);
    }

    public void addLong(long value) {
        this.flushIfRemainingCapacityLowerThan(8);
        ByteUtils.writeLongLE(value, this.buffer, this.pos);
        this.pos += 8;
    }

    public void addLongs(long v1, long v2) {
        this.flushIfRemainingCapacityLowerThan(16);
        ByteUtils.writeLongLE(v1, this.buffer, this.pos);
        ByteUtils.writeLongLE(v2, this.buffer, this.pos + 8);
        this.pos += 16;
    }

    public void addLongs(long v1, long v2, long v3, long v4) {
        this.flushIfRemainingCapacityLowerThan(32);
        ByteUtils.writeLongLE(v1, this.buffer, this.pos);
        ByteUtils.writeLongLE(v2, this.buffer, this.pos + 8);
        ByteUtils.writeLongLE(v3, this.buffer, this.pos + 16);
        ByteUtils.writeLongLE(v4, this.buffer, this.pos + 24);
        this.pos += 32;
    }

    private void ensureCapacity(int requiredBufferLength) {
        if (this.buffer.length < requiredBufferLength) {
            this.flush();
            this.buffer = new byte[requiredBufferLength];
        }
    }

    private void flush() {
        if (this.pos > 0) {
            this.update(this.buffer, 0, this.pos);
            this.pos = 0;
        }
    }

    private void flushIfRemainingCapacityLowerThan(int requiredCapacity) {
        if (this.buffer.length - this.pos < requiredCapacity) {
            this.flush();
        }
    }
}

