/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import java.util.Locale;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.indices.InvalidIndexNameException;

public final class IndexNameGenerator {
    public static final Pattern ILLEGAL_INDEXNAME_CHARS_REGEX = Pattern.compile("[/:\"*?<>|# ,\\\\]+");
    public static final int MAX_GENERATED_UUID_LENGTH = 4;

    private IndexNameGenerator() {
    }

    public static String generateValidIndexName(String prefix, String indexName) {
        String randomUUID = IndexNameGenerator.generateValidIndexSuffix(UUIDs::randomBase64UUID);
        randomUUID = randomUUID.substring(0, Math.min(randomUUID.length(), 4));
        return prefix + randomUUID + "-" + indexName;
    }

    public static String generateValidIndexSuffix(Supplier<String> randomGenerator) {
        String randomSuffix = randomGenerator.get().toLowerCase(Locale.ROOT);
        if ((randomSuffix = ILLEGAL_INDEXNAME_CHARS_REGEX.matcher(randomSuffix).replaceAll("")).isEmpty()) {
            throw new IllegalArgumentException("unable to generate random index name suffix");
        }
        return randomSuffix;
    }

    @Nullable
    public static ActionRequestValidationException validateGeneratedIndexName(String generatedIndexName, ProjectState projectState) {
        ActionRequestValidationException err = new ActionRequestValidationException();
        try {
            MetadataCreateIndexService.validateIndexOrAliasName(generatedIndexName, InvalidIndexNameException::new);
        }
        catch (InvalidIndexNameException e) {
            err.addValidationError(e.getMessage());
        }
        if (projectState.routingTable().hasIndex(generatedIndexName) || projectState.metadata().hasIndex(generatedIndexName)) {
            err.addValidationError("the index name we generated [" + generatedIndexName + "] already exists");
        }
        if (projectState.metadata().hasAlias(generatedIndexName)) {
            err.addValidationError("the index name we generated [" + generatedIndexName + "] already exists as alias");
        }
        if (err.validationErrors().size() > 0) {
            return err;
        }
        return null;
    }
}

