/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.routing.allocation.AllocationDecision;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public sealed interface Decision
extends ToXContent,
Writeable {
    public static final Single ALWAYS;
    public static final Single YES;
    public static final Single NOT_PREFERRED;
    public static final Single NO;
    public static final Single THROTTLE;

    public static Decision single(Type type, @Nullable String label, @Nullable String explanation, Object ... explanationParams) {
        return new Single(type, label, explanation, explanationParams);
    }

    public static Decision readFrom(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            Multi result = new Multi();
            int decisionCount = in.readVInt();
            for (int i = 0; i < decisionCount; ++i) {
                boolean flag = in.readBoolean();
                if (!1.$assertionsDisabled && flag) {
                    throw new AssertionError((Object)"nested multi decision is not permitted");
                }
                Single single = Decision.readSingleFrom(in);
                result.decisions.add(single);
            }
            return result;
        }
        return Decision.readSingleFrom(in);
    }

    private static Single readSingleFrom(StreamInput in) throws IOException {
        Type type = Type.readFrom(in);
        String label = in.readOptionalString();
        String explanation = in.readOptionalString();
        if (label == null && explanation == null) {
            return switch (type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 3 -> YES;
                case 1 -> NOT_PREFERRED;
                case 2 -> THROTTLE;
                case 0 -> NO;
            };
        }
        return new Single(type, label, explanation);
    }

    public Type type();

    @Nullable
    public String label();

    @Nullable
    public String getExplanation();

    public List<Decision> getDecisions();

    public static Type minimumDecisionTypeThrottleOrYes(Decision decision1, Decision decision2) {
        if (!1.$assertionsDisabled && decision1.type() != Type.YES && decision1.type() != Type.THROTTLE) {
            throw new AssertionError((Object)"We should only see YES/THROTTLE decisions here");
        }
        if (!1.$assertionsDisabled && decision2.type() != Type.YES && decision2.type() != Type.THROTTLE) {
            throw new AssertionError((Object)"We should only see YES/THROTTLE decisions here");
        }
        return decision1.type() == Type.THROTTLE || decision2.type() == Type.THROTTLE ? Type.THROTTLE : Type.YES;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        ALWAYS = new Single(Type.YES);
        YES = new Single(Type.YES);
        NOT_PREFERRED = new Single(Type.NOT_PREFERRED);
        NO = new Single(Type.NO);
        THROTTLE = new Single(Type.THROTTLE);
    }

    public record Single(Type type, String label, String explanationString) implements Decision,
    ToXContentObject
    {
        private Single(Type type) {
            this(type, null, null, null);
        }

        public Single(Type type, @Nullable String label, @Nullable String explanation, Object ... explanationParams) {
            this(type, label, explanationParams != null && explanationParams.length > 0 ? String.format(Locale.ROOT, explanation, explanationParams) : explanation);
        }

        @Override
        public List<Decision> getDecisions() {
            return Collections.singletonList(this);
        }

        @Override
        @Nullable
        public String getExplanation() {
            return this.explanationString;
        }

        @Override
        public String toString() {
            if (this.explanationString != null) {
                return String.valueOf(this.type) + "(" + this.explanationString + ")";
            }
            return String.valueOf(this.type) + "()";
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("decider", this.label);
            builder.field("decision", (Enum)this.type);
            builder.field("explanation", this.explanationString != null ? this.explanationString : "none");
            builder.endObject();
            return builder;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(false);
            this.type.writeTo(out);
            out.writeOptionalString(this.label);
            out.writeOptionalString(this.explanationString);
        }
    }

    public static enum Type implements Writeable
    {
        NO(0, 0),
        NOT_PREFERRED(1, 2),
        THROTTLE(2, 1),
        YES(3, 3);

        static final TransportVersion ALLOCATION_DECISION_NOT_PREFERRED;
        private final int nodeComparisonOrdinal;
        private final int decisionComparisonOrdinal;

        private Type(int nodeComparisonOrdinal, int decisionComparisonOrdinal) {
            this.nodeComparisonOrdinal = nodeComparisonOrdinal;
            this.decisionComparisonOrdinal = decisionComparisonOrdinal;
        }

        public static Type readFrom(StreamInput in) throws IOException {
            if (in.getTransportVersion().supports(AllocationDecision.ADD_NOT_PREFERRED_ALLOCATION_DECISION)) {
                return in.readEnum(Type.class);
            }
            if (in.getTransportVersion().supports(ALLOCATION_DECISION_NOT_PREFERRED)) {
                int i = in.readVInt();
                return switch (i) {
                    case 0 -> NO;
                    case 1 -> THROTTLE;
                    case 2 -> NOT_PREFERRED;
                    case 3 -> YES;
                    default -> throw new IllegalArgumentException("No type for integer [" + i + "]");
                };
            }
            int i = in.readVInt();
            return switch (i) {
                case 0 -> NO;
                case 1 -> YES;
                case 2 -> THROTTLE;
                default -> throw new IllegalArgumentException("No Type for integer [" + i + "]");
            };
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (out.getTransportVersion().supports(AllocationDecision.ADD_NOT_PREFERRED_ALLOCATION_DECISION)) {
                out.writeEnum(this);
            } else if (out.getTransportVersion().supports(ALLOCATION_DECISION_NOT_PREFERRED)) {
                out.writeVInt(switch (this.ordinal()) {
                    case 1 -> 2;
                    case 2 -> 1;
                    default -> this.ordinal();
                });
            } else {
                out.writeVInt(switch (this.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> 0;
                    case 1, 3 -> 1;
                    case 2 -> 2;
                });
            }
        }

        public int compareToBetweenNodes(Type other) {
            return Integer.compare(this.nodeComparisonOrdinal, other.nodeComparisonOrdinal);
        }

        public int compareToBetweenDecisions(Type other) {
            return Integer.compare(this.decisionComparisonOrdinal, other.decisionComparisonOrdinal);
        }

        public boolean assignmentAllowed() {
            return this == NOT_PREFERRED || this == YES;
        }

        static {
            ALLOCATION_DECISION_NOT_PREFERRED = TransportVersion.fromName("allocation_decision_not_preferred");
        }
    }

    public record Multi(List<Single> decisions) implements Decision,
    ToXContentFragment
    {
        public Multi() {
            this(new ArrayList<Single>());
        }

        public Multi add(Decision decision) {
            assert (decision instanceof Single);
            this.decisions.add((Single)decision);
            return this;
        }

        @Override
        public Type type() {
            Type worst = Type.YES;
            for (Single decision : this.decisions) {
                Type next = decision.type();
                if (next.compareToBetweenDecisions(worst) >= 0) continue;
                worst = next;
            }
            return worst;
        }

        @Override
        @Nullable
        public String label() {
            return null;
        }

        @Override
        @Nullable
        public String getExplanation() {
            throw new UnsupportedOperationException("multi-level decisions do not have an explanation");
        }

        @Override
        public List<Decision> getDecisions() {
            return Collections.unmodifiableList(this.decisions);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Decision decision : this.decisions) {
                sb.append("[").append(decision.toString()).append("]");
            }
            return sb.toString();
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            for (Decision decision : this.decisions) {
                decision.toXContent(builder, params);
            }
            return builder;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(true);
            out.writeCollection(this.getDecisions());
        }
    }
}

