/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.set.Sets;

public class AllocationDeciders {
    private static final Logger logger = LogManager.getLogger(AllocationDeciders.class);
    private static final Decision NO_IGNORING_SHARD_FOR_NODE = Decision.single(Decision.Type.NO, "ignored_shards_for_node", "shard temporarily ignored for node due to earlier failure", new Object[0]);
    private final AllocationDecider[] deciders;

    public AllocationDeciders(Collection<? extends AllocationDecider> deciders) {
        this.deciders = (AllocationDecider[])deciders.toArray(AllocationDecider[]::new);
    }

    public Decision canAllocate(ShardRouting shardRouting, RoutingAllocation allocation) {
        return this.withDeciders(allocation, (AllocationDecider decider) -> decider.canAllocate(shardRouting, allocation), (String decider, Decision decision) -> Strings.format("Can not allocate [%s] on any node. [%s]: %s", shardRouting, decider, decision));
    }

    public Decision canAllocate(IndexMetadata indexMetadata, RoutingNode node, RoutingAllocation allocation) {
        return this.withDeciders(allocation, (AllocationDecider decider) -> decider.canAllocate(indexMetadata, node, allocation), (String decider, Decision decision) -> Strings.format("Can not allocate [%s] on node [%s]. [%s]: %s", indexMetadata.getIndex().getName(), node.node(), decider, decision));
    }

    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.withDecidersCheckingShardIgnoredNodes(allocation, shardRouting, node, decider -> decider.canAllocate(shardRouting, node, allocation), (decider, decision) -> Strings.format("Can not allocate [%s] on node [%s]. [%s]: %s", shardRouting, node.node(), decider, decision));
    }

    public Decision canRebalance(RoutingAllocation allocation) {
        return this.withDeciders(allocation, (AllocationDecider decider) -> decider.canRebalance(allocation), (String decider, Decision decision) -> Strings.format("Can not rebalance. [%s]: %s", decider, decision));
    }

    public Decision canRebalance(ShardRouting shardRouting, RoutingAllocation allocation) {
        assert (shardRouting.started()) : "Only started shard could be rebalanced: " + String.valueOf(shardRouting);
        return this.withDeciders(allocation, (AllocationDecider decider) -> decider.canRebalance(shardRouting, allocation), (String decider, Decision decision) -> Strings.format("Can not rebalance [%s]. [%s]: %s", shardRouting, decider, decision));
    }

    public Decision canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        IndexMetadata indexMetadata = allocation.metadata().indexMetadata(shardRouting.index());
        return this.withDecidersCheckingShardIgnoredNodes(allocation, shardRouting, node, decider -> decider.canRemain(indexMetadata, shardRouting, node, allocation), (decider, decision) -> Strings.format("Can not remain [%s] on node [%s]. [%s]: %s", shardRouting, node, decider, decision));
    }

    public Decision shouldAutoExpandToNode(IndexMetadata indexMetadata, DiscoveryNode node, RoutingAllocation allocation) {
        return this.withDeciders(allocation, (AllocationDecider decider) -> decider.shouldAutoExpandToNode(indexMetadata, node, allocation), (String decider, Decision decision) -> Strings.format("Should not auto expand [%s] to node [%s]. [%s]: %s", indexMetadata.getIndex().getName(), node, decider, decision));
    }

    public Decision canForceAllocatePrimary(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        assert (shardRouting.primary()) : "must not call canForceAllocatePrimary on a non-primary shard routing " + String.valueOf(shardRouting);
        return this.withDecidersCheckingShardIgnoredNodes(allocation, shardRouting, node, decider -> decider.canForceAllocatePrimary(shardRouting, node, allocation), (decider, decision) -> Strings.format("Can not force allocate shard [%s] on node [%s]. [%s]: %s", shardRouting, node, decider, decision));
    }

    public Decision canForceAllocateDuringReplace(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.withDeciders(allocation, (AllocationDecider decider) -> decider.canForceAllocateDuringReplace(shardRouting, node, allocation), (String decider, Decision decision) -> Strings.format("Can not force allocate during replace shard [%s] on node [%s]. [%s]: %s", shardRouting, node, decider, decision));
    }

    public Decision canAllocateReplicaWhenThereIsRetentionLease(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.withDecidersCheckingShardIgnoredNodes(allocation, shardRouting, node, decider -> decider.canAllocateReplicaWhenThereIsRetentionLease(shardRouting, node, allocation), (decider, decision) -> Strings.format("Can not allocate replica when there is retention lease shard [%s] on node [%s]. [%s]: %s", shardRouting, node, decider, decision));
    }

    private Decision withDeciders(RoutingAllocation allocation, Function<AllocationDecider, Decision> deciderAction, BiFunction<String, Decision, String> logMessageCreator) {
        return this.withDeciders(allocation.getDebugMode(), deciderAction, logMessageCreator);
    }

    private Decision withDecidersCheckingShardIgnoredNodes(RoutingAllocation allocation, ShardRouting shardRouting, RoutingNode node, Function<AllocationDecider, Decision> deciderAction, BiFunction<String, Decision, String> logMessageCreator) {
        if (allocation.shouldIgnoreShardForNode(shardRouting.shardId(), node.nodeId())) {
            if (logger.isTraceEnabled()) {
                logger.trace(() -> logMessageCreator.apply(AllocationDeciders.class.getSimpleName(), NO_IGNORING_SHARD_FOR_NODE));
            }
            return NO_IGNORING_SHARD_FOR_NODE;
        }
        return this.withDeciders(allocation.getDebugMode(), deciderAction, logMessageCreator);
    }

    private Decision withDeciders(RoutingAllocation.DebugMode debugMode, Function<AllocationDecider, Decision> deciderAction, BiFunction<String, Decision, String> logMessageCreator) {
        if (debugMode == RoutingAllocation.DebugMode.OFF) {
            Decision mostNegativeDecision = Decision.YES;
            for (AllocationDecider decider : this.deciders) {
                Decision decision = deciderAction.apply(decider);
                if (mostNegativeDecision.type().compareToBetweenDecisions(decision.type()) <= 0 || (mostNegativeDecision = decision).type() != Decision.Type.NO) continue;
                this.traceNoDecisions(decider, decision, logMessageCreator);
                break;
            }
            return mostNegativeDecision;
        }
        Decision.Multi multiDecision = new Decision.Multi();
        for (AllocationDecider decider : this.deciders) {
            Decision decision = deciderAction.apply(decider);
            this.traceNoDecisions(decider, decision, logMessageCreator);
            if (decision == Decision.ALWAYS || debugMode != RoutingAllocation.DebugMode.ON && decision.type() == Decision.Type.YES) continue;
            multiDecision.add(decision);
        }
        return multiDecision;
    }

    private void traceNoDecisions(AllocationDecider decider, Decision decision, BiFunction<String, Decision, String> logMessageCreator) {
        if (logger.isTraceEnabled() && decision.type() == Decision.Type.NO) {
            logger.trace(() -> logMessageCreator.apply(decider.getClass().getSimpleName(), decision));
        }
    }

    public Optional<Set<String>> getForcedInitialShardAllocationToNodes(ShardRouting shardRouting, RoutingAllocation allocation) {
        Optional<Set<String>> result = Optional.empty();
        for (AllocationDecider decider : this.deciders) {
            Optional<Set<String>> forcedInitialNodeIds = decider.getForcedInitialShardAllocationToNodes(shardRouting, allocation);
            if (!forcedInitialNodeIds.isPresent()) continue;
            result = result.map(nodeIds -> Sets.intersection(nodeIds, (Set)forcedInitialNodeIds.get())).or(() -> forcedInitialNodeIds);
        }
        return result;
    }
}

