/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.allocator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalanceMetrics;
import org.elasticsearch.core.Strings;

public record BalancingRoundSummary(Map<DiscoveryNode, NodesWeightsChanges> nodeToWeightChanges, long numberOfShardsToMove) {
    @Override
    public String toString() {
        return "BalancingRoundSummary{nodeToWeightChanges" + String.valueOf(this.nodeToWeightChanges) + ", numberOfShardsToMove=" + this.numberOfShardsToMove + "}";
    }

    public record CombinedBalancingRoundSummary(int numberOfBalancingRounds, Map<DiscoveryNode, NodesWeightsChanges> nodeToWeightChanges, long numberOfShardMoves) {
        public static final CombinedBalancingRoundSummary EMPTY_RESULTS = new CombinedBalancingRoundSummary(0, new HashMap<DiscoveryNode, NodesWeightsChanges>(), 0L);

        @Override
        public String toString() {
            HashMap nodeNameToWeightChanges = new HashMap(this.nodeToWeightChanges.size());
            this.nodeToWeightChanges.forEach((node, nodesWeightChanges) -> nodeNameToWeightChanges.put(node.getName(), nodesWeightChanges));
            return Strings.format((String)"CombinedBalancingRoundSummary[numberOfBalancingRounds=%d, nodeToWeightChange=%s, numberOfShardMoves=%d]", (Object[])new Object[]{this.numberOfBalancingRounds, nodeNameToWeightChanges, this.numberOfShardMoves});
        }

        public static CombinedBalancingRoundSummary combine(List<BalancingRoundSummary> summaries) {
            if (summaries.isEmpty()) {
                return EMPTY_RESULTS;
            }
            HashMap<DiscoveryNode, NodesWeightsChanges> combinedNodeNameToWeightChanges = new HashMap<DiscoveryNode, NodesWeightsChanges>();
            long numberOfShardMoves = 0L;
            int numSummaries = 0;
            for (BalancingRoundSummary summary : summaries) {
                for (Map.Entry<DiscoveryNode, NodesWeightsChanges> nodeNameAndWeights : summary.nodeToWeightChanges.entrySet()) {
                    NodesWeightsChanges combined = (NodesWeightsChanges)combinedNodeNameToWeightChanges.get(nodeNameAndWeights.getKey());
                    if (combined == null) {
                        combinedNodeNameToWeightChanges.put(nodeNameAndWeights.getKey(), nodeNameAndWeights.getValue());
                        continue;
                    }
                    NodesWeightsChanges newCombinedChanges = new NodesWeightsChanges(combined.baseWeights, combined.weightsDiff.combine(nodeNameAndWeights.getValue().weightsDiff()));
                    combinedNodeNameToWeightChanges.put(nodeNameAndWeights.getKey(), newCombinedChanges);
                }
                ++numSummaries;
                numberOfShardMoves += summary.numberOfShardsToMove();
            }
            return new CombinedBalancingRoundSummary(numSummaries, combinedNodeNameToWeightChanges, numberOfShardMoves);
        }
    }

    record NodeWeightsDiff(long shardCountDiff, double diskUsageInBytesDiff, double writeLoadDiff, double totalWeightDiff) {
        public static NodeWeightsDiff create(DesiredBalanceMetrics.NodeWeightStats base, DesiredBalanceMetrics.NodeWeightStats next) {
            return new NodeWeightsDiff(next.shardCount() - base.shardCount(), next.diskUsageInBytes() - base.diskUsageInBytes(), next.writeLoad() - base.writeLoad(), next.nodeWeight() - base.nodeWeight());
        }

        public NodeWeightsDiff combine(NodeWeightsDiff otherDiff) {
            return new NodeWeightsDiff(this.shardCountDiff + otherDiff.shardCountDiff, this.diskUsageInBytesDiff + otherDiff.diskUsageInBytesDiff, this.writeLoadDiff + otherDiff.writeLoadDiff, this.totalWeightDiff + otherDiff.totalWeightDiff);
        }
    }

    record NodesWeightsChanges(DesiredBalanceMetrics.NodeWeightStats baseWeights, NodeWeightsDiff weightsDiff) {
    }
}

