/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.allocator;

import org.elasticsearch.cluster.ClusterModule;
import org.elasticsearch.cluster.routing.allocation.allocator.BalancedShardsAllocator;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;

public class BalancerSettings {
    public static final BalancerSettings DEFAULT = new BalancerSettings(ClusterSettings.createBuiltInClusterSettings());
    private volatile float indexBalanceFactor;
    private volatile float shardBalanceFactor;
    private volatile float writeLoadBalanceFactor;
    private volatile float diskUsageBalanceFactor;
    private volatile float threshold;
    private final boolean completeEarlyOnShardAssignmentChange;

    public BalancerSettings(Settings settings) {
        this(ClusterSettings.createBuiltInClusterSettings(settings));
    }

    public BalancerSettings(ClusterSettings clusterSettings) {
        clusterSettings.initializeAndWatch(BalancedShardsAllocator.SHARD_BALANCE_FACTOR_SETTING, value -> {
            this.shardBalanceFactor = value.floatValue();
        });
        clusterSettings.initializeAndWatch(BalancedShardsAllocator.INDEX_BALANCE_FACTOR_SETTING, value -> {
            this.indexBalanceFactor = value.floatValue();
        });
        clusterSettings.initializeAndWatch(BalancedShardsAllocator.WRITE_LOAD_BALANCE_FACTOR_SETTING, value -> {
            this.writeLoadBalanceFactor = value.floatValue();
        });
        clusterSettings.initializeAndWatch(BalancedShardsAllocator.DISK_USAGE_BALANCE_FACTOR_SETTING, value -> {
            this.diskUsageBalanceFactor = value.floatValue();
        });
        clusterSettings.initializeAndWatch(BalancedShardsAllocator.THRESHOLD_SETTING, value -> {
            this.threshold = value.floatValue();
        });
        this.completeEarlyOnShardAssignmentChange = "desired_balance".equals(clusterSettings.get(ClusterModule.SHARDS_ALLOCATOR_TYPE_SETTING));
    }

    public float getIndexBalanceFactor() {
        return this.indexBalanceFactor;
    }

    public float getShardBalanceFactor() {
        return this.shardBalanceFactor;
    }

    public float getWriteLoadBalanceFactor() {
        return this.writeLoadBalanceFactor;
    }

    public float getDiskUsageBalanceFactor() {
        return this.diskUsageBalanceFactor;
    }

    public float getThreshold() {
        return this.threshold;
    }

    public boolean completeEarlyOnShardAssignmentChange() {
        return this.completeEarlyOnShardAssignmentChange;
    }
}

