/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.allocator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.IntroSorter;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ExpectedShardSizeEstimator;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.AllocateUnassignedDecision;
import org.elasticsearch.cluster.routing.allocation.AllocationDecision;
import org.elasticsearch.cluster.routing.allocation.MoveDecision;
import org.elasticsearch.cluster.routing.allocation.NodeAllocationResult;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.ShardAllocationDecision;
import org.elasticsearch.cluster.routing.allocation.WriteLoadForecaster;
import org.elasticsearch.cluster.routing.allocation.allocator.BalancerSettings;
import org.elasticsearch.cluster.routing.allocation.allocator.BalancingWeights;
import org.elasticsearch.cluster.routing.allocation.allocator.BalancingWeightsFactory;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalanceMetrics;
import org.elasticsearch.cluster.routing.allocation.allocator.GlobalBalancingWeightsFactory;
import org.elasticsearch.cluster.routing.allocation.allocator.NodeSorters;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.allocator.WeightFunction;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.gateway.PriorityComparator;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.injection.guice.Inject;

public class BalancedShardsAllocator
implements ShardsAllocator {
    private static final Logger logger = LogManager.getLogger(BalancedShardsAllocator.class);
    private static final Logger notPreferredLogger = LogManager.getLogger((String)(BalancedShardsAllocator.class.getName() + ".not_preferred"));
    public static final Setting<Float> SHARD_BALANCE_FACTOR_SETTING = Setting.floatSetting("cluster.routing.allocation.balance.shard", 0.45f, 0.0f, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Float> INDEX_BALANCE_FACTOR_SETTING = Setting.floatSetting("cluster.routing.allocation.balance.index", 0.55f, 0.0f, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Float> WRITE_LOAD_BALANCE_FACTOR_SETTING = Setting.floatSetting("cluster.routing.allocation.balance.write_load", 10.0f, 0.0f, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Float> DISK_USAGE_BALANCE_FACTOR_SETTING = Setting.floatSetting("cluster.routing.allocation.balance.disk_usage", 2.0E-11f, 0.0f, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Float> THRESHOLD_SETTING = Setting.floatSetting("cluster.routing.allocation.balance.threshold", 1.0f, 1.0f, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private final BalancerSettings balancerSettings;
    private final WriteLoadForecaster writeLoadForecaster;
    private final BalancingWeightsFactory balancingWeightsFactory;

    public BalancedShardsAllocator() {
        this(Settings.EMPTY);
    }

    public BalancedShardsAllocator(Settings settings) {
        this(new BalancerSettings(settings), WriteLoadForecaster.DEFAULT);
    }

    public BalancedShardsAllocator(BalancerSettings balancerSettings, WriteLoadForecaster writeLoadForecaster) {
        this(balancerSettings, writeLoadForecaster, new GlobalBalancingWeightsFactory(balancerSettings));
    }

    @Inject
    public BalancedShardsAllocator(BalancerSettings balancerSettings, WriteLoadForecaster writeLoadForecaster, BalancingWeightsFactory balancingWeightsFactory) {
        this.balancerSettings = balancerSettings;
        this.writeLoadForecaster = writeLoadForecaster;
        this.balancingWeightsFactory = balancingWeightsFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void allocate(RoutingAllocation allocation) {
        assert (!allocation.isSimulating() || this.balancerSettings.completeEarlyOnShardAssignmentChange()) : "inconsistent states: isSimulating [" + allocation.isSimulating() + "] vs completeEarlyOnShardAssignmentChange [" + this.balancerSettings.completeEarlyOnShardAssignmentChange() + "]";
        if (allocation.metadata().hasAnyIndices()) {
            this.writeLoadForecaster.refreshLicense();
        }
        assert (!allocation.ignoreDisable());
        assert (!allocation.isSimulating() || !allocation.routingNodes().hasInactiveShards()) : "expect no initializing shard, but got " + String.valueOf(allocation.routingNodes());
        assert (!allocation.isSimulating() || allocation.routingNodes().getRelocatingShardCount() == 0) : "expect no relocating shard, but got " + String.valueOf(allocation.routingNodes());
        if (allocation.routingNodes().size() == 0) {
            this.failAllocationOfNewPrimaries(allocation);
            return;
        }
        BalancingWeights balancingWeights = this.balancingWeightsFactory.create();
        Balancer balancer = new Balancer(this.writeLoadForecaster, allocation, this.balancerSettings.getThreshold(), balancingWeights, this.balancerSettings.completeEarlyOnShardAssignmentChange());
        boolean shardAssigned = false;
        boolean shardMoved = false;
        boolean shardBalanced = false;
        try {
            shardAssigned = balancer.allocateUnassigned();
            if (shardAssigned && this.balancerSettings.completeEarlyOnShardAssignmentChange()) {
                return;
            }
            shardMoved = balancer.moveShards();
            if (shardMoved && this.balancerSettings.completeEarlyOnShardAssignmentChange()) {
                return;
            }
            shardBalanced = balancer.balance();
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug("shards assigned: {}, shards moved: {}, shards balanced: {}, routingNodes hasInactiveShards [{}], relocation count [{}]", (Object)shardAssigned, (Object)shardMoved, (Object)shardBalanced, (Object)allocation.routingNodes().hasInactiveShards(), (Object)allocation.routingNodes().getRelocatingShardCount());
            }
            assert (this.assertShardAssignmentChanges(allocation, shardAssigned, shardMoved, shardBalanced));
            this.collectAndRecordNodeWeightStats(balancer, balancingWeights, allocation);
        }
    }

    private boolean assertShardAssignmentChanges(RoutingAllocation allocation, boolean shardAssigned, boolean shardMoved, boolean shardBalanced) {
        if (!allocation.isSimulating()) {
            return true;
        }
        assert (!shardAssigned || allocation.routingNodes().hasInactiveShards()) : "expect initializing shard, but got " + String.valueOf(allocation.routingNodes());
        assert (!shardMoved && !shardBalanced || allocation.routingNodes().getRelocatingShardCount() > 0) : "expect relocating shard, but got " + String.valueOf(allocation.routingNodes());
        return true;
    }

    private void collectAndRecordNodeWeightStats(Balancer balancer, BalancingWeights balancingWeights, RoutingAllocation allocation) {
        HashMap<DiscoveryNode, DesiredBalanceMetrics.NodeWeightStats> nodeLevelWeights = new HashMap<DiscoveryNode, DesiredBalanceMetrics.NodeWeightStats>();
        for (Map.Entry<String, ModelNode> entry : balancer.nodes.entrySet()) {
            ModelNode node = entry.getValue();
            WeightFunction weightFunction = balancingWeights.weightFunctionForNode(node.routingNode);
            float nodeWeight = weightFunction.calculateNodeWeight(node.numShards(), balancer.avgShardsPerNode(), node.writeLoad(), balancer.avgWriteLoadPerNode(), node.diskUsageInBytes(), balancer.avgDiskUsageInBytesPerNode());
            nodeLevelWeights.put(node.routingNode.node(), new DesiredBalanceMetrics.NodeWeightStats(node.numShards(), node.diskUsageInBytes(), node.writeLoad(), nodeWeight));
        }
        allocation.routingNodes().setBalanceWeightStatsPerNode(nodeLevelWeights);
    }

    @Override
    public ShardAllocationDecision explainShardAllocation(ShardRouting shard, RoutingAllocation allocation) {
        Balancer balancer = new Balancer(this.writeLoadForecaster, allocation, this.balancerSettings.getThreshold(), this.balancingWeightsFactory.create(), this.balancerSettings.completeEarlyOnShardAssignmentChange());
        AllocateUnassignedDecision allocateUnassignedDecision = AllocateUnassignedDecision.NOT_TAKEN;
        MoveDecision moveDecision = MoveDecision.NOT_TAKEN;
        ProjectIndex index = new ProjectIndex(allocation, shard);
        if (shard.unassigned()) {
            allocateUnassignedDecision = balancer.decideAllocateUnassigned(index, shard);
        } else {
            moveDecision = balancer.decideMove(index, shard);
            if (moveDecision.isDecisionTaken() && moveDecision.canRemain()) {
                moveDecision = balancer.explainRebalanceDecision(index, shard, moveDecision.getCanRemainDecision());
            }
        }
        return new ShardAllocationDecision(allocateUnassignedDecision, moveDecision);
    }

    private void failAllocationOfNewPrimaries(RoutingAllocation allocation) {
        RoutingNodes routingNodes = allocation.routingNodes();
        assert (routingNodes.size() == 0) : routingNodes;
        RoutingNodes.UnassignedShards.UnassignedIterator unassignedIterator = routingNodes.unassigned().iterator();
        while (unassignedIterator.hasNext()) {
            ShardRouting shardRouting = unassignedIterator.next();
            UnassignedInfo unassignedInfo = shardRouting.unassignedInfo();
            if (!shardRouting.primary() || unassignedInfo.lastAllocationStatus() != UnassignedInfo.AllocationStatus.NO_ATTEMPT) continue;
            unassignedIterator.updateUnassigned(new UnassignedInfo(unassignedInfo.reason(), unassignedInfo.message(), unassignedInfo.failure(), unassignedInfo.failedAllocations(), unassignedInfo.unassignedTimeNanos(), unassignedInfo.unassignedTimeMillis(), unassignedInfo.delayed(), UnassignedInfo.AllocationStatus.DECIDERS_NO, unassignedInfo.failedNodeIds(), unassignedInfo.lastAllocatedNodeId()), shardRouting.recoverySource(), allocation.changes());
        }
    }

    public static class Balancer {
        private final WriteLoadForecaster writeLoadForecaster;
        private final RoutingAllocation allocation;
        private final RoutingNodes routingNodes;
        private final Metadata metadata;
        private final float threshold;
        private final float avgShardsPerNode;
        private final double avgWriteLoadPerNode;
        private final double avgDiskUsageInBytesPerNode;
        private final Map<String, ModelNode> nodes;
        private final BalancingWeights balancingWeights;
        private final NodeSorters nodeSorters;
        private final boolean completeEarlyOnShardAssignmentChange;
        private static final Comparator<ShardRouting> BY_DESCENDING_SHARD_ID = (s1, s2) -> Integer.compare(s2.id(), s1.id());
        private ShardRouting[] shardRoutingsOnMaxWeightNode;

        private Balancer(WriteLoadForecaster writeLoadForecaster, RoutingAllocation allocation, float threshold, BalancingWeights balancingWeights, boolean completeEarlyOnShardAssignmentChange) {
            this.writeLoadForecaster = writeLoadForecaster;
            this.allocation = allocation;
            this.routingNodes = allocation.routingNodes();
            this.metadata = allocation.metadata();
            this.threshold = threshold;
            this.avgShardsPerNode = WeightFunction.avgShardPerNode(this.metadata, this.routingNodes);
            this.avgWriteLoadPerNode = WeightFunction.avgWriteLoadPerNode(writeLoadForecaster, this.metadata, this.routingNodes);
            this.avgDiskUsageInBytesPerNode = balancingWeights.diskUsageIgnored() ? 0.0 : WeightFunction.avgDiskUsageInBytesPerNode(allocation.clusterInfo(), this.metadata, this.routingNodes);
            this.nodes = Collections.unmodifiableMap(this.buildModelFromAssigned(balancingWeights.diskUsageIgnored()));
            this.nodeSorters = balancingWeights.createNodeSorters(this.nodesArray(), this);
            this.balancingWeights = balancingWeights;
            this.completeEarlyOnShardAssignmentChange = completeEarlyOnShardAssignmentChange;
        }

        private static long getShardDiskUsageInBytes(ShardRouting shardRouting, IndexMetadata indexMetadata, ClusterInfo clusterInfo) {
            if (indexMetadata.ignoreDiskWatermarks()) {
                return 0L;
            }
            return Math.max(indexMetadata.getForecastedShardSizeInBytes().orElse(0L), clusterInfo.getShardSize(shardRouting, 0L));
        }

        private float getShardWriteLoad(ProjectIndex index) {
            ProjectMetadata projectMetadata = this.metadata.getProject(index.project);
            return (float)this.writeLoadForecaster.getForecastedWriteLoad(projectMetadata.index(index.indexName)).orElse(0.0);
        }

        private float maxShardSizeBytes(ProjectIndex index) {
            IndexMetadata indexMetadata = this.indexMetadata(index);
            if (indexMetadata.ignoreDiskWatermarks()) {
                return 0.0f;
            }
            long maxShardSizeBytes = indexMetadata.getForecastedShardSizeInBytes().orElse(0L);
            for (int shard = 0; shard < indexMetadata.getNumberOfShards(); ++shard) {
                ShardId shardId = new ShardId(indexMetadata.getIndex(), shard);
                maxShardSizeBytes = Balancer.maxWithNullable(maxShardSizeBytes, this.allocation.clusterInfo().getShardSize(shardId, true));
                maxShardSizeBytes = Balancer.maxWithNullable(maxShardSizeBytes, this.allocation.clusterInfo().getShardSize(shardId, false));
            }
            return maxShardSizeBytes;
        }

        private static long maxWithNullable(long accumulator, Long newValue) {
            return newValue == null ? accumulator : Math.max(accumulator, newValue);
        }

        private ModelNode[] nodesArray() {
            return (ModelNode[])this.nodes.values().toArray(ModelNode[]::new);
        }

        public float avgShardsPerNode(ProjectIndex index) {
            return (float)this.indexMetadata(index).getTotalNumberOfShards() / (float)this.nodes.size();
        }

        public float avgShardsPerNode() {
            return this.avgShardsPerNode;
        }

        public double avgWriteLoadPerNode() {
            return this.avgWriteLoadPerNode;
        }

        public double avgDiskUsageInBytesPerNode() {
            return this.avgDiskUsageInBytesPerNode;
        }

        private static float absDelta(float lower, float higher) {
            assert (higher >= lower) : higher + " lt " + lower + " but was expected to be gte";
            return Math.abs(higher - lower);
        }

        private static boolean lessThan(float delta, float threshold) {
            return delta <= threshold + 0.001f;
        }

        private IndexMetadata indexMetadata(ProjectIndex index) {
            return this.metadata.getProject(index.project).index(index.indexName);
        }

        private boolean balance() {
            if (logger.isTraceEnabled()) {
                logger.trace("Start balancing cluster");
            }
            if (this.allocation.hasPendingAsyncFetch()) {
                logger.debug("skipping rebalance due to in-flight shard/store fetches");
                return false;
            }
            if (this.allocation.deciders().canRebalance(this.allocation).type() != Decision.Type.YES) {
                logger.trace("skipping rebalance as it is disabled");
                return false;
            }
            boolean shardBalanced = false;
            for (NodeSorter nodeSorter : this.nodeSorters) {
                if (nodeSorter.modelNodes.length < 2) {
                    logger.trace("skipping rebalance as the partition has single node only");
                    continue;
                }
                if (!(shardBalanced |= this.balanceByWeights(nodeSorter)) || !this.completeEarlyOnShardAssignmentChange) continue;
                return true;
            }
            return shardBalanced;
        }

        private MoveDecision explainRebalanceDecision(ProjectIndex index, ShardRouting shard, Decision canRemain) {
            NodeSorter sorter = this.nodeSorters.sorterForShard(shard);
            index.assertMatch(shard);
            if (!shard.started()) {
                return MoveDecision.NOT_TAKEN;
            }
            Decision canRebalance = this.allocation.deciders().canRebalance(shard, this.allocation);
            sorter.reset(index);
            ModelNode[] modelNodes = sorter.modelNodes;
            String currentNodeId = shard.currentNodeId();
            ModelNode currentNode = null;
            for (ModelNode node : modelNodes) {
                if (!node.getNodeId().equals(currentNodeId)) continue;
                currentNode = node;
                break;
            }
            assert (currentNode != null) : "currently assigned node could not be found";
            float currentWeight = sorter.getWeightFunction().calculateNodeWeightWithIndex(this, currentNode, index);
            AllocationDeciders deciders = this.allocation.deciders();
            Decision.Type bestRebalanceCanAllocateDecisionType = Decision.Type.NO;
            ModelNode targetNode = null;
            ArrayList<Tuple> betterBalanceNodes = new ArrayList<Tuple>();
            ArrayList<Tuple> sameBalanceNodes = new ArrayList<Tuple>();
            ArrayList<Tuple> worseBalanceNodes = new ArrayList<Tuple>();
            for (ModelNode node : modelNodes) {
                if (node == currentNode) continue;
                Decision canAllocate = deciders.canAllocate(shard, node.getRoutingNode(), this.allocation);
                float nodeWeight = sorter.getWeightFunction().calculateNodeWeightWithIndex(this, node, index);
                boolean betterWeightThanCurrent = nodeWeight <= currentWeight;
                boolean rebalanceConditionsMet = false;
                if (betterWeightThanCurrent) {
                    float localThreshold;
                    float currentDelta = Balancer.absDelta(nodeWeight, currentWeight);
                    boolean deltaAboveThreshold = !Balancer.lessThan(currentDelta, localThreshold = sorter.minWeightDelta() * this.threshold);
                    boolean betterWeightWithShardAdded = nodeWeight + localThreshold < currentWeight;
                    boolean bl = rebalanceConditionsMet = deltaAboveThreshold && betterWeightWithShardAdded;
                    if (rebalanceConditionsMet && canAllocate.type().compareToBetweenNodes(bestRebalanceCanAllocateDecisionType) > 0) {
                        bestRebalanceCanAllocateDecisionType = canAllocate.type();
                        if (canAllocate.type().compareToBetweenNodes(Decision.Type.NOT_PREFERRED) > 0) {
                            targetNode = node;
                        }
                    }
                }
                Tuple nodeResult = Tuple.tuple((Object)node, (Object)canAllocate);
                if (rebalanceConditionsMet) {
                    betterBalanceNodes.add(nodeResult);
                    continue;
                }
                if (betterWeightThanCurrent) {
                    sameBalanceNodes.add(nodeResult);
                    continue;
                }
                worseBalanceNodes.add(nodeResult);
            }
            int weightRanking = 0;
            ArrayList<NodeAllocationResult> nodeDecisions = new ArrayList<NodeAllocationResult>(modelNodes.length - 1);
            for (Tuple result : betterBalanceNodes) {
                nodeDecisions.add(new NodeAllocationResult(((ModelNode)result.v1()).routingNode.node(), AllocationDecision.fromDecisionType(((Decision)result.v2()).type()), (Decision)result.v2(), ++weightRanking));
            }
            int currentNodeWeightRanking = ++weightRanking;
            for (Tuple result : sameBalanceNodes) {
                AllocationDecision nodeDecision = ((Decision)result.v2()).type() == Decision.Type.NO ? AllocationDecision.NO : AllocationDecision.WORSE_BALANCE;
                nodeDecisions.add(new NodeAllocationResult(((ModelNode)result.v1()).routingNode.node(), nodeDecision, (Decision)result.v2(), currentNodeWeightRanking));
            }
            for (Tuple result : worseBalanceNodes) {
                AllocationDecision nodeDecision = ((Decision)result.v2()).type() == Decision.Type.NO ? AllocationDecision.NO : AllocationDecision.WORSE_BALANCE;
                nodeDecisions.add(new NodeAllocationResult(((ModelNode)result.v1()).routingNode.node(), nodeDecision, (Decision)result.v2(), ++weightRanking));
            }
            if (canRebalance.type() != Decision.Type.YES || this.allocation.hasPendingAsyncFetch()) {
                return MoveDecision.rebalance(canRemain, canRebalance, this.allocation.hasPendingAsyncFetch() ? AllocationDecision.AWAITING_INFO : AllocationDecision.fromDecisionType(canRebalance.type()), null, currentNodeWeightRanking, nodeDecisions);
            }
            return MoveDecision.rebalance(canRemain, canRebalance, AllocationDecision.fromDecisionType(bestRebalanceCanAllocateDecisionType), targetNode != null ? targetNode.routingNode.node() : null, currentNodeWeightRanking, nodeDecisions);
        }

        private boolean balanceByWeights(NodeSorter sorter) {
            boolean shardBalanced = false;
            AllocationDeciders deciders = this.allocation.deciders();
            ModelNode[] modelNodes = sorter.modelNodes;
            float[] weights = sorter.weights;
            block0: for (ProjectIndex index : this.buildWeightOrderedIndices(sorter)) {
                IndexMetadata indexMetadata = this.indexMetadata(index);
                int relevantNodes = 0;
                for (int i = 0; i < modelNodes.length; ++i) {
                    ModelNode modelNode = modelNodes[i];
                    if (modelNode.getIndex(index) == null && deciders.canAllocate(indexMetadata, modelNode.getRoutingNode(), this.allocation).type() == Decision.Type.NO) continue;
                    modelNodes[i] = modelNodes[relevantNodes];
                    modelNodes[relevantNodes] = modelNode;
                    ++relevantNodes;
                }
                if (relevantNodes < 2) continue;
                sorter.reset(index, 0, relevantNodes);
                int lowIdx = 0;
                int highIdx = relevantNodes - 1;
                float localThreshold = sorter.minWeightDelta() * this.threshold;
                while (true) {
                    ModelNode minNode = modelNodes[lowIdx];
                    ModelNode maxNode = modelNodes[highIdx];
                    if (maxNode.numShards(index) > 0) {
                        float delta = Balancer.absDelta(weights[lowIdx], weights[highIdx]);
                        if (Balancer.lessThan(delta, localThreshold)) {
                            if (lowIdx <= 0 || highIdx - 1 <= 0 || !(Balancer.absDelta(weights[0], weights[highIdx - 1]) > localThreshold)) {
                                if (!logger.isTraceEnabled()) continue block0;
                                logger.trace("Stop balancing index [{}]  min_node [{}] weight: [{}] max_node [{}] weight: [{}] delta: [{}]", (Object)index, (Object)maxNode.getNodeId(), (Object)Float.valueOf(weights[highIdx]), (Object)minNode.getNodeId(), (Object)Float.valueOf(weights[lowIdx]), (Object)Float.valueOf(delta));
                                continue block0;
                            }
                        } else {
                            if (logger.isTraceEnabled()) {
                                logger.trace("Balancing from node [{}] weight: [{}] to node [{}] weight: [{}] delta: [{}]", (Object)maxNode.getNodeId(), (Object)Float.valueOf(weights[highIdx]), (Object)minNode.getNodeId(), (Object)Float.valueOf(weights[lowIdx]), (Object)Float.valueOf(delta));
                            }
                            if (delta <= localThreshold) {
                                logger.trace("Couldn't find shard to relocate from node [{}] to node [{}]", (Object)maxNode.getNodeId(), (Object)minNode.getNodeId());
                            } else if (this.tryRelocateShard(minNode, maxNode, index)) {
                                weights[lowIdx] = sorter.weight(modelNodes[lowIdx]);
                                weights[highIdx] = sorter.weight(modelNodes[highIdx]);
                                sorter.sort(0, relevantNodes);
                                lowIdx = 0;
                                highIdx = relevantNodes - 1;
                                assert (!this.allocation.isSimulating() || this.routingNodes.getRelocatingShardCount() == 1) : "unexpected relocation shard count [" + this.routingNodes.getRelocatingShardCount() + "] when balancing index [" + String.valueOf(index) + "], isSimulating=[" + this.allocation.isSimulating() + "], earlyReturn=[" + this.completeEarlyOnShardAssignmentChange + "]";
                                if (this.routingNodes.getRelocatingShardCount() > 0) {
                                    shardBalanced = true;
                                }
                                if (!this.completeEarlyOnShardAssignmentChange || !shardBalanced) continue;
                                return true;
                            }
                        }
                    }
                    if (lowIdx < highIdx - 1) {
                        ++lowIdx;
                        continue;
                    }
                    if (lowIdx <= 0) continue block0;
                    lowIdx = 0;
                    --highIdx;
                }
            }
            return shardBalanced;
        }

        private ProjectIndex[] buildWeightOrderedIndices(NodeSorter sorter) {
            final ProjectIndex[] indices = (ProjectIndex[])this.allocation.globalRoutingTable().routingTables().entrySet().stream().flatMap(entry -> ((RoutingTable)entry.getValue()).indicesRouting().keySet().stream().map(index -> new ProjectIndex((ProjectId)entry.getKey(), (String)index))).toArray(ProjectIndex[]::new);
            final float[] deltas = new float[indices.length];
            for (int i = 0; i < deltas.length; ++i) {
                sorter.reset(indices[i]);
                deltas[i] = sorter.delta();
            }
            new IntroSorter(this){
                float pivotWeight;

                protected void swap(int i, int j) {
                    ProjectIndex tmpIdx = indices[i];
                    indices[i] = indices[j];
                    indices[j] = tmpIdx;
                    float tmpDelta = deltas[i];
                    deltas[i] = deltas[j];
                    deltas[j] = tmpDelta;
                }

                protected int compare(int i, int j) {
                    return Float.compare(deltas[j], deltas[i]);
                }

                protected void setPivot(int i) {
                    this.pivotWeight = deltas[i];
                }

                protected int comparePivot(int j) {
                    return Float.compare(deltas[j], this.pivotWeight);
                }
            }.sort(0, deltas.length);
            return indices;
        }

        public boolean moveShards() {
            boolean shardMoved = false;
            BestShardMovementsTracker bestNonPreferredShardMovementsTracker = new BestShardMovementsTracker();
            Iterator<ShardRouting> it = this.allocation.routingNodes().nodeInterleavedShardIterator();
            while (it.hasNext()) {
                ShardRouting shardRouting = it.next();
                ProjectIndex index = this.projectIndex(shardRouting);
                MoveDecision moveDecision = this.decideMove(index, shardRouting, bestNonPreferredShardMovementsTracker::shardIsBetterThanCurrent);
                assert (!moveDecision.isDecisionTaken() || !this.allocation.isSimulating() || moveDecision.getAllocationDecision() != AllocationDecision.THROTTLED) : "unexpected allocation decision [" + String.valueOf(moveDecision.getAllocationDecision()) + "] (isSimulating=" + this.allocation.isSimulating() + ") with " + (shardMoved ? "" : "no ") + "prior shard movements when moving shard [" + String.valueOf(shardRouting) + "]";
                if (moveDecision.isDecisionTaken() && moveDecision.cannotRemainAndCanMove()) {
                    if (moveDecision.getCanRemainDecision().type() == Decision.Type.NOT_PREFERRED) {
                        bestNonPreferredShardMovementsTracker.putBestMoveDecision(shardRouting, moveDecision);
                        continue;
                    }
                    this.executeMove(shardRouting, index, moveDecision, "move");
                    if (this.completeEarlyOnShardAssignmentChange) {
                        return true;
                    }
                    shardMoved = true;
                    continue;
                }
                if (!moveDecision.isDecisionTaken() || !moveDecision.cannotRemain()) continue;
                logger.trace("[{}][{}] can't move: [{}]", (Object)shardRouting.index(), (Object)shardRouting.id(), (Object)moveDecision);
            }
            for (BestShardMovementsTracker.StoredShardMovement storedShardMovement : bestNonPreferredShardMovementsTracker.getBestShardMovements()) {
                ShardRouting shardRouting = storedShardMovement.shardRouting();
                ProjectIndex index = this.projectIndex(shardRouting);
                MoveDecision moveDecision = this.refreshDecisionIfRequired(index, storedShardMovement, shardMoved);
                if (moveDecision.isDecisionTaken() && moveDecision.cannotRemainAndCanMove()) {
                    if (notPreferredLogger.isDebugEnabled()) {
                        notPreferredLogger.debug("Moving shard [{}] to [{}] from a NOT_PREFERRED allocation: {}", (Object)shardRouting, (Object)moveDecision.getTargetNode().getName(), (Object)moveDecision.getCanRemainDecision());
                    }
                    this.executeMove(shardRouting, index, moveDecision, "move-non-preferred");
                    return true;
                }
                logger.trace("[{}][{}] can no longer move (not-preferred)", (Object)shardRouting.index(), (Object)shardRouting.id());
            }
            return shardMoved;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private MoveDecision refreshDecisionIfRequired(ProjectIndex index, BestShardMovementsTracker.StoredShardMovement storedShardMovement, boolean shardMoved) {
            if (!notPreferredLogger.isDebugEnabled() && !shardMoved) {
                return storedShardMovement.moveDecision();
            }
            RoutingAllocation.DebugMode oldDebugMode = this.allocation.getDebugMode();
            if (notPreferredLogger.isDebugEnabled()) {
                this.allocation.setDebugMode(RoutingAllocation.DebugMode.EXCLUDE_YES_DECISIONS);
            }
            try {
                MoveDecision moveDecision = this.decideMove(index, storedShardMovement.shardRouting());
                return moveDecision;
            }
            finally {
                this.allocation.setDebugMode(oldDebugMode);
            }
        }

        private void executeMove(ShardRouting shardRouting, ProjectIndex index, MoveDecision moveDecision, String reason) {
            ModelNode sourceNode = this.nodes.get(shardRouting.currentNodeId());
            ModelNode targetNode = this.nodes.get(moveDecision.getTargetNode().getId());
            sourceNode.removeShard(index, shardRouting);
            Tuple<ShardRouting, ShardRouting> relocatingShards = this.routingNodes.relocateShard(shardRouting, targetNode.getNodeId(), this.allocation.clusterInfo().getShardSize(shardRouting, -1L), reason, this.allocation.changes());
            ShardRouting shard = (ShardRouting)relocatingShards.v2();
            targetNode.addShard(this.projectIndex(shard), shard);
            if (logger.isTraceEnabled()) {
                logger.trace("Moved shard [{}] to node [{}]", (Object)shardRouting, (Object)targetNode.getRoutingNode());
            }
        }

        public MoveDecision decideMove(ProjectIndex index, ShardRouting shardRouting) {
            return this.decideMove(index, shardRouting, ignored -> true);
        }

        private MoveDecision decideMove(ProjectIndex index, ShardRouting shardRouting, Predicate<ShardRouting> nonPreferredPredicate) {
            boolean shardsOnReplacedNode;
            NodeSorter sorter = this.nodeSorters.sorterForShard(shardRouting);
            index.assertMatch(shardRouting);
            if (!shardRouting.started()) {
                return MoveDecision.NOT_TAKEN;
            }
            ModelNode sourceNode = this.nodes.get(shardRouting.currentNodeId());
            assert (sourceNode != null && sourceNode.containsShard(index, shardRouting));
            RoutingNode routingNode = sourceNode.getRoutingNode();
            Decision canRemainDecision = this.allocation.deciders().canRemain(shardRouting, routingNode, this.allocation);
            if (canRemainDecision.type() != Decision.Type.NO && canRemainDecision.type() != Decision.Type.NOT_PREFERRED) {
                return MoveDecision.createRemainYesDecision(canRemainDecision);
            }
            if (canRemainDecision.type() == Decision.Type.NOT_PREFERRED && !nonPreferredPredicate.test(shardRouting)) {
                return MoveDecision.NOT_TAKEN;
            }
            sorter.reset(index);
            MoveDecision moveDecision = this.decideMove(sorter, shardRouting, sourceNode, canRemainDecision, this::decideCanAllocate);
            if (moveDecision.cannotRemainAndCannotMove() && (shardsOnReplacedNode = this.allocation.metadata().nodeShutdowns().contains(shardRouting.currentNodeId(), SingleNodeShutdownMetadata.Type.REPLACE))) {
                return this.decideMove(sorter, shardRouting, sourceNode, canRemainDecision, this::decideCanForceAllocateForVacate);
            }
            return moveDecision;
        }

        private MoveDecision decideMove(NodeSorter sorter, ShardRouting shardRouting, ModelNode sourceNode, Decision remainDecision, BiFunction<ShardRouting, RoutingNode, Decision> decider) {
            boolean explain = this.allocation.debugDecision();
            Decision.Type bestDecision = Decision.Type.NO;
            RoutingNode targetNode = null;
            ArrayList<NodeAllocationResult> nodeResults = explain ? new ArrayList<NodeAllocationResult>() : null;
            int weightRanking = 0;
            for (ModelNode currentNode : sorter.modelNodes) {
                if (currentNode == sourceNode) continue;
                RoutingNode target = currentNode.getRoutingNode();
                Decision allocationDecision = decider.apply(shardRouting, target);
                assert (allocationDecision.type() != Decision.Type.THROTTLE || !this.allocation.isSimulating()) : "DesiredBalance computations run in a simulation mode and should not encounter throttling";
                if (explain) {
                    nodeResults.add(new NodeAllocationResult(currentNode.getRoutingNode().node(), allocationDecision, ++weightRanking));
                }
                if (allocationDecision.type() == Decision.Type.NOT_PREFERRED && remainDecision.type() == Decision.Type.NOT_PREFERRED) {
                    bestDecision = Decision.Type.NOT_PREFERRED;
                    continue;
                }
                if (allocationDecision.type().compareToBetweenNodes(bestDecision) <= 0) continue;
                bestDecision = allocationDecision.type();
                if (bestDecision == Decision.Type.YES) {
                    targetNode = target;
                    if (explain) continue;
                    break;
                }
                if (bestDecision == Decision.Type.NOT_PREFERRED) {
                    assert (remainDecision.type() != Decision.Type.NOT_PREFERRED);
                    targetNode = target;
                    continue;
                }
                if (bestDecision != Decision.Type.THROTTLE) continue;
                assert (!this.allocation.isSimulating());
                targetNode = null;
            }
            return MoveDecision.move(remainDecision, AllocationDecision.fromDecisionType(bestDecision), targetNode != null ? targetNode.node() : null, nodeResults);
        }

        private Decision decideCanAllocate(ShardRouting shardRouting, RoutingNode target) {
            return this.allocation.deciders().canAllocate(shardRouting, target, this.allocation);
        }

        private Decision decideCanForceAllocateForVacate(ShardRouting shardRouting, RoutingNode target) {
            return this.allocation.deciders().canForceAllocateDuringReplace(shardRouting, target, this.allocation);
        }

        private Map<String, ModelNode> buildModelFromAssigned(boolean diskUsageIgnored) {
            Map<String, ModelNode> nodes = Maps.newMapWithExpectedSize(this.routingNodes.size());
            for (RoutingNode rn : this.routingNodes) {
                ModelNode node = new ModelNode(this.writeLoadForecaster, this.metadata, this.allocation.clusterInfo(), rn, diskUsageIgnored);
                nodes.put(rn.nodeId(), node);
                for (ShardRouting shard : rn) {
                    assert (rn.nodeId().equals(shard.currentNodeId()));
                    if (shard.state() == ShardRoutingState.RELOCATING) continue;
                    node.addShard(this.projectIndex(shard), shard);
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("Assigned shard [{}] to node [{}]", (Object)shard, (Object)node.getNodeId());
                }
            }
            return nodes;
        }

        private boolean allocateUnassigned() {
            RoutingNodes.UnassignedShards unassigned = this.routingNodes.unassigned();
            assert (!this.nodes.isEmpty());
            if (logger.isTraceEnabled()) {
                logger.trace("Start allocating unassigned shards");
            }
            if (unassigned.isEmpty()) {
                return false;
            }
            PriorityComparator secondaryComparator = PriorityComparator.getAllocationComparator(this.allocation);
            Comparator comparator = (o1, o2) -> {
                if (o1.primary() ^ o2.primary()) {
                    return o1.primary() ? -1 : 1;
                }
                if (o1.getIndexName().compareTo(o2.getIndexName()) == 0) {
                    return o1.getId() - o2.getId();
                }
                int secondary = secondaryComparator.compare((ShardRouting)o1, (ShardRouting)o2);
                assert (secondary != 0) : "Index names are equal, should be returned early.";
                return secondary;
            };
            Object[] primary = unassigned.drain();
            Object[] secondary = new ShardRouting[primary.length];
            int secondaryLength = 0;
            int primaryLength = primary.length;
            ArrayUtil.timSort((Object[])primary, (Comparator)comparator);
            boolean shardAssignmentChanged = false;
            do {
                for (int i = 0; i < primaryLength; ++i) {
                    long shardSize;
                    ModelNode minNode;
                    Object shard = primary[i];
                    ProjectIndex index = this.projectIndex((ShardRouting)shard);
                    AllocateUnassignedDecision allocationDecision = this.decideAllocateUnassigned(index, (ShardRouting)shard);
                    assert (allocationDecision.isDecisionTaken()) : "decision not taken for unassigned shard [" + String.valueOf(shard) + "]";
                    assert (!this.allocation.isSimulating() || allocationDecision.getAllocationStatus() != UnassignedInfo.AllocationStatus.DECIDERS_THROTTLED || shardAssignmentChanged) : "unexpected THROTTLE decision (isSimulating=" + this.allocation.isSimulating() + ") with no prior assignment when allocating unassigned shard [" + String.valueOf(shard) + "]";
                    String assignedNodeId = allocationDecision.getTargetNode() != null ? allocationDecision.getTargetNode().getId() : null;
                    ModelNode modelNode = minNode = assignedNodeId != null ? this.nodes.get(assignedNodeId) : null;
                    if (allocationDecision.getAllocationDecision() == AllocationDecision.YES) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("Assigned shard [{}] to [{}]", shard, (Object)minNode.getNodeId());
                        }
                        shardSize = ExpectedShardSizeEstimator.getExpectedShardSize((ShardRouting)shard, -1L, this.allocation);
                        shard = this.routingNodes.initializeShard((ShardRouting)shard, minNode.getNodeId(), null, shardSize, this.allocation.changes());
                        shardAssignmentChanged = true;
                        minNode.addShard(index, (ShardRouting)shard);
                        if (((ShardRouting)shard).primary()) continue;
                        while (i < primaryLength - 1 && comparator.compare(primary[i], primary[i + 1]) == 0) {
                            secondary[secondaryLength++] = primary[++i];
                        }
                        continue;
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("No eligible node found to assign shard [{}] allocation_status [{}]", shard, (Object)allocationDecision.getAllocationStatus());
                    }
                    if (minNode != null) {
                        assert (allocationDecision.getAllocationStatus() == UnassignedInfo.AllocationStatus.DECIDERS_THROTTLED);
                        shardSize = ExpectedShardSizeEstimator.getExpectedShardSize((ShardRouting)shard, -1L, this.allocation);
                        minNode.addShard(this.projectIndex((ShardRouting)shard), ((ShardRouting)shard).initialize(minNode.getNodeId(), null, shardSize));
                    } else if (logger.isTraceEnabled()) {
                        logger.trace("No Node found to assign shard [{}]", shard);
                    }
                    unassigned.ignoreShard((ShardRouting)shard, allocationDecision.getAllocationStatus(), this.allocation.changes());
                    if (((ShardRouting)shard).primary()) continue;
                    while (i < primaryLength - 1 && comparator.compare(primary[i], primary[i + 1]) == 0) {
                        unassigned.ignoreShard((ShardRouting)primary[++i], allocationDecision.getAllocationStatus(), this.allocation.changes());
                    }
                }
                primaryLength = secondaryLength;
                Object[] tmp = primary;
                primary = secondary;
                secondary = tmp;
                secondaryLength = 0;
            } while (primaryLength > 0);
            return shardAssignmentChanged;
        }

        private ProjectIndex projectIndex(ShardRouting shardRouting) {
            return new ProjectIndex(this.allocation, shardRouting);
        }

        private AllocateUnassignedDecision decideAllocateUnassigned(ProjectIndex index, ShardRouting shard) {
            WeightFunction weightFunction = this.balancingWeights.weightFunctionForShard(shard);
            index.assertMatch(shard);
            if (shard.assignedToNode()) {
                return AllocateUnassignedDecision.NOT_TAKEN;
            }
            boolean explain = this.allocation.debugDecision();
            Decision shardLevelDecision = this.allocation.deciders().canAllocate(shard, this.allocation);
            if (shardLevelDecision.type() == Decision.Type.NO && !explain) {
                return AllocateUnassignedDecision.no(UnassignedInfo.AllocationStatus.DECIDERS_NO, null);
            }
            float minWeight = Float.POSITIVE_INFINITY;
            ModelNode minNode = null;
            Decision decision = null;
            HashMap<String, NodeAllocationResult> nodeExplanationMap = explain ? new HashMap<String, NodeAllocationResult>() : null;
            ArrayList<Tuple> nodeWeights = explain ? new ArrayList<Tuple>() : null;
            for (ModelNode node : this.nodes.values()) {
                boolean updateMinNode;
                if (node.containsShard(index, shard) && !explain) continue;
                float currentWeight = weightFunction.calculateNodeWeightWithIndex(this, node, index);
                Decision currentDecision = this.allocation.deciders().canAllocate(shard, node.getRoutingNode(), this.allocation);
                if (explain) {
                    nodeExplanationMap.put(node.getNodeId(), new NodeAllocationResult(node.getRoutingNode().node(), currentDecision, 0));
                    nodeWeights.add(Tuple.tuple((Object)node.getNodeId(), (Object)Float.valueOf(currentWeight)));
                }
                if (currentDecision.type() != Decision.Type.YES && currentDecision.type() != Decision.Type.THROTTLE && currentDecision.type() != Decision.Type.NOT_PREFERRED) continue;
                if (currentWeight == minWeight) {
                    if (currentDecision.type() == decision.type()) {
                        int repId = shard.id();
                        int nodeHigh = node.highestPrimary(index);
                        int minNodeHigh = minNode.highestPrimary(index);
                        updateMinNode = (nodeHigh > repId && minNodeHigh > repId || nodeHigh < repId && minNodeHigh < repId) && nodeHigh < minNodeHigh || nodeHigh > repId && minNodeHigh < repId;
                    } else {
                        updateMinNode = currentDecision.type() == Decision.Type.YES || decision.type() == Decision.Type.NOT_PREFERRED;
                    }
                } else {
                    updateMinNode = Balancer.preferNewDecisionOverExisting(currentDecision, currentWeight, decision, minWeight);
                }
                if (!updateMinNode) continue;
                minNode = node;
                minWeight = currentWeight;
                decision = currentDecision;
            }
            if (decision == null) {
                decision = Decision.NO;
            }
            ArrayList<NodeAllocationResult> nodeDecisions = null;
            if (explain) {
                nodeDecisions = new ArrayList<NodeAllocationResult>();
                nodeWeights.sort((nodeWeight1, nodeWeight2) -> Float.compare(((Float)nodeWeight1.v2()).floatValue(), ((Float)nodeWeight2.v2()).floatValue()));
                int weightRanking = 0;
                for (Tuple nodeWeight : nodeWeights) {
                    NodeAllocationResult current = (NodeAllocationResult)nodeExplanationMap.get(nodeWeight.v1());
                    nodeDecisions.add(new NodeAllocationResult(current.getNode(), current.getCanAllocateDecision(), ++weightRanking));
                }
            }
            return AllocateUnassignedDecision.fromDecision(decision, minNode != null ? minNode.routingNode.node() : null, nodeDecisions);
        }

        private static boolean preferNewDecisionOverExisting(Decision newDecision, float newWeight, @Nullable Decision existingDecision, float existingWeight) {
            assert (newDecision != null) : "newDecision should never be null";
            assert (newDecision.type() == Decision.Type.YES || newDecision.type() == Decision.Type.NOT_PREFERRED || newDecision.type() == Decision.Type.THROTTLE) : "unsupported decision type: " + String.valueOf(newDecision.type());
            assert (newWeight != existingWeight) : "Equal weights should be handled elsewhere";
            if (existingDecision == null) {
                return true;
            }
            if (existingDecision.type() == newDecision.type()) {
                return newWeight < existingWeight;
            }
            float adjustedNewWeight = newDecision.type() == Decision.Type.NOT_PREFERRED ? Float.POSITIVE_INFINITY : newWeight;
            float adjustedExistingWeight = existingDecision.type() == Decision.Type.NOT_PREFERRED ? Float.POSITIVE_INFINITY : existingWeight;
            return adjustedNewWeight < adjustedExistingWeight;
        }

        private boolean tryRelocateShard(ModelNode minNode, ModelNode maxNode, ProjectIndex idx) {
            ModelIndex index = maxNode.getIndex(idx);
            if (index != null) {
                logger.trace("Try relocating shard of [{}] from [{}] to [{}]", (Object)idx, (Object)maxNode.getNodeId(), (Object)minNode.getNodeId());
                if (this.shardRoutingsOnMaxWeightNode == null || this.shardRoutingsOnMaxWeightNode.length < index.numShards()) {
                    this.shardRoutingsOnMaxWeightNode = new ShardRouting[index.numShards() * 2];
                }
                int startedShards = 0;
                for (ShardRouting shardRouting : index) {
                    if (!shardRouting.started()) continue;
                    this.shardRoutingsOnMaxWeightNode[startedShards] = shardRouting;
                    ++startedShards;
                }
                ArrayUtil.timSort((Object[])this.shardRoutingsOnMaxWeightNode, (int)0, (int)startedShards, BY_DESCENDING_SHARD_ID);
                AllocationDeciders deciders = this.allocation.deciders();
                for (int shardIndex = 0; shardIndex < startedShards; ++shardIndex) {
                    Decision allocationDecision;
                    ShardRouting shard = this.shardRoutingsOnMaxWeightNode[shardIndex];
                    Decision rebalanceDecision = deciders.canRebalance(shard, this.allocation);
                    if (rebalanceDecision.type() == Decision.Type.NO || (allocationDecision = deciders.canAllocate(shard, minNode.getRoutingNode(), this.allocation)).type() == Decision.Type.NO || allocationDecision.type() == Decision.Type.NOT_PREFERRED) continue;
                    Decision.Type canAllocateOrRebalance = Decision.minimumDecisionTypeThrottleOrYes(allocationDecision, rebalanceDecision);
                    maxNode.removeShard(this.projectIndex(shard), shard);
                    long shardSize = this.allocation.clusterInfo().getShardSize(shard, -1L);
                    logger.debug("decision [{}]: relocate [{}] from [{}] to [{}]", (Object)canAllocateOrRebalance, (Object)shard, (Object)maxNode.getNodeId(), (Object)minNode.getNodeId());
                    minNode.addShard(this.projectIndex(shard), canAllocateOrRebalance == Decision.Type.YES ? (ShardRouting)this.routingNodes.relocateShard(shard, minNode.getNodeId(), shardSize, "rebalance", this.allocation.changes()).v1() : shard.relocate(minNode.getNodeId(), shardSize));
                    return true;
                }
            }
            logger.trace("No shards of [{}] can relocate from [{}] to [{}]", (Object)idx, (Object)maxNode.getNodeId(), (Object)minNode.getNodeId());
            return false;
        }

        public RoutingAllocation getAllocation() {
            return this.allocation;
        }

        private class BestShardMovementsTracker {
            private final Map<String, StoredShardMovement> bestShardMovementsByNode = new LinkedHashMap<String, StoredShardMovement>();
            private final Map<String, PrioritiseByShardWriteLoadComparator> comparatorCache = new HashMap<String, PrioritiseByShardWriteLoadComparator>();

            private BestShardMovementsTracker() {
            }

            public boolean shardIsBetterThanCurrent(ShardRouting shardRouting) {
                StoredShardMovement currentShardForNode = this.bestShardMovementsByNode.get(shardRouting.currentNodeId());
                if (currentShardForNode == null) {
                    return true;
                }
                int comparison = this.comparatorCache.computeIfAbsent(shardRouting.currentNodeId(), nodeId -> new PrioritiseByShardWriteLoadComparator(Balancer.this.allocation.clusterInfo(), Balancer.this.allocation.routingNodes().node((String)nodeId))).compare(shardRouting, currentShardForNode.shardRouting());
                return comparison < 0;
            }

            public void putBestMoveDecision(ShardRouting shardRouting, MoveDecision moveDecision) {
                this.bestShardMovementsByNode.put(shardRouting.currentNodeId(), new StoredShardMovement(shardRouting, moveDecision));
            }

            public Iterable<StoredShardMovement> getBestShardMovements() {
                return this.bestShardMovementsByNode.values();
            }

            public record StoredShardMovement(ShardRouting shardRouting, MoveDecision moveDecision) {
            }
        }

        public static class PrioritiseByShardWriteLoadComparator
        implements Comparator<ShardRouting> {
            public static final double THRESHOLD_RATIO = 0.5;
            private static final double MISSING_WRITE_LOAD = -1.0;
            private final Map<ShardId, Double> shardWriteLoads;
            private final double maxWriteLoadOnNode;
            private final double threshold;
            private final String nodeId;

            public PrioritiseByShardWriteLoadComparator(ClusterInfo clusterInfo, RoutingNode routingNode) {
                this.shardWriteLoads = clusterInfo.getShardWriteLoads();
                double maxWriteLoadOnNode = -1.0;
                for (ShardRouting shardRouting : routingNode) {
                    maxWriteLoadOnNode = Math.max(maxWriteLoadOnNode, this.shardWriteLoads.getOrDefault(shardRouting.shardId(), -1.0));
                }
                this.maxWriteLoadOnNode = maxWriteLoadOnNode;
                this.threshold = maxWriteLoadOnNode * 0.5;
                this.nodeId = routingNode.nodeId();
            }

            @Override
            public int compare(ShardRouting lhs, ShardRouting rhs) {
                boolean lhsIsMissing;
                assert (this.nodeId.equals(lhs.currentNodeId()) && this.nodeId.equals(rhs.currentNodeId())) : this.getClass().getSimpleName() + " is node-specific. comparator=" + this.nodeId + ", lhs=" + lhs.currentNodeId() + ", rhs=" + rhs.currentNodeId();
                if (this.maxWriteLoadOnNode == -1.0) {
                    return 0;
                }
                double lhsWriteLoad = this.shardWriteLoads.getOrDefault(lhs.shardId(), -1.0);
                double rhsWriteLoad = this.shardWriteLoads.getOrDefault(rhs.shardId(), -1.0);
                boolean rhsIsMissing = rhsWriteLoad == -1.0;
                boolean bl = lhsIsMissing = lhsWriteLoad == -1.0;
                if (rhsIsMissing && lhsIsMissing) {
                    return 0;
                }
                if (rhsIsMissing ^ lhsIsMissing) {
                    return lhsIsMissing ? 1 : -1;
                }
                if (lhsWriteLoad < this.maxWriteLoadOnNode && rhsWriteLoad < this.maxWriteLoadOnNode) {
                    boolean rhsOverThreshold;
                    boolean lhsOverThreshold = lhsWriteLoad >= this.threshold;
                    boolean bl2 = rhsOverThreshold = rhsWriteLoad >= this.threshold;
                    if (lhsOverThreshold && rhsOverThreshold) {
                        return Double.compare(lhsWriteLoad, rhsWriteLoad);
                    }
                    if (lhsOverThreshold) {
                        return -1;
                    }
                    if (rhsOverThreshold) {
                        return 1;
                    }
                    return Double.compare(rhsWriteLoad, lhsWriteLoad);
                }
                return Double.compare(lhsWriteLoad, rhsWriteLoad);
            }
        }
    }

    public static class ModelNode
    implements Iterable<ModelIndex> {
        private int numShards = 0;
        private double writeLoad = 0.0;
        private double diskUsageInBytes = 0.0;
        private final WriteLoadForecaster writeLoadForecaster;
        private final Metadata metadata;
        private final ClusterInfo clusterInfo;
        private final RoutingNode routingNode;
        private final Map<ProjectIndex, ModelIndex> indices;
        private final boolean diskUsageIgnored;

        public ModelNode(WriteLoadForecaster writeLoadForecaster, Metadata metadata, ClusterInfo clusterInfo, RoutingNode routingNode, boolean diskUsageIgnored) {
            this.writeLoadForecaster = writeLoadForecaster;
            this.metadata = metadata;
            this.clusterInfo = clusterInfo;
            this.routingNode = routingNode;
            this.indices = Maps.newMapWithExpectedSize(routingNode.size() + 10);
            this.diskUsageIgnored = diskUsageIgnored;
        }

        public ModelIndex getIndex(ProjectIndex index) {
            return this.indices.get(index);
        }

        public String getNodeId() {
            return this.routingNode.nodeId();
        }

        public RoutingNode getRoutingNode() {
            return this.routingNode;
        }

        public int numShards() {
            return this.numShards;
        }

        public int numShards(ProjectIndex idx) {
            ModelIndex index = this.indices.get(idx);
            return index == null ? 0 : index.numShards();
        }

        public double writeLoad() {
            return this.writeLoad;
        }

        public double diskUsageInBytes() {
            return this.diskUsageInBytes;
        }

        public int highestPrimary(ProjectIndex index) {
            ModelIndex idx = this.indices.get(index);
            if (idx != null) {
                return idx.highestPrimary();
            }
            return -1;
        }

        public void addShard(ProjectIndex index, ShardRouting shard) {
            index.assertMatch(shard);
            this.indices.computeIfAbsent(index, t -> new ModelIndex()).addShard(shard);
            IndexMetadata indexMetadata = this.metadata.getProject(index.project).index(shard.index());
            this.writeLoad += this.writeLoadForecaster.getForecastedWriteLoad(indexMetadata).orElse(0.0);
            if (!this.diskUsageIgnored) {
                this.diskUsageInBytes += (double)Balancer.getShardDiskUsageInBytes(shard, indexMetadata, this.clusterInfo);
            }
            ++this.numShards;
        }

        public void removeShard(ProjectIndex projectIndex, ShardRouting shard) {
            ModelIndex index = this.indices.get(projectIndex);
            if (index != null) {
                index.removeShard(shard);
                if (index.numShards() == 0) {
                    this.indices.remove(projectIndex);
                }
            }
            IndexMetadata indexMetadata = this.metadata.getProject(projectIndex.project).index(shard.index());
            this.writeLoad -= this.writeLoadForecaster.getForecastedWriteLoad(indexMetadata).orElse(0.0);
            if (!this.diskUsageIgnored) {
                this.diskUsageInBytes -= (double)Balancer.getShardDiskUsageInBytes(shard, indexMetadata, this.clusterInfo);
            }
            --this.numShards;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Node(").append(this.routingNode.nodeId()).append(")");
            return sb.toString();
        }

        @Override
        public Iterator<ModelIndex> iterator() {
            return this.indices.values().iterator();
        }

        public boolean containsShard(ProjectIndex projIndex, ShardRouting shard) {
            projIndex.assertMatch(shard);
            ModelIndex index = this.getIndex(projIndex);
            return index != null && index.containsShard(shard);
        }
    }

    public record ProjectIndex(ProjectId project, String indexName) {
        ProjectIndex(RoutingAllocation allocation, ShardRouting shard) {
            this(allocation.metadata().projectFor(shard.index()).id(), shard.getIndexName());
        }

        public void assertMatch(ShardRouting shard) {
            assert (this.indexName.equals(shard.getIndexName())) : "Index name mismatch [" + String.valueOf(this) + "] vs [" + String.valueOf(shard) + "]";
        }
    }

    public static final class NodeSorter
    extends IntroSorter {
        final ModelNode[] modelNodes;
        final float[] weights;
        private final WeightFunction function;
        private ProjectIndex index;
        private final Balancer balancer;
        private float pivotWeight;

        public NodeSorter(ModelNode[] modelNodes, WeightFunction function, Balancer balancer) {
            this.function = function;
            this.balancer = balancer;
            this.modelNodes = modelNodes;
            this.weights = new float[modelNodes.length];
        }

        public void reset(ProjectIndex index, int from, int to) {
            this.index = index;
            for (int i = from; i < to; ++i) {
                this.weights[i] = this.weight(this.modelNodes[i]);
            }
            this.sort(from, to);
        }

        public void reset(ProjectIndex index) {
            this.reset(index, 0, this.modelNodes.length);
        }

        public float weight(ModelNode node) {
            return this.function.calculateNodeWeightWithIndex(this.balancer, node, this.index);
        }

        public float minWeightDelta() {
            return this.function.minWeightDelta(this.balancer.getShardWriteLoad(this.index), this.balancer.balancingWeights.diskUsageIgnored() ? 0.0f : this.balancer.maxShardSizeBytes(this.index));
        }

        protected void swap(int i, int j) {
            ModelNode tmpNode = this.modelNodes[i];
            this.modelNodes[i] = this.modelNodes[j];
            this.modelNodes[j] = tmpNode;
            float tmpWeight = this.weights[i];
            this.weights[i] = this.weights[j];
            this.weights[j] = tmpWeight;
        }

        protected int compare(int i, int j) {
            return Float.compare(this.weights[i], this.weights[j]);
        }

        protected void setPivot(int i) {
            this.pivotWeight = this.weights[i];
        }

        protected int comparePivot(int j) {
            return Float.compare(this.pivotWeight, this.weights[j]);
        }

        public float delta() {
            return this.weights.length == 0 ? 0.0f : this.weights[this.weights.length - 1] - this.weights[0];
        }

        public WeightFunction getWeightFunction() {
            return this.function;
        }
    }

    static final class ModelIndex
    implements Iterable<ShardRouting> {
        private final Set<ShardRouting> shards = Sets.newHashSetWithExpectedSize(4);
        private int highestPrimary = -1;

        ModelIndex() {
        }

        public int highestPrimary() {
            if (this.highestPrimary == -1) {
                int maxId = -1;
                for (ShardRouting shard : this.shards) {
                    if (!shard.primary()) continue;
                    maxId = Math.max(maxId, shard.id());
                }
                this.highestPrimary = maxId;
                return this.highestPrimary;
            }
            return this.highestPrimary;
        }

        public int numShards() {
            return this.shards.size();
        }

        @Override
        public Iterator<ShardRouting> iterator() {
            return this.shards.iterator();
        }

        public void removeShard(ShardRouting shard) {
            this.highestPrimary = -1;
            assert (this.shards.contains(shard)) : "Shard not allocated on current node: " + String.valueOf(shard);
            this.shards.remove(shard);
        }

        public void addShard(ShardRouting shard) {
            this.highestPrimary = -1;
            assert (!this.shards.contains(shard)) : "Shard already allocated on current node: " + String.valueOf(shard);
            this.shards.add(shard);
        }

        public boolean containsShard(ShardRouting shard) {
            return this.shards.contains(shard);
        }
    }
}

