/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public final class AllocationDecision
extends Enum<AllocationDecision>
implements Writeable {
    public static final /* enum */ AllocationDecision YES = new AllocationDecision(0);
    public static final /* enum */ AllocationDecision THROTTLED = new AllocationDecision(1);
    public static final /* enum */ AllocationDecision NOT_PREFERRED = new AllocationDecision(2);
    public static final /* enum */ AllocationDecision NO = new AllocationDecision(3);
    public static final /* enum */ AllocationDecision WORSE_BALANCE = new AllocationDecision(4);
    public static final /* enum */ AllocationDecision AWAITING_INFO = new AllocationDecision(5);
    public static final /* enum */ AllocationDecision ALLOCATION_DELAYED = new AllocationDecision(6);
    public static final /* enum */ AllocationDecision NO_VALID_SHARD_COPY = new AllocationDecision(7);
    public static final /* enum */ AllocationDecision NO_ATTEMPT = new AllocationDecision(8);
    final byte id;
    public static final TransportVersion ADD_NOT_PREFERRED_ALLOCATION_DECISION;
    private static final /* synthetic */ AllocationDecision[] $VALUES;

    public static AllocationDecision[] values() {
        return (AllocationDecision[])$VALUES.clone();
    }

    public static AllocationDecision valueOf(String name) {
        return Enum.valueOf(AllocationDecision.class, name);
    }

    private AllocationDecision(byte id) {
        this.id = id;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (!out.getTransportVersion().supports(ADD_NOT_PREFERRED_ALLOCATION_DECISION)) {
            if (this.id == AllocationDecision.NOT_PREFERRED.id) {
                out.write(AllocationDecision.YES.id);
            } else if (this.id > AllocationDecision.THROTTLED.id) {
                out.write(this.id - 1);
            } else {
                assert (this.id == AllocationDecision.YES.id || this.id == AllocationDecision.THROTTLED.id);
                out.write(this.id);
            }
        } else {
            out.writeByte(this.id);
        }
    }

    public static AllocationDecision readFrom(StreamInput in) throws IOException {
        byte id = in.readByte();
        if (!in.getTransportVersion().supports(ADD_NOT_PREFERRED_ALLOCATION_DECISION)) {
            return switch (id) {
                case 0 -> YES;
                case 1 -> THROTTLED;
                case 2 -> NO;
                case 3 -> WORSE_BALANCE;
                case 4 -> AWAITING_INFO;
                case 5 -> ALLOCATION_DELAYED;
                case 6 -> NO_VALID_SHARD_COPY;
                case 7 -> NO_ATTEMPT;
                default -> throw new IllegalArgumentException("Unknown value [" + id + "]");
            };
        }
        return switch (id) {
            case 0 -> YES;
            case 1 -> THROTTLED;
            case 2 -> NOT_PREFERRED;
            case 3 -> NO;
            case 4 -> WORSE_BALANCE;
            case 5 -> AWAITING_INFO;
            case 6 -> ALLOCATION_DELAYED;
            case 7 -> NO_VALID_SHARD_COPY;
            case 8 -> NO_ATTEMPT;
            default -> throw new IllegalArgumentException("Unknown value [" + id + "]");
        };
    }

    public static AllocationDecision fromAllocationStatus(UnassignedInfo.AllocationStatus allocationStatus) {
        if (allocationStatus == null) {
            return YES;
        }
        return switch (allocationStatus) {
            default -> throw new MatchException(null, null);
            case UnassignedInfo.AllocationStatus.DECIDERS_THROTTLED -> THROTTLED;
            case UnassignedInfo.AllocationStatus.FETCHING_SHARD_DATA -> AWAITING_INFO;
            case UnassignedInfo.AllocationStatus.DELAYED_ALLOCATION -> ALLOCATION_DELAYED;
            case UnassignedInfo.AllocationStatus.NO_VALID_SHARD_COPY -> NO_VALID_SHARD_COPY;
            case UnassignedInfo.AllocationStatus.NO_ATTEMPT -> NO_ATTEMPT;
            case UnassignedInfo.AllocationStatus.DECIDERS_NO -> NO;
        };
    }

    public static AllocationDecision fromDecisionType(Decision.Type type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case Decision.Type.YES -> YES;
            case Decision.Type.NOT_PREFERRED -> NOT_PREFERRED;
            case Decision.Type.THROTTLE -> THROTTLED;
            case Decision.Type.NO -> NO;
        };
    }

    public String toString() {
        return super.toString().toLowerCase(Locale.ROOT);
    }

    private static /* synthetic */ AllocationDecision[] $values() {
        return new AllocationDecision[]{YES, THROTTLED, NOT_PREFERRED, NO, WORSE_BALANCE, AWAITING_INFO, ALLOCATION_DELAYED, NO_VALID_SHARD_COPY, NO_ATTEMPT};
    }

    static {
        $VALUES = AllocationDecision.$values();
        ADD_NOT_PREFERRED_ALLOCATION_DECISION = TransportVersion.fromName("add_not_preferred_allocation_decision");
    }
}

