/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.UnaryOperator;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class RepositoriesMetadata
extends AbstractNamedDiffable<Metadata.ProjectCustom>
implements Metadata.ProjectCustom {
    public static final String TYPE = "repositories";
    public static final RepositoriesMetadata EMPTY = new RepositoriesMetadata(Collections.emptyList());
    public static final String HIDE_GENERATIONS_PARAM = "hide_generations";
    private final List<RepositoryMetadata> repositories;

    @Deprecated(forRemoval=true)
    public static RepositoriesMetadata get(ClusterState state) {
        return RepositoriesMetadata.get(state.metadata().getDefaultProject());
    }

    public static RepositoriesMetadata get(ProjectMetadata project) {
        return project.custom(TYPE, EMPTY);
    }

    public RepositoriesMetadata(List<RepositoryMetadata> repositories) {
        this.repositories = Collections.unmodifiableList(repositories);
    }

    public RepositoriesMetadata withUpdatedGeneration(String repoName, long safeGeneration, long pendingGeneration) {
        return this.withUpdate(repoName, repositoryMetadata -> new RepositoryMetadata((RepositoryMetadata)repositoryMetadata, safeGeneration, pendingGeneration));
    }

    public RepositoriesMetadata withUuid(String repoName, String uuid) {
        return this.withUpdate(repoName, repositoryMetadata -> repositoryMetadata.withUuid(uuid));
    }

    private RepositoriesMetadata withUpdate(String repoName, UnaryOperator<RepositoryMetadata> update) {
        int indexOfRepo = -1;
        for (int i = 0; i < this.repositories.size(); ++i) {
            if (!this.repositories.get(i).name().equals(repoName)) continue;
            indexOfRepo = i;
            break;
        }
        if (indexOfRepo < 0) {
            throw new IllegalArgumentException("Unknown repository [" + repoName + "]");
        }
        ArrayList<RepositoryMetadata> updatedRepos = new ArrayList<RepositoryMetadata>(this.repositories);
        updatedRepos.set(indexOfRepo, (RepositoryMetadata)update.apply(this.repositories.get(indexOfRepo)));
        return new RepositoriesMetadata(updatedRepos);
    }

    public List<RepositoryMetadata> repositories() {
        return this.repositories;
    }

    public RepositoryMetadata repository(String name) {
        for (RepositoryMetadata repository : this.repositories) {
            if (!name.equals(repository.name())) continue;
            return repository;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoriesMetadata that = (RepositoriesMetadata)o;
        return this.repositories.equals(that.repositories);
    }

    public boolean equalsIgnoreGenerations(@Nullable RepositoriesMetadata other) {
        if (other == null) {
            return false;
        }
        if (other.repositories.size() != this.repositories.size()) {
            return false;
        }
        for (int i = 0; i < this.repositories.size(); ++i) {
            if (this.repositories.get(i).equalsIgnoreGenerations(other.repositories.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.repositories.hashCode();
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.minimumCompatible();
    }

    public RepositoriesMetadata(StreamInput in) throws IOException {
        this.repositories = in.readCollectionAsImmutableList(RepositoryMetadata::new);
    }

    public static NamedDiff<Metadata.ProjectCustom> readDiffFrom(StreamInput in) throws IOException {
        return RepositoriesMetadata.readDiffFrom(Metadata.ProjectCustom.class, TYPE, in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.repositories);
    }

    public static RepositoriesMetadata fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        ArrayList<RepositoryMetadata> repository = new ArrayList<RepositoryMetadata>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                String name = parser.currentName();
                if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                    throw new ElasticsearchParseException("failed to parse repository [{}], expected object", name);
                }
                String uuid = "_na_";
                String type = null;
                Settings settings = Settings.EMPTY;
                long generation = -2L;
                long pendingGeneration = -1L;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        String currentFieldName = parser.currentName();
                        if ("uuid".equals(currentFieldName)) {
                            if (parser.nextToken() != XContentParser.Token.VALUE_STRING) {
                                throw new ElasticsearchParseException("failed to parse repository [{}], uuid not a string", name);
                            }
                            uuid = parser.text();
                            continue;
                        }
                        if ("type".equals(currentFieldName)) {
                            if (parser.nextToken() != XContentParser.Token.VALUE_STRING) {
                                throw new ElasticsearchParseException("failed to parse repository [{}], unknown type", name);
                            }
                            type = parser.text();
                            continue;
                        }
                        if ("settings".equals(currentFieldName)) {
                            if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                                throw new ElasticsearchParseException("failed to parse repository [{}], incompatible params", name);
                            }
                            settings = Settings.fromXContent(parser);
                            continue;
                        }
                        if ("generation".equals(currentFieldName)) {
                            if (parser.nextToken() != XContentParser.Token.VALUE_NUMBER) {
                                throw new ElasticsearchParseException("failed to parse repository [{}], unknown type", name);
                            }
                            generation = parser.longValue();
                            continue;
                        }
                        if ("pending_generation".equals(currentFieldName)) {
                            if (parser.nextToken() != XContentParser.Token.VALUE_NUMBER) {
                                throw new ElasticsearchParseException("failed to parse repository [{}], unknown type", name);
                            }
                            pendingGeneration = parser.longValue();
                            continue;
                        }
                        throw new ElasticsearchParseException("failed to parse repository [{}], unknown field [{}]", name, currentFieldName);
                    }
                    throw new ElasticsearchParseException("failed to parse repository [{}]", name);
                }
                if (type == null) {
                    throw new ElasticsearchParseException("failed to parse repository [{}], missing repository type", name);
                }
                repository.add(new RepositoryMetadata(name, uuid, type, settings, generation, pendingGeneration));
                continue;
            }
            throw new ElasticsearchParseException("failed to parse repositories", new Object[0]);
        }
        return new RepositoriesMetadata(repository);
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params ignored) {
        return Iterators.map(this.repositories.iterator(), repository -> (builder, params) -> RepositoriesMetadata.toXContent(repository, builder, params));
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.API_AND_GATEWAY;
    }

    public static XContentBuilder toXContent(RepositoryMetadata repository, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(repository.name());
        builder.field("type", repository.type());
        if (!repository.uuid().equals("_na_")) {
            builder.field("uuid", repository.uuid());
        }
        builder.startObject("settings");
        repository.settings().toXContent(builder, params);
        builder.endObject();
        if (!params.paramAsBoolean(HIDE_GENERATIONS_PARAM, false)) {
            builder.field("generation", repository.generation());
            builder.field("pending_generation", repository.pendingGeneration());
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString(this);
    }
}

